/*
 * Decompiled with CFR 0.152.
 */
package lol.sylvie.dissonance.discord;

import java.util.EnumSet;
import java.util.List;
import lol.sylvie.dissonance.Constants;
import lol.sylvie.dissonance.config.DissonanceConfig;
import lol.sylvie.dissonance.discord.DiscordToMinecraftBridge;
import lol.sylvie.dissonance.discord.command.impl.LinkCommand;
import lol.sylvie.dissonance.discord.command.impl.UnlinkCommand;
import lol.sylvie.dissonance.discord.events.DiscordEvents;
import lol.sylvie.dissonance.minecraft.MinecraftToDiscordBridge;
import lol.sylvie.dissonance.util.ConsoleUtil;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Activity;
import net.dv8tion.jda.api.entities.Webhook;
import net.dv8tion.jda.api.entities.WebhookClient;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import net.dv8tion.jda.api.exceptions.ErrorResponseException;
import net.dv8tion.jda.api.exceptions.InvalidTokenException;
import net.dv8tion.jda.api.requests.GatewayIntent;
import net.dv8tion.jda.api.utils.MemberCachePolicy;
import net.dv8tion.jda.api.utils.cache.CacheFlag;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class DiscordClient {
    public static JDA CLIENT = null;

    private static void ensureOutputs() {
        if (!MinecraftToDiscordBridge.ENABLED) {
            return;
        }
        TextChannel channel = MinecraftToDiscordBridge.getOutputChannel();
        if (channel == null || !channel.canTalk()) {
            ConsoleUtil.friendlyMessageBox("The output channel is invalid! Make sure the bot has access to/can type in it and that the ID is correct.");
            MinecraftToDiscordBridge.ENABLED = false;
            return;
        }
        if (!((Boolean)DissonanceConfig.USE_WEBHOOK_MESSAGES.get()).booleanValue()) {
            return;
        }
        try {
            String webhookUri = (String)DissonanceConfig.DISCORD_WEBHOOK.get();
            MinecraftToDiscordBridge.WEBHOOK = WebhookClient.createClient((JDA)CLIENT, (String)webhookUri);
            CLIENT.retrieveWebhookById(MinecraftToDiscordBridge.WEBHOOK.getId()).complete();
            return;
        }
        catch (IllegalArgumentException webhookUri) {
        }
        catch (ErrorResponseException exception) {
            Constants.LOG.error("Failed to fetch webhook!", (Throwable)exception);
        }
        if (channel.getGuild().getSelfMember().hasPermission((GuildChannel)channel, new Permission[]{Permission.MANAGE_WEBHOOKS})) {
            Constants.LOG.warn("Webhook is invalid, generating new one. (you should only see this once!)");
            Webhook webhook = (Webhook)channel.createWebhook("Dissonance").complete();
            String uri = webhook.getUrl();
            DissonanceConfig.DISCORD_WEBHOOK.set((Object)uri);
            MinecraftToDiscordBridge.WEBHOOK = WebhookClient.createClient((JDA)CLIENT, (String)uri);
            DissonanceConfig.SPEC.save();
        } else {
            ConsoleUtil.friendlyMessageBox("Webhook messages are enabled, but the stored URL is invalid and the bot doesn't have permission to make one.", "Either make one and specify it in the config file, or give the bot the \"Manage Webhooks\" permission.");
        }
    }

    private static void ensureInputs() {
        for (Long id : (List)DissonanceConfig.INPUT_CHANNELS.get()) {
            TextChannel channel;
            try {
                channel = CLIENT.getTextChannelById(id.longValue());
            }
            catch (NumberFormatException e) {
                Constants.LOG.error("Channel ID {} is invalid!", (Object)id);
                continue;
            }
            if (channel == null) {
                Constants.LOG.error("Cannot access channel {}, make sure the ID is valid and that the bot has the \"View Channel\" permission.", (Object)id);
                continue;
            }
            if (channel.getGuild().getSelfMember().hasPermission((GuildChannel)channel, new Permission[]{Permission.VIEW_CHANNEL})) continue;
            Constants.LOG.error("The bot can't read #{}, make sure that the bot has permission to view it.", (Object)channel.getName());
        }
    }

    @Nullable
    public static JDA createClientSafely(MinecraftServer server) {
        try {
            CLIENT = JDABuilder.createLight((String)((String)DissonanceConfig.DISCORD_TOKEN.get()), EnumSet.of(GatewayIntent.GUILD_VOICE_STATES, GatewayIntent.GUILD_MESSAGES, GatewayIntent.MESSAGE_CONTENT, GatewayIntent.GUILD_MEMBERS)).addEventListeners(new Object[]{new DiscordToMinecraftBridge(server)}).addEventListeners(new Object[]{new LinkCommand(), new UnlinkCommand()}).addEventListeners(new Object[]{new DiscordEvents()}).setMemberCachePolicy(MemberCachePolicy.ALL).enableCache(CacheFlag.VOICE_STATE, new CacheFlag[0]).build();
            CLIENT.awaitReady();
            CLIENT.addEventListener(new Object[0]);
            DiscordClient.ensureOutputs();
            DiscordClient.ensureInputs();
            DiscordClient.updateActivity(server);
        }
        catch (InvalidTokenException e) {
            ConsoleUtil.friendlyMessageBox("HEY, LISTEN! Your Discord token is invalid! (it's okay if this is the first time the server has been started)", "Please edit and fill out \"config/dissonance-server.toml\", then restart the server!");
        }
        catch (IllegalStateException | InterruptedException e) {
            Constants.LOG.error("The error in question: ", (Throwable)e);
            ConsoleUtil.friendlyMessageBox("There was an error while logging into Discord.", "Please ensure that you have the \"Server Members\" and \"Message Content\" intents turned on in the \"Bot\" section of the Discord developer portal.");
        }
        return CLIENT;
    }

    public static void updateActivity(MinecraftServer server) {
        if (!((Boolean)DissonanceConfig.ACTIVITY_ENABLED.get()).booleanValue()) {
            return;
        }
        Activity.ActivityType type = Activity.ActivityType.valueOf((String)((String)DissonanceConfig.ACTIVITY_TYPE.get()));
        String message = ((String)DissonanceConfig.ACTIVITY_TEMPLATE.get()).replace("%players%", String.valueOf(server.getPlayerCount())).replace("%max%", String.valueOf(server.getMaxPlayers()));
        CLIENT.getPresence().setActivity(Activity.of((Activity.ActivityType)type, (String)message, (String)((String)DissonanceConfig.STREAMING_URL.get())));
    }
}

