/*
 * Decompiled with CFR 0.152.
 */
package lol.sylvie.dissonance.discord.proximity;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lol.sylvie.dissonance.Constants;
import lol.sylvie.dissonance.config.DissonanceConfig;
import lol.sylvie.dissonance.discord.linking.DiscordLinking;
import lol.sylvie.dissonance.discord.proximity.ProximityGroup;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.GuildVoiceState;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.channel.ChannelType;
import net.dv8tion.jda.api.entities.channel.concrete.Category;
import net.dv8tion.jda.api.entities.channel.concrete.VoiceChannel;
import net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import net.dv8tion.jda.api.entities.channel.unions.AudioChannelUnion;
import net.dv8tion.jda.api.events.guild.voice.GuildVoiceUpdateEvent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiscordProximity {
    public static boolean ENABLED = false;
    public static final HashSet<Long> MUTED = new HashSet();
    public static final HashMap<UUID, ProximityGroup> playerToGroup = new HashMap();

    private static GuildVoiceState getNonEmptyState(Member member) {
        GuildVoiceState state = member.getVoiceState();
        if (state == null || state.getChannel() == null) {
            return null;
        }
        return state;
    }

    public static boolean isInProximityCategory(VoiceChannel channel) {
        return ((Long)DissonanceConfig.PROXIMITY_CATEGORY_ID.get()).equals(channel.getParentCategoryIdLong());
    }

    @Nullable
    public static VoiceChannel getVoiceChannel(Member member) {
        GuildVoiceState state = DiscordProximity.getNonEmptyState(member);
        if (state == null || state.getChannel() == null || state.getChannel().getType() != ChannelType.VOICE) {
            return null;
        }
        return state.getChannel().asVoiceChannel();
    }

    public static boolean isInProximityCategory(Member member) {
        VoiceChannel channel = DiscordProximity.getVoiceChannel(member);
        if (channel == null) {
            return false;
        }
        return DiscordProximity.isInProximityCategory(channel);
    }

    public static Category getCategory(Guild guild) {
        return guild.getCategoryById(((Long)DissonanceConfig.PROXIMITY_CATEGORY_ID.get()).longValue());
    }

    public static Category getCategory() {
        Guild guild = DiscordLinking.getGuild();
        if (guild == null) {
            return null;
        }
        return DiscordProximity.getCategory(guild);
    }

    public static VoiceChannel getLobbyChannel(@Nullable Guild guild) {
        if (guild == null) {
            return null;
        }
        return guild.getVoiceChannelById(((Long)DissonanceConfig.PROXIMITY_LOBBY_ID.get()).longValue());
    }

    public static void init() {
        boolean bl = ENABLED = (Boolean)DissonanceConfig.LINKING_ENABLED.get() != false && (Boolean)DissonanceConfig.PROXIMITY_ENABLED.get() != false;
        if (!ENABLED) {
            return;
        }
        Guild guild = DiscordLinking.getGuild();
        if (guild == null || DiscordProximity.getLobbyChannel(guild) == null) {
            ENABLED = false;
            Constants.LOG.error("Missing either linking guild or proximity channel!");
            return;
        }
        Category category = DiscordProximity.getCategory(guild);
        if (category == null || !guild.getSelfMember().hasPermission((GuildChannel)category, Set.of(Permission.MANAGE_CHANNEL, Permission.VOICE_MOVE_OTHERS))) {
            ENABLED = false;
            Constants.LOG.error("Cannot move members or delete channels in proximity category!");
            return;
        }
        if (ENABLED) {
            for (GuildChannel channel : category.getChannels()) {
                if (channel.getType() != ChannelType.VOICE || ((Long)DissonanceConfig.PROXIMITY_LOBBY_ID.get()).equals(channel.getIdLong())) continue;
                channel.delete().queue();
            }
            if (!guild.getSelfMember().hasPermission((GuildChannel)category, Set.of(Permission.MANAGE_PERMISSIONS, Permission.VOICE_MUTE_OTHERS)) && ((Boolean)DissonanceConfig.MUTE_LOBBY_MEMBERS.get()).booleanValue()) {
                Constants.LOG.error("Cannot mute lobby members! (the bot must have the Manage Permissions and Mute Members permissions for the category!)");
            }
            Constants.LOG.warn("Proximity chat is experimental. Use with caution!");
        }
    }

    public static void update(MinecraftServer server) {
        if (!ENABLED) {
            return;
        }
        int radius = (Integer)DissonanceConfig.PROXIMITY_RADIUS.get();
        int grace = (Integer)DissonanceConfig.PROXIMITY_GRACE_PERIOD.get();
        Set connected = server.getPlayerList().getPlayers().stream().filter(p -> {
            Member member = DiscordLinking.getMemberFromMinecraft(p.getUUID());
            return member != null && DiscordProximity.isInProximityCategory(member);
        }).collect(Collectors.toSet());
        int graceDist = radius + grace;
        int longDist = graceDist * graceDist;
        int shortDist = radius * radius;
        block0: for (ServerPlayer player : connected) {
            ProximityGroup ourGroup;
            UUID uuid = player.getUUID();
            if (playerToGroup.containsKey(uuid)) {
                ProximityGroup currentGroup = playerToGroup.get(uuid);
                if (!currentGroup.isInRadius(server, player, longDist)) {
                    currentGroup.remove(uuid, true, false);
                    playerToGroup.remove(uuid);
                }
            } else {
                for (ProximityGroup group2 : playerToGroup.values()) {
                    if (!group2.isInRadius(server, player, shortDist)) continue;
                    group2.add(uuid, true);
                    playerToGroup.put(uuid, group2);
                    continue block0;
                }
                for (ServerPlayer otherPlayer : connected) {
                    if (player.isDeadOrDying() || otherPlayer.isDeadOrDying() || otherPlayer.equals((Object)player) || otherPlayer.distanceToSqr((Entity)player) > (double)shortDist) continue;
                    UUID otherUuid = otherPlayer.getUUID();
                    ProximityGroup group3 = new ProximityGroup(List.of(uuid, otherUuid));
                    playerToGroup.put(uuid, group3);
                    playerToGroup.put(otherUuid, group3);
                }
            }
            if ((ourGroup = playerToGroup.get(uuid)) == null) continue;
            for (ProximityGroup group4 : new HashSet<ProximityGroup>(playerToGroup.values())) {
                ProximityGroup parentGroup;
                HashSet<UUID> affectedPlayers;
                if (ourGroup == group4 || !group4.isInRadius(server, player, shortDist)) continue;
                if (group4.players.size() > ourGroup.players.size()) {
                    affectedPlayers = ourGroup.players;
                    group4.merge(ourGroup);
                    parentGroup = group4;
                } else {
                    affectedPlayers = group4.players;
                    ourGroup.merge(group4);
                    parentGroup = ourGroup;
                }
                affectedPlayers.forEach(id -> playerToGroup.put((UUID)id, parentGroup));
                continue block0;
            }
        }
        Set.copyOf(playerToGroup.values()).forEach(group -> {
            for (UUID uuid : group.collectDisconnectedMembers()) {
                playerToGroup.remove(uuid);
                group.remove(uuid, false, true);
            }
            group.implodeIfNeeded();
            if (!group.isMarkedForRemoval()) {
                ArrayList groups = new ArrayList(group.split(server, longDist).stream().sorted(Comparator.comparing(Set::size)).toList().reversed());
                if (groups.size() == 1) {
                    return;
                }
                groups.removeFirst();
                for (Set newGroup : groups) {
                    ProximityGroup groupInstance = new ProximityGroup();
                    for (UUID member : newGroup) {
                        group.remove(member, false, false);
                        groupInstance.add(member, false);
                        playerToGroup.put(member, groupInstance);
                    }
                    groupInstance.createVoiceChannel();
                }
            }
        });
    }

    public static void onDisconnect(Player player) {
        UUID uuid = player.getUUID();
        if (!playerToGroup.containsKey(uuid)) {
            return;
        }
        ProximityGroup group = playerToGroup.get(uuid);
        group.remove(uuid, false, true);
        group.implodeIfNeeded();
        playerToGroup.remove(uuid);
    }

    public static void onGuildVoiceUpdate(@NotNull GuildVoiceUpdateEvent event) {
        AudioChannelUnion oldChannel = event.getChannelLeft();
        AudioChannelUnion newChannel = event.getChannelJoined();
        Long lobbyId = (Long)DissonanceConfig.PROXIMITY_LOBBY_ID.get();
        Member member = event.getEntity();
        Long memberId = member.getIdLong();
        Guild guild = event.getGuild();
        Category category = DiscordProximity.getCategory(guild);
        boolean mayMute = category != null && guild.getSelfMember().hasPermission((GuildChannel)category, Set.of(Permission.MANAGE_PERMISSIONS, Permission.VOICE_MUTE_OTHERS)) && (Boolean)DissonanceConfig.MUTE_LOBBY_MEMBERS.get() != false;
        boolean wasMuted = MUTED.contains(memberId);
        if (!mayMute) {
            return;
        }
        if ((oldChannel != null && lobbyId.equals(oldChannel.getIdLong()) || newChannel == null) && wasMuted) {
            member.mute(false).queue();
        } else if (newChannel != null && lobbyId.equals(newChannel.getIdLong())) {
            member.mute(true).queue();
            MUTED.add(memberId);
        }
    }
}

