/*
 * Decompiled with CFR 0.152.
 */
package lol.sylvie.dissonance;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import lol.sylvie.dissonance.Dissonance;
import lol.sylvie.dissonance.config.DissonanceConfig;
import lol.sylvie.dissonance.discord.linking.DiscordLinking;
import lol.sylvie.dissonance.minecraft.MinecraftEvents;
import lol.sylvie.dissonance.minecraft.MinecraftToDiscordBridge;
import lol.sylvie.dissonance.minecraft.command.MinecraftCommands;
import lol.sylvie.dissonance.permission.DissonancePermissions;
import lol.sylvie.dissonance.platform.NeoForgePlatformHelper;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.configuration.ServerConfigurationPacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.event.RegisterConfigurationTasksEvent;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContextKey;
import net.neoforged.neoforge.server.permission.nodes.PermissionNode;
import net.neoforged.neoforge.server.permission.nodes.PermissionTypes;

@Mod(value="dissonance")
public class NeoForgeDissonance {
    public static boolean ENABLE_MIXINS = false;

    public NeoForgeDissonance(ModContainer container, IEventBus bus) {
        container.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)DissonanceConfig.SPEC);
        Dissonance.modInit();
        NeoForge.EVENT_BUS.addListener(event -> DissonancePermissions.NODES.forEach((node, value) -> {
            PermissionNode permissionNode = new PermissionNode(ResourceLocation.fromNamespaceAndPath((String)"dissonance", (String)node.replaceFirst("dissonance.", "")), PermissionTypes.BOOLEAN, (p, u, c) -> value, new PermissionDynamicContextKey[0]);
            NeoForgePlatformHelper.NODES.put((String)node, (PermissionNode<Boolean>)permissionNode);
            event.addNodes(new PermissionNode[]{permissionNode});
        }));
        NeoForge.EVENT_BUS.addListener(event -> MinecraftCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher()));
        NeoForge.EVENT_BUS.addListener(event -> Dissonance.serverStarted(event.getServer(), () -> this.registerEvents(bus)));
        bus.addListener(this::onGatherLoginConfigurationTasks);
    }

    public void onGatherLoginConfigurationTasks(RegisterConfigurationTasksEvent event) {
        ServerConfigurationPacketListener serverConfigurationPacketListener = event.getListener();
        if (!(serverConfigurationPacketListener instanceof ServerConfigurationPacketListenerImpl)) {
            return;
        }
        ServerConfigurationPacketListenerImpl listener = (ServerConfigurationPacketListenerImpl)serverConfigurationPacketListener;
        GameProfile gameProfile = listener.getOwner();
        Component failureReason = DiscordLinking.canPlayerJoin(listener.server, gameProfile);
        if (failureReason == null) {
            return;
        }
        listener.disconnect(failureReason);
    }

    public void registerEvents(IEventBus bus) {
        ENABLE_MIXINS = true;
        NeoForge.EVENT_BUS.addListener(event -> Dissonance.serverStopping());
        NeoForge.EVENT_BUS.addListener(event -> MinecraftEvents.tick(event.getServer()));
        if (!MinecraftToDiscordBridge.ENABLED) {
            return;
        }
        NeoForge.EVENT_BUS.addListener(event -> MinecraftToDiscordBridge.onPlayerChatMessage((Player)event.getPlayer(), event.getRawText()));
        NeoForge.EVENT_BUS.addListener(event -> MinecraftEvents.onPlayerJoin(event.getEntity()));
        NeoForge.EVENT_BUS.addListener(event -> MinecraftEvents.onPlayerLeave(event.getEntity()));
    }
}

