/*
 * Decompiled with CFR 0.152.
 */
package lol.sylvie.dissonance.discord;

import java.net.URI;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lol.sylvie.dissonance.config.DissonanceConfig;
import lol.sylvie.dissonance.discord.MinecraftOwnedListener;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.channel.Channel;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class DiscordToMinecraftBridge
extends MinecraftOwnedListener {
    public static boolean ENABLED = true;
    public static final Pattern URL_PATTERN = Pattern.compile("https?://(?:www\\.)?[-a-zA-Z0-9@:%._+~#=]{1,256}\\.[a-zA-Z0-9()]{1,6}\\b[-a-zA-Z0-9()@:%_+.~#?&/=]*");

    public DiscordToMinecraftBridge(MinecraftServer server) {
        super(server);
    }

    public static MutableComponent optionallyColorMember(int color, MutableComponent component) {
        return (Boolean)DissonanceConfig.USE_ROLE_COLORS.get() != false ? component.withColor(color) : component;
    }

    @NotNull
    private static MutableComponent getAttachmentHover(Message.Attachment attachment) {
        boolean isImage;
        MutableComponent hoverComponent = Component.empty();
        if (attachment.getDescription() != null) {
            hoverComponent.append(attachment.getDescription() + "\n");
        }
        if ((isImage = attachment.isImage()) || attachment.isVideo()) {
            hoverComponent.append(String.format("%s dimensions: %sx%s", isImage ? "Image" : "Video", attachment.getWidth(), attachment.getHeight()));
        } else {
            hoverComponent.append("Content-Type: " + attachment.getContentType());
        }
        return hoverComponent;
    }

    public static MutableComponent formatDiscordContent(int roleColor, Message message) {
        String content = message.getContentDisplay();
        MutableComponent baseComponent = Component.empty();
        String colorSetting = (String)DissonanceConfig.LINK_COLOR.get();
        int color = 0xFFFFFF;
        if (colorSetting.equalsIgnoreCase("role")) {
            color = roleColor;
        } else {
            try {
                color = Integer.decode(colorSetting);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (((Boolean)DissonanceConfig.LINK_PARSING.get()).booleanValue()) {
            Matcher matcher = URL_PATTERN.matcher(content);
            int lastEnd = 0;
            while (matcher.find()) {
                baseComponent.append(content.substring(lastEnd, matcher.start()));
                String url = matcher.group(0);
                baseComponent.append((Component)Component.literal((String)url).withStyle(Style.EMPTY.withUnderlined(Boolean.valueOf(true)).withColor(color).withClickEvent((ClickEvent)new ClickEvent.OpenUrl(URI.create(url)))));
                lastEnd = matcher.end();
            }
            baseComponent.append((Component)Component.literal((String)content.substring(lastEnd)));
        } else {
            baseComponent.append(content);
        }
        if (((Boolean)DissonanceConfig.SHOW_ATTACHMENTS.get()).booleanValue()) {
            for (Message.Attachment attachment : message.getAttachments()) {
                MutableComponent hoverComponent = DiscordToMinecraftBridge.getAttachmentHover(attachment);
                String name = attachment.isSpoiler() ? "SPOILER" : attachment.getFileName();
                MutableComponent attachmentComponent = Component.literal((String)(" [" + name + "]")).withStyle(Style.EMPTY.withColor(color).withClickEvent((ClickEvent)new ClickEvent.OpenUrl(URI.create(attachment.getUrl()))).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)hoverComponent)));
                baseComponent.append((Component)attachmentComponent);
            }
        }
        return baseComponent;
    }

    public static Component formatDiscordMessage(Member member, Channel channel, Message message) {
        String template = (String)DissonanceConfig.MINECRAFT_MESSAGE_TEMPLATE.get();
        int color = member.getColorRaw();
        String usernameString = member.getUser().getName();
        MutableComponent username = DiscordToMinecraftBridge.optionallyColorMember(color, Component.literal((String)usernameString));
        MutableComponent nickname = DiscordToMinecraftBridge.optionallyColorMember(color, Component.literal((String)member.getEffectiveName()));
        if (((Boolean)DissonanceConfig.ADD_USERNAME_HOVER_TO_NICKNAME.get()).booleanValue()) {
            nickname = nickname.withStyle(nickname.getStyle().withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.literal((String)("@" + usernameString + " on Discord")))));
        }
        MutableComponent content = DiscordToMinecraftBridge.formatDiscordContent(color, message);
        MutableComponent channelName = Component.literal((String)channel.getName());
        MutableComponent fullMessage = Component.translatable((String)template, (Object[])new Object[]{username, nickname, content, channelName});
        if (((Boolean)DissonanceConfig.LINK_TO_MESSAGE.get()).booleanValue()) {
            try {
                URI jumpUri = URI.create(message.getJumpUrl());
                fullMessage = fullMessage.withStyle(fullMessage.getStyle().withClickEvent((ClickEvent)new ClickEvent.OpenUrl(jumpUri)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return fullMessage;
    }

    public void onMessageReceived(@NotNull MessageReceivedEvent event) {
        if (!ENABLED || event.getMember() == null || event.getAuthor().isBot() || !((List)DissonanceConfig.INPUT_CHANNELS.get()).contains(event.getChannel().getIdLong())) {
            return;
        }
        Component formatted = DiscordToMinecraftBridge.formatDiscordMessage(event.getMember(), (Channel)event.getChannel(), event.getMessage());
        this.minecraft.execute(() -> this.minecraft.getPlayerList().broadcastSystemMessage(formatted, false));
    }
}

