/*
 * Decompiled with CFR 0.152.
 */
package lol.sylvie.dissonance.discord.linking;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lol.sylvie.dissonance.Constants;
import lol.sylvie.dissonance.config.DissonanceConfig;
import lol.sylvie.dissonance.discord.DiscordClient;
import lol.sylvie.dissonance.discord.command.DiscordCommands;
import lol.sylvie.dissonance.discord.proximity.DiscordProximity;
import lol.sylvie.dissonance.minecraft.MinecraftToDiscordBridge;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.ISnowflake;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.events.guild.member.GuildMemberRemoveEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.NameAndId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiscordLinking
extends ListenerAdapter {
    public static Connection CONNECTION;
    public static final HashMap<String, Pair<Long, NameAndId>> LINK_CODES;
    public static final int LINK_CODE_LIFESPAN = 300000;
    public static final HashMap<UUID, String> MC_TO_DISCORD_CACHE;
    private static final Component SKILL_ISSUE;

    public static boolean init(MinecraftServer server) throws SQLException {
        Guild guild;
        TextChannel channel;
        if ((Long)DissonanceConfig.GUILD_ID.get() == 0L && MinecraftToDiscordBridge.ENABLED && (channel = MinecraftToDiscordBridge.getOutputChannel()) != null) {
            DissonanceConfig.GUILD_ID.set((Object)channel.getGuild().getIdLong());
        }
        if ((guild = DiscordLinking.getGuild()) == null) {
            return false;
        }
        Path path = server.getServerDirectory().resolve("config");
        CONNECTION = DriverManager.getConnection("jdbc:sqlite:" + String.valueOf(path.resolve("dissonance.db").toAbsolutePath()));
        try (Statement statement = CONNECTION.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS LINKS(discord_id TEXT UNIQUE, minecraft_id TEXT UNIQUE)");
        }
        DiscordCommands.register(guild);
        DiscordProximity.init();
        return true;
    }

    public static void close() {
        try {
            if (DiscordLinking.isConnected()) {
                CONNECTION.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        CONNECTION = null;
    }

    public static boolean isConnected() {
        return CONNECTION != null;
    }

    @Nullable
    public static Guild getGuild() {
        if (DiscordClient.CLIENT == null) {
            return null;
        }
        try {
            return DiscordClient.CLIENT.getGuildById(((Long)DissonanceConfig.GUILD_ID.get()).longValue());
        }
        catch (NumberFormatException exception) {
            Constants.LOG.error("Linking guild ID is invalid!");
            return null;
        }
    }

    public static boolean hasCodeExpired(Pair<Long, NameAndId> code) {
        return System.currentTimeMillis() - (Long)code.getFirst() > 300000L;
    }

    public static boolean isWhitelistEnabled() {
        return (Boolean)DissonanceConfig.LINKING_ENABLED.get() != false && (Boolean)DissonanceConfig.WHITELIST_ENABLED.get() != false;
    }

    public static String generateCode(GameProfile profile) {
        int linkCode;
        String codeAsString;
        for (Map.Entry<String, Pair<Long, NameAndId>> code : new HashSet<Map.Entry<String, Pair<Long, NameAndId>>>(LINK_CODES.entrySet())) {
            if (!((NameAndId)code.getValue().getSecond()).id().equals(profile.id())) continue;
            LINK_CODES.remove(code.getKey());
            break;
        }
        do {
            try {
                linkCode = SecureRandom.getInstanceStrong().nextInt(0, 1000000);
            }
            catch (NoSuchAlgorithmException exception) {
                linkCode = new Random().nextInt(0, 100000000);
            }
        } while (LINK_CODES.containsKey(codeAsString = String.format("%06d", linkCode)));
        LINK_CODES.put(codeAsString, (Pair<Long, NameAndId>)Pair.of((Object)System.currentTimeMillis(), (Object)new NameAndId(profile)));
        return codeAsString;
    }

    @Nullable
    public static Component canPlayerJoin(MinecraftServer server, GameProfile profile) {
        if (!DiscordLinking.isWhitelistEnabled()) {
            return null;
        }
        NameAndId nameAndId = new NameAndId(profile);
        if (server.getPlayerList().isWhiteListed(nameAndId)) {
            return null;
        }
        if (DiscordClient.CLIENT == null || !DiscordLinking.isConnected()) {
            return Component.literal((String)"The server is still starting, please wait a moment and try again.").withStyle(ChatFormatting.RED);
        }
        for (Map.Entry codes : LINK_CODES.entrySet().stream().toList()) {
            if (!DiscordLinking.hasCodeExpired((Pair<Long, NameAndId>)((Pair)codes.getValue()))) continue;
            LINK_CODES.remove(codes.getKey());
        }
        String discordId = DiscordLinking.getDiscordFromMinecraft(profile.id());
        if (discordId == null) {
            return Component.literal((String)((String)DissonanceConfig.LINK_MESSAGE_TEMPLATE.get()).replace("%code%", DiscordLinking.generateCode(profile)));
        }
        Guild guild = DiscordLinking.getGuild();
        if (guild == null) {
            Constants.LOG.error("The bot cannot find the linking guild, so players cannot join!");
            return SKILL_ISSUE;
        }
        Member member = (Member)guild.retrieveMemberById(discordId).complete();
        MutableComponent notAllowed = Component.literal((String)((String)DissonanceConfig.WHITELIST_MESSAGE.get()));
        if (member == null) {
            return notAllowed;
        }
        Set roleIds = member.getUnsortedRoles().stream().map(ISnowflake::getIdLong).collect(Collectors.toSet());
        for (Long id : (List)DissonanceConfig.BLACKLISTED_ROLES.get()) {
            if (!roleIds.contains(id)) continue;
            return notAllowed;
        }
        List whitelistedRoles = (List)DissonanceConfig.WHITELISTED_ROLES.get();
        if (whitelistedRoles.isEmpty()) {
            return null;
        }
        for (Long id : whitelistedRoles) {
            if (!roleIds.contains(id)) continue;
            return null;
        }
        return notAllowed;
    }

    public static void addLink(User user, UUID id) throws SQLException {
        try (PreparedStatement statement = CONNECTION.prepareStatement("INSERT INTO LINKS (discord_id, minecraft_id) VALUES (?, ?)");){
            statement.setString(1, user.getId());
            statement.setString(2, id.toString());
            statement.execute();
        }
    }

    private static void removeEntry(String sql, String condition) throws SQLException {
        try (PreparedStatement statement = CONNECTION.prepareStatement(sql);){
            statement.setString(1, condition);
            statement.execute();
        }
    }

    public static void removeLinkFromDiscord(String id) throws SQLException {
        DiscordLinking.removeEntry("DELETE FROM LINKS WHERE discord_id = ?", id);
    }

    public static void removeLinkFromMinecraft(UUID uuid) throws SQLException {
        DiscordLinking.removeEntry("DELETE FROM LINKS WHERE minecraft_id = ?", uuid.toString());
    }

    private static String getString(String sql, String key, String value) {
        String string;
        block8: {
            PreparedStatement statement = CONNECTION.prepareStatement(sql);
            try {
                statement.setString(1, key);
                ResultSet results = statement.executeQuery();
                string = results.getString(value);
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException exception) {
                    return null;
                }
            }
            statement.close();
        }
        return string;
    }

    @Nullable
    public static UUID getMinecraftFromDiscord(String id) {
        String minecraftId = DiscordLinking.getString("SELECT minecraft_id FROM LINKS WHERE discord_id = ?", id, "minecraft_id");
        if (minecraftId == null) {
            return null;
        }
        return UUID.fromString(minecraftId);
    }

    @Nullable
    public static String getDiscordFromMinecraft(UUID id) {
        return MC_TO_DISCORD_CACHE.computeIfAbsent(id, uuid -> DiscordLinking.getString("SELECT discord_id FROM LINKS WHERE minecraft_id = ?", uuid.toString(), "discord_id"));
    }

    public static Member getMemberFromMinecraft(UUID uuid) {
        Guild guild = DiscordLinking.getGuild();
        String discordId = DiscordLinking.getDiscordFromMinecraft(uuid);
        if (discordId == null || guild == null) {
            return null;
        }
        return (Member)guild.retrieveMemberById(discordId).complete();
    }

    public void onGuildMemberRemove(@NotNull GuildMemberRemoveEvent event) {
        try {
            DiscordLinking.removeLinkFromDiscord(event.getUser().getId());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    static {
        LINK_CODES = new HashMap();
        MC_TO_DISCORD_CACHE = new HashMap();
        SKILL_ISSUE = Component.literal((String)"There is a configuration error with Discord linking, please contact the server owner.").withStyle(ChatFormatting.RED);
    }
}

