/*
 * Decompiled with CFR 0.152.
 */
package lol.sylvie.dissonance.discord.proximity;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import lol.sylvie.dissonance.discord.linking.DiscordLinking;
import lol.sylvie.dissonance.discord.proximity.DiscordProximity;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.IPermissionHolder;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.UserSnowflake;
import net.dv8tion.jda.api.entities.channel.concrete.Category;
import net.dv8tion.jda.api.entities.channel.concrete.VoiceChannel;
import net.dv8tion.jda.api.entities.channel.middleman.AudioChannel;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class ProximityGroup {
    private final UUID groupId = UUID.randomUUID();
    public final HashSet<UUID> players = new HashSet();
    private final Guild guild = DiscordLinking.getGuild();
    private VoiceChannel channel;
    private boolean markedForRemoval = false;

    public ProximityGroup() {
    }

    public ProximityGroup(List<UUID> players) {
        this();
        players.forEach(p -> this.add((UUID)p, false));
        this.createVoiceChannel();
    }

    public void createVoiceChannel() {
        Category category = DiscordProximity.getCategory();
        if (category == null) {
            return;
        }
        category.createVoiceChannel(this.groupId.toString()).addPermissionOverride((IPermissionHolder)this.guild.getPublicRole(), List.of(Permission.VOICE_SPEAK), List.of(Permission.VIEW_CHANNEL)).addPermissionOverride((IPermissionHolder)this.guild.getSelfMember(), List.of(Permission.VIEW_CHANNEL, Permission.VOICE_MOVE_OTHERS), List.of()).queue(this::onChannelCreate);
    }

    private void movePlayer(UUID player, AudioChannel channel, Runnable onMove) {
        Member member = DiscordLinking.getMemberFromMinecraft(player);
        if (member == null || !DiscordProximity.isInProximityCategory(member)) {
            return;
        }
        this.guild.moveVoiceMember((UserSnowflake)member, channel).queue(unused -> onMove.run());
    }

    private void movePlayer(UUID player, AudioChannel channel) {
        this.movePlayer(player, channel, () -> {
            if (this.channel != null && this.channel.getMembers().isEmpty()) {
                this.channel.delete().queue();
                this.channel = null;
            }
        });
    }

    private void movePlayerHere(UUID player) {
        this.movePlayer(player, (AudioChannel)this.channel, () -> {});
    }

    public void onChannelCreate(VoiceChannel channel) {
        this.channel = channel;
        for (UUID uuid : this.players) {
            this.movePlayerHere(uuid);
        }
    }

    public void implode(@Nullable VoiceChannel destination) {
        for (UUID stillHere : new HashSet<UUID>(this.players)) {
            this.remove(stillHere, destination == null, false);
            if (destination == null) continue;
            this.movePlayer(stillHere, (AudioChannel)destination);
        }
    }

    public HashSet<UUID> recursiveNetworkSplit(MinecraftServer server, ServerPlayer current, HashSet<UUID> found, int distanceSquared) {
        for (UUID uuid : this.players) {
            ServerPlayer player;
            if (found.contains(uuid) || uuid.equals(current.getUUID()) || (player = server.getPlayerList().getPlayer(uuid)) == null || !player.isAlive() || !(player.distanceToSqr((Entity)current) < (double)distanceSquared)) continue;
            found.add(uuid);
            found.addAll(this.recursiveNetworkSplit(server, current, found, distanceSquared));
        }
        return found;
    }

    public void implodeIfNeeded() {
        if (!this.markedForRemoval) {
            return;
        }
        this.implode(null);
    }

    public List<UUID> collectDisconnectedMembers() {
        ArrayList<UUID> removed = new ArrayList<UUID>();
        for (UUID uuid : this.players) {
            Member member = DiscordLinking.getMemberFromMinecraft(uuid);
            if (member != null && DiscordProximity.isInProximityCategory(member)) continue;
            removed.add(uuid);
        }
        return removed;
    }

    public void add(UUID player, boolean move) {
        this.players.add(player);
        if (move) {
            this.movePlayerHere(player);
        }
    }

    public void remove(UUID player, boolean moveToLobby, boolean shouldKick) {
        Member member;
        this.players.remove(player);
        if (moveToLobby) {
            VoiceChannel lobby = DiscordProximity.getLobbyChannel(this.guild);
            if (lobby != null) {
                this.movePlayer(player, (AudioChannel)lobby);
            }
        } else if (shouldKick && (member = DiscordLinking.getMemberFromMinecraft(player)) != null && DiscordProximity.isInProximityCategory(member)) {
            this.guild.kickVoiceMember((UserSnowflake)member).queue();
        }
        if (this.players.size() < 2) {
            this.markedForRemoval = true;
        }
    }

    public boolean isInRadius(MinecraftServer server, ServerPlayer player, int distanceSquared) {
        for (UUID uuid : this.players) {
            ServerPlayer participant;
            if (uuid.equals(player.getUUID()) || (participant = server.getPlayerList().getPlayer(uuid)) == null || !participant.isAlive() || !(participant.distanceToSqr((Entity)player) < (double)distanceSquared)) continue;
            return true;
        }
        return false;
    }

    public void merge(ProximityGroup group) {
        group.implode(this.channel);
    }

    public Set<Set<UUID>> split(MinecraftServer server, int distanceSquared) {
        HashSet<Set<UUID>> groups = new HashSet<Set<UUID>>();
        HashSet<UUID> accountedFor = new HashSet<UUID>();
        for (UUID uuid : this.players) {
            ServerPlayer player = server.getPlayerList().getPlayer(uuid);
            if (accountedFor.contains(uuid)) continue;
            HashSet<UUID> uuids = this.recursiveNetworkSplit(server, player, new HashSet<UUID>(Set.of(uuid)), distanceSquared);
            accountedFor.addAll(uuids);
            groups.add(uuids);
        }
        return groups;
    }

    public boolean isMarkedForRemoval() {
        return this.markedForRemoval;
    }
}

