/*
 * Decompiled with CFR 0.152.
 */
package lol.sylvie.dissonance.minecraft;

import lol.sylvie.dissonance.Constants;
import lol.sylvie.dissonance.config.DissonanceConfig;
import lol.sylvie.dissonance.discord.linking.DiscordLinking;
import lol.sylvie.dissonance.discord.proximity.DiscordProximity;
import lol.sylvie.dissonance.minecraft.MinecraftToDiscordBridge;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class MinecraftEvents {
    private static int tickAttemptsProximity = 0;

    public static void onPlayerJoin(Player player) {
        MinecraftToDiscordBridge.onPlayerJoin(player);
    }

    public static void onPlayerLeave(Player player) {
        MinecraftToDiscordBridge.onPlayerLeave(player);
        DiscordLinking.MC_TO_DISCORD_CACHE.remove(player.getUUID());
        DiscordProximity.onDisconnect(player);
    }

    public static void onAdvancementAwarded(ServerPlayer player, AdvancementHolder advancement, DisplayInfo displayInfo) {
        MinecraftToDiscordBridge.onAdvancementAwarded(player, advancement, displayInfo);
    }

    public static void onPlayerDeath(Player player, Component message) {
        MinecraftToDiscordBridge.onPlayerDeath(player, message);
    }

    public static void onMiscMessage(Component message) {
        MinecraftToDiscordBridge.onMiscMessage(message);
    }

    public static void tick(MinecraftServer server) {
        block3: {
            try {
                if (server.getTickCount() % (Integer)DissonanceConfig.PROXIMITY_UPDATE_FREQUENCY.get() == 0) {
                    DiscordProximity.update(server);
                    tickAttemptsProximity = 0;
                }
            }
            catch (RuntimeException e) {
                Constants.LOG.error("Couldn't update Discord proximity!", (Throwable)e);
                if (++tickAttemptsProximity <= 10) break block3;
                Constants.LOG.error("Discord proximity has been disabled as there were 10 failed ticks in a row.");
                DiscordProximity.ENABLED = false;
            }
        }
    }
}

