/*
 * Decompiled with CFR 0.152.
 */
package lol.sylvie.dissonance.minecraft;

import com.mojang.authlib.GameProfile;
import java.awt.Color;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lol.sylvie.dissonance.Constants;
import lol.sylvie.dissonance.Dissonance;
import lol.sylvie.dissonance.config.DissonanceConfig;
import lol.sylvie.dissonance.discord.DiscordClient;
import lol.sylvie.dissonance.discord.linking.DiscordLinking;
import lol.sylvie.dissonance.util.TemplateUtil;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.IncomingWebhookClient;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.requests.restaction.WebhookMessageCreateAction;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class MinecraftToDiscordBridge {
    public static boolean ENABLED = true;
    public static IncomingWebhookClient WEBHOOK = null;
    public static final Pattern MENTION_PATTERN = Pattern.compile("@(?=.{2,32}$)(?!(?:everyone|here)$)\\.?[a-z0-9_]+(?:\\.[a-z0-9_]+)*\\.?");
    private static final Map<String, String> EMPTY = Map.of();

    public static TextChannel getOutputChannel() {
        if (DiscordClient.CLIENT == null) {
            throw new IllegalStateException("Nothing Discord related should be called while JDA is uninitialized!");
        }
        try {
            return DiscordClient.CLIENT.getTextChannelById(((Long)DissonanceConfig.OUTPUT_CHANNEL.get()).longValue());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static boolean shouldUseWebhook() {
        return (Boolean)DissonanceConfig.USE_WEBHOOK_MESSAGES.get() != false && WEBHOOK != null;
    }

    private static void logQueue(RestAction<?> action, Runnable afterwards) {
        if (Dissonance.SHUTTING_DOWN) {
            return;
        }
        action.queue(success -> afterwards.run(), failure -> {
            Constants.LOG.error("Couldn't send message!", failure);
            afterwards.run();
        });
    }

    private static void logQueue(RestAction<?> action) {
        MinecraftToDiscordBridge.logQueue(action, () -> {});
    }

    public static String getAvatarUrl(GameProfile profile) {
        return TemplateUtil.replace((String)DissonanceConfig.AVATAR_API.get(), Map.of("%username%", profile.name(), "%uuid%", profile.id().toString(), "%random%", UUID.randomUUID().toString()));
    }

    @Nullable
    public static Member getOrFetchMember(Guild guild, String name) {
        Member member = guild.getMemberByTag(name, "0000");
        if (member != null) {
            return member;
        }
        List members = (List)guild.findMembers(m -> m.getUser().getName().equalsIgnoreCase(name)).get();
        if (!members.isEmpty()) {
            return (Member)members.getFirst();
        }
        return null;
    }

    public static String parsePlayerMessage(@Nullable TextChannel channel, String rawText) {
        if (channel != null && ((Boolean)DissonanceConfig.ALLOW_MENTIONS.get()).booleanValue() && ((Boolean)DissonanceConfig.RESOLVE_USERNAME_MENTIONS.get()).booleanValue()) {
            Matcher matcher = MENTION_PATTERN.matcher(rawText);
            StringBuilder result = new StringBuilder();
            while (matcher.find()) {
                String username = matcher.group(0).replaceFirst("@", "");
                Member member = MinecraftToDiscordBridge.getOrFetchMember(MinecraftToDiscordBridge.getOutputChannel().getGuild(), username);
                if (member != null) {
                    matcher.appendReplacement(result, member.getAsMention());
                    continue;
                }
                matcher.appendReplacement(result, "@" + username);
            }
            matcher.appendTail(result);
            rawText = result.toString();
        }
        return rawText;
    }

    public static String formatPlayerMessage(Player player, String message, boolean webhook) {
        return !webhook || (Boolean)DissonanceConfig.USE_TEMPLATE_FOR_WEBHOOKS.get() != false ? TemplateUtil.replaceWithPlayer((String)DissonanceConfig.DISCORD_MESSAGE_TEMPLATE.get(), player, Map.of("%content%", message)) : message;
    }

    public static void onPlayerChatMessage(Player player, String rawText) {
        if (!ENABLED) {
            return;
        }
        GameProfile profile = player.getGameProfile();
        TextChannel channel = MinecraftToDiscordBridge.getOutputChannel();
        String parsedMessage = MinecraftToDiscordBridge.parsePlayerMessage(channel, rawText);
        HashSet<Message.MentionType> allowedMentions = new HashSet<Message.MentionType>();
        allowedMentions.add(Message.MentionType.EMOJI);
        if (((Boolean)DissonanceConfig.ALLOW_MENTIONS.get()).booleanValue()) {
            allowedMentions.add(Message.MentionType.USER);
            if (((Boolean)DissonanceConfig.ALLOW_MASS_PINGS.get()).booleanValue()) {
                allowedMentions.add(Message.MentionType.EVERYONE);
                allowedMentions.add(Message.MentionType.HERE);
                allowedMentions.add(Message.MentionType.ROLE);
            }
        }
        boolean webhook = MinecraftToDiscordBridge.shouldUseWebhook();
        String formatted = MinecraftToDiscordBridge.formatPlayerMessage(player, parsedMessage, webhook);
        if (webhook) {
            MinecraftToDiscordBridge.logQueue((RestAction)WEBHOOK.sendMessage(formatted).setAvatarUrl(MinecraftToDiscordBridge.getAvatarUrl(profile)).setUsername(profile.name()).setAllowedMentions(allowedMentions));
        } else {
            MinecraftToDiscordBridge.logQueue((RestAction)channel.sendMessage((CharSequence)formatted).setAllowedMentions(allowedMentions));
        }
    }

    private static String replaceIfPlayer(@Nullable Player player, String template, Map<String, String> placeholders) {
        return player != null ? TemplateUtil.replaceWithPlayer(template, player, placeholders) : TemplateUtil.replace(template, placeholders);
    }

    public static void handleEvent(@Nullable Player player, DissonanceConfig.EventConfigValue eventValue, Map<String, String> placeholders, @Nullable Color colorOverride, Runnable afterwards) {
        WebhookMessageCreateAction action;
        boolean usingDescription;
        if (!ENABLED || !((Boolean)eventValue.enabled.get()).booleanValue()) {
            return;
        }
        boolean usingEmbed = (Boolean)eventValue.useEmbed.get();
        String title = MinecraftToDiscordBridge.replaceIfPlayer(player, (String)eventValue.titleTemplate.get(), placeholders);
        boolean usingTitle = !title.isEmpty();
        String description = usingEmbed ? MinecraftToDiscordBridge.replaceIfPlayer(player, (String)eventValue.descriptionTemplate.get(), placeholders) : "";
        boolean bl = usingDescription = !description.isEmpty();
        if (!usingTitle && !usingDescription) {
            return;
        }
        String content = title;
        MessageEmbed embed = null;
        if (usingEmbed) {
            EmbedBuilder builder = new EmbedBuilder();
            if (usingTitle) {
                builder.setTitle(title);
            }
            if (usingDescription) {
                builder.setDescription((CharSequence)description);
            }
            builder.setColor(colorOverride == null ? Color.decode((String)eventValue.color.get()) : colorOverride);
            if (((Boolean)eventValue.usePlayerAuthor.get()).booleanValue() && player != null) {
                GameProfile profile = player.getGameProfile();
                builder.setAuthor((Boolean)DissonanceConfig.NICKNAME_AUTHORS.get() != false ? player.getDisplayName().getString() : player.getGameProfile().name(), null, MinecraftToDiscordBridge.getAvatarUrl(profile));
            }
            content = null;
            embed = builder.build();
        }
        if (((Boolean)DissonanceConfig.USE_WEBHOOK_FOR_EVENTS.get()).booleanValue() && MinecraftToDiscordBridge.shouldUseWebhook()) {
            action = usingEmbed ? WEBHOOK.sendMessageEmbeds(embed, new MessageEmbed[0]) : WEBHOOK.sendMessage(content);
        } else {
            TextChannel output = MinecraftToDiscordBridge.getOutputChannel();
            assert (output != null);
            action = usingEmbed ? output.sendMessageEmbeds(embed, new MessageEmbed[0]) : output.sendMessage((CharSequence)content);
        }
        MinecraftToDiscordBridge.logQueue(action, afterwards);
    }

    public static void handleEvent(@Nullable Player player, DissonanceConfig.EventConfigValue eventValue, Map<String, String> placeholders, @Nullable Color colorOverride) {
        MinecraftToDiscordBridge.handleEvent(player, eventValue, placeholders, colorOverride, () -> {});
    }

    public static void onPlayerJoin(Player player) {
        MinecraftToDiscordBridge.handleEvent(player, DissonanceConfig.EVENT_GAME_JOIN, EMPTY, null);
    }

    public static void onPlayerLeave(Player player) {
        MinecraftToDiscordBridge.handleEvent(player, DissonanceConfig.EVENT_GAME_LEAVE, EMPTY, null);
        DiscordLinking.MC_TO_DISCORD_CACHE.remove(player.getUUID());
    }

    public static void onAdvancementAwarded(ServerPlayer player, AdvancementHolder advancement, DisplayInfo displayInfo) {
        AdvancementType type = displayInfo.getType();
        Map<String, String> placeholders = Map.of("%default_announcement%", type.createAnnouncement(advancement, player).getString(), "%default_title%", type.getDisplayName().getString(), "%advancement_name%", Advancement.name((AdvancementHolder)advancement).getString(), "%advancement_description%", displayInfo.getDescription().getString(), "%advancement_type%", type.getSerializedName());
        DissonanceConfig.EventConfigValue configValue = DissonanceConfig.EVENT_GAME_ADVANCEMENT;
        MinecraftToDiscordBridge.handleEvent((Player)player, configValue, placeholders, ((String)configValue.color.get()).equalsIgnoreCase("#FFFFFF") ? new Color(type.getChatColor().getColor()) : null);
    }

    public static void onPlayerDeath(Player player, Component message) {
        Map<String, String> placeholders = Map.of("%default_announcement%", message.getString());
        MinecraftToDiscordBridge.handleEvent(player, DissonanceConfig.EVENT_GAME_DEATH, placeholders, null);
    }

    public static void onServerStarted() {
        MinecraftToDiscordBridge.handleEvent(null, DissonanceConfig.EVENT_SERVER_START, EMPTY, null);
    }

    public static void onServerStopped(Runnable onShutDown) {
        MinecraftToDiscordBridge.handleEvent(null, DissonanceConfig.EVENT_SERVER_STOP, EMPTY, null, onShutDown);
    }

    public static void onMiscMessage(Component message) {
        Map<String, String> placeholders = Map.of("%message%", message.getString());
        MinecraftToDiscordBridge.handleEvent(null, DissonanceConfig.EVENT_GAME_MISC_MESSAGE, placeholders, null);
    }
}

