/*
 * Decompiled with CFR 0.152.
 */
package lol.sylvie.dissonance.minecraft.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.sql.SQLException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import lol.sylvie.dissonance.Constants;
import lol.sylvie.dissonance.discord.linking.DiscordLinking;
import lol.sylvie.dissonance.minecraft.MinecraftToDiscordBridge;
import lol.sylvie.dissonance.platform.Services;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;

public class MinecraftCommands {
    private static final SimpleCommandExceptionType NO_CHANNEL = new SimpleCommandExceptionType((Message)Component.literal((String)"The output channel cannot be accessed or the bot is missing required permissions."));
    private static final SimpleCommandExceptionType ALREADY_LINKED = new SimpleCommandExceptionType((Message)Component.literal((String)"You already have a Discord account linked."));
    private static final SimpleCommandExceptionType NOT_LINKED = new SimpleCommandExceptionType((Message)Component.literal((String)"You do not have a Discord account linked."));
    private static final SimpleCommandExceptionType DATABASE_ERROR = new SimpleCommandExceptionType((Message)Component.literal((String)"There was an error accessing the link database! Contact the server owner."));
    private static final SimpleCommandExceptionType LINKING_OFF = new SimpleCommandExceptionType((Message)Component.literal((String)"Account linking is unavailable."));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder builder = Commands.literal((String)"dissonance");
        MinecraftCommands.registerPurgeCommand((LiteralArgumentBuilder<CommandSourceStack>)builder);
        MinecraftCommands.registerLinkCommand((LiteralArgumentBuilder<CommandSourceStack>)builder);
        MinecraftCommands.registerUnlinkCommand((LiteralArgumentBuilder<CommandSourceStack>)builder);
        dispatcher.register(builder);
    }

    public static Predicate<CommandSourceStack> getPermissionPredicate(String permission, int value) {
        return s -> s.isPlayer() ? Services.PLATFORM.hasPermission(s.getPlayer(), permission, value) : s.hasPermission(value);
    }

    private static void registerPurgeCommand(LiteralArgumentBuilder<CommandSourceStack> root) {
        root.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"purge").requires(CommandSourceStack::isPlayer)).requires(MinecraftCommands.getPermissionPredicate("dissonance.purge", 4))).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            TextChannel channel = MinecraftToDiscordBridge.getOutputChannel();
            if (channel == null || !channel.getGuild().getSelfMember().hasPermission((GuildChannel)channel, new Permission[]{Permission.MESSAGE_MANAGE})) {
                throw NO_CHANNEL.create();
            }
            ((CompletableFuture)((CompletableFuture)channel.getIterableHistory().takeAsync(IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")).thenAccept(arg_0 -> ((TextChannel)channel).purgeMessages(arg_0))).thenAccept(f -> ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Successfully purged messages!"), false))).exceptionally(error -> {
                Constants.LOG.error("Couldn't purge messages.", error);
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"There was an error while trying to purge messages."));
                return null;
            });
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"Attempting to purge messages..."));
            return 0;
        })));
    }

    private static void registerUnlinkCommand(LiteralArgumentBuilder<CommandSourceStack> root) {
        root.then(((LiteralArgumentBuilder)Commands.literal((String)"unlink").requires(MinecraftCommands.getPermissionPredicate("dissonance.unlink", 0))).executes(context -> {
            if (!DiscordLinking.isConnected()) {
                throw LINKING_OFF.create();
            }
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            UUID uuid = player.getUUID();
            if (DiscordLinking.getDiscordFromMinecraft(uuid) == null) {
                throw NOT_LINKED.create();
            }
            try {
                DiscordLinking.removeLinkFromMinecraft(uuid);
                MutableComponent message = Component.literal((String)"Successfully unlinked account!");
                if (DiscordLinking.isWhitelistEnabled()) {
                    player.connection.disconnect((Component)message.withStyle(ChatFormatting.GREEN));
                } else {
                    ((CommandSourceStack)context.getSource()).sendSuccess(() -> message, false);
                }
            }
            catch (SQLException exception) {
                throw DATABASE_ERROR.create();
            }
            return 0;
        }));
    }

    private static void registerLinkCommand(LiteralArgumentBuilder<CommandSourceStack> root) {
        root.then(((LiteralArgumentBuilder)Commands.literal((String)"link").requires(MinecraftCommands.getPermissionPredicate("dissonance.link", 0))).executes(context -> {
            if (!DiscordLinking.isConnected()) {
                throw LINKING_OFF.create();
            }
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            UUID uuid = player.getUUID();
            if (DiscordLinking.getDiscordFromMinecraft(uuid) != null) {
                throw ALREADY_LINKED.create();
            }
            String linkCode = DiscordLinking.generateCode(player.getGameProfile());
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Your link code is ").append((Component)Component.literal((String)linkCode).withStyle(ChatFormatting.BOLD)), false);
            return 0;
        }));
    }
}

