/*
 * Decompiled with CFR 0.152.
 */
package lol.sylvie.dissonance.discord;

import java.net.URI;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lol.sylvie.dissonance.config.DissonanceConfig;
import lol.sylvie.dissonance.discord.MinecraftOwnedListener;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.channel.Channel;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class DiscordToMinecraftBridge
extends MinecraftOwnedListener {
    public static boolean ENABLED = true;
    public static final Pattern URL_PATTERN = Pattern.compile("https?://(?:www\\.)?[-a-zA-Z0-9@:%._+~#=]{1,256}\\.[a-zA-Z0-9()]{1,6}\\b[-a-zA-Z0-9()@:%_+.~#?&/=]*");

    public DiscordToMinecraftBridge(MinecraftServer server) {
        super(server);
    }

    public static class_5250 optionallyColorMember(int color, class_5250 component) {
        return (Boolean)DissonanceConfig.USE_ROLE_COLORS.get() != false ? component.method_54663(color) : component;
    }

    @NotNull
    private static class_5250 getAttachmentHover(Message.Attachment attachment) {
        boolean isImage;
        class_5250 hoverComponent = class_2561.method_43473();
        if (attachment.getDescription() != null) {
            hoverComponent.method_27693(attachment.getDescription() + "\n");
        }
        if ((isImage = attachment.isImage()) || attachment.isVideo()) {
            hoverComponent.method_27693(String.format("%s dimensions: %sx%s", isImage ? "Image" : "Video", attachment.getWidth(), attachment.getHeight()));
        } else {
            hoverComponent.method_27693("Content-Type: " + attachment.getContentType());
        }
        return hoverComponent;
    }

    public static class_5250 formatDiscordContent(int roleColor, Message message) {
        String content = message.getContentDisplay();
        class_5250 baseComponent = class_2561.method_43473();
        String colorSetting = (String)DissonanceConfig.LINK_COLOR.get();
        int color = 0xFFFFFF;
        if (colorSetting.equalsIgnoreCase("role")) {
            color = roleColor;
        } else {
            try {
                color = Integer.decode(colorSetting);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (((Boolean)DissonanceConfig.LINK_PARSING.get()).booleanValue()) {
            Matcher matcher = URL_PATTERN.matcher(content);
            int lastEnd = 0;
            while (matcher.find()) {
                baseComponent.method_27693(content.substring(lastEnd, matcher.start()));
                String url = matcher.group(0);
                baseComponent.method_10852((class_2561)class_2561.method_43470((String)url).method_27696(class_2583.field_24360.method_30938(Boolean.valueOf(true)).method_36139(color).method_10958((class_2558)new class_2558.class_10608(URI.create(url)))));
                lastEnd = matcher.end();
            }
            baseComponent.method_10852((class_2561)class_2561.method_43470((String)content.substring(lastEnd)));
        } else {
            baseComponent.method_27693(content);
        }
        if (((Boolean)DissonanceConfig.SHOW_ATTACHMENTS.get()).booleanValue()) {
            for (Message.Attachment attachment : message.getAttachments()) {
                class_5250 hoverComponent = DiscordToMinecraftBridge.getAttachmentHover(attachment);
                String name = attachment.isSpoiler() ? "SPOILER" : attachment.getFileName();
                class_5250 attachmentComponent = class_2561.method_43470((String)(" [" + name + "]")).method_27696(class_2583.field_24360.method_36139(color).method_10958((class_2558)new class_2558.class_10608(URI.create(attachment.getUrl()))).method_10949((class_2568)new class_2568.class_10613((class_2561)hoverComponent)));
                baseComponent.method_10852((class_2561)attachmentComponent);
            }
        }
        return baseComponent;
    }

    public static class_2561 formatDiscordMessage(Member member, Channel channel, Message message) {
        String template = (String)DissonanceConfig.MINECRAFT_MESSAGE_TEMPLATE.get();
        int color = member.getColorRaw();
        String usernameString = member.getUser().getName();
        class_5250 username = DiscordToMinecraftBridge.optionallyColorMember(color, class_2561.method_43470((String)usernameString));
        class_5250 nickname = DiscordToMinecraftBridge.optionallyColorMember(color, class_2561.method_43470((String)member.getEffectiveName()));
        if (((Boolean)DissonanceConfig.ADD_USERNAME_HOVER_TO_NICKNAME.get()).booleanValue()) {
            nickname = nickname.method_27696(nickname.method_10866().method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("@" + usernameString + " on Discord")))));
        }
        class_5250 content = DiscordToMinecraftBridge.formatDiscordContent(color, message);
        class_5250 channelName = class_2561.method_43470((String)channel.getName());
        class_5250 fullMessage = class_2561.method_43469((String)template, (Object[])new Object[]{username, nickname, content, channelName});
        if (((Boolean)DissonanceConfig.LINK_TO_MESSAGE.get()).booleanValue()) {
            try {
                URI jumpUri = URI.create(message.getJumpUrl());
                fullMessage = fullMessage.method_27696(fullMessage.method_10866().method_10958((class_2558)new class_2558.class_10608(jumpUri)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return fullMessage;
    }

    public void onMessageReceived(@NotNull MessageReceivedEvent event) {
        if (!ENABLED || event.getMember() == null || event.getAuthor().isBot() || !((List)DissonanceConfig.INPUT_CHANNELS.get()).contains(event.getChannel().getIdLong())) {
            return;
        }
        class_2561 formatted = DiscordToMinecraftBridge.formatDiscordMessage(event.getMember(), (Channel)event.getChannel(), event.getMessage());
        this.minecraft.execute(() -> this.minecraft.method_3760().method_43514(formatted, false));
    }
}

