/*
 * Decompiled with CFR 0.152.
 */
package lol.sylvie.dissonance.minecraft;

import lol.sylvie.dissonance.Constants;
import lol.sylvie.dissonance.config.DissonanceConfig;
import lol.sylvie.dissonance.discord.linking.DiscordLinking;
import lol.sylvie.dissonance.discord.proximity.DiscordProximity;
import lol.sylvie.dissonance.minecraft.MinecraftToDiscordBridge;
import net.minecraft.class_1657;
import net.minecraft.class_185;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_8779;
import net.minecraft.server.MinecraftServer;

public class MinecraftEvents {
    private static int tickAttemptsProximity = 0;

    public static void onPlayerJoin(class_1657 player) {
        MinecraftToDiscordBridge.onPlayerJoin(player);
    }

    public static void onPlayerLeave(class_1657 player) {
        MinecraftToDiscordBridge.onPlayerLeave(player);
        DiscordLinking.MC_TO_DISCORD_CACHE.remove(player.method_5667());
        DiscordProximity.onDisconnect(player);
    }

    public static void onAdvancementAwarded(class_3222 player, class_8779 advancement, class_185 displayInfo) {
        MinecraftToDiscordBridge.onAdvancementAwarded(player, advancement, displayInfo);
    }

    public static void onPlayerDeath(class_1657 player, class_2561 message) {
        MinecraftToDiscordBridge.onPlayerDeath(player, message);
    }

    public static void onMiscMessage(class_2561 message) {
        MinecraftToDiscordBridge.onMiscMessage(message);
    }

    public static void tick(MinecraftServer server) {
        block3: {
            try {
                if (server.method_3780() % (Integer)DissonanceConfig.PROXIMITY_UPDATE_FREQUENCY.get() == 0) {
                    DiscordProximity.update(server);
                    tickAttemptsProximity = 0;
                }
            }
            catch (RuntimeException e) {
                Constants.LOG.error("Couldn't update Discord proximity!", (Throwable)e);
                if (++tickAttemptsProximity <= 10) break block3;
                Constants.LOG.error("Discord proximity has been disabled as there were 10 failed ticks in a row.");
                DiscordProximity.ENABLED = false;
            }
        }
    }
}

