/*
 * Decompiled with CFR 0.152.
 */
package lol.sylvie.dissonance.minecraft;

import com.mojang.authlib.GameProfile;
import java.awt.Color;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lol.sylvie.dissonance.Constants;
import lol.sylvie.dissonance.Dissonance;
import lol.sylvie.dissonance.config.DissonanceConfig;
import lol.sylvie.dissonance.discord.DiscordClient;
import lol.sylvie.dissonance.discord.linking.DiscordLinking;
import lol.sylvie.dissonance.util.TemplateUtil;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.IncomingWebhookClient;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.requests.restaction.WebhookMessageCreateAction;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_185;
import net.minecraft.class_189;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_8779;
import org.jetbrains.annotations.Nullable;

public class MinecraftToDiscordBridge {
    public static boolean ENABLED = true;
    public static IncomingWebhookClient WEBHOOK = null;
    public static final Pattern MENTION_PATTERN = Pattern.compile("@(?=.{2,32}$)(?!(?:everyone|here)$)\\.?[a-z0-9_]+(?:\\.[a-z0-9_]+)*\\.?");
    private static final Map<String, String> EMPTY = Map.of();

    public static TextChannel getOutputChannel() {
        if (DiscordClient.CLIENT == null) {
            throw new IllegalStateException("Nothing Discord related should be called while JDA is uninitialized!");
        }
        try {
            return DiscordClient.CLIENT.getTextChannelById(((Long)DissonanceConfig.OUTPUT_CHANNEL.get()).longValue());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static boolean shouldUseWebhook() {
        return (Boolean)DissonanceConfig.USE_WEBHOOK_MESSAGES.get() != false && WEBHOOK != null;
    }

    private static void logQueue(RestAction<?> action, Runnable afterwards) {
        if (Dissonance.SHUTTING_DOWN) {
            return;
        }
        action.queue(success -> afterwards.run(), failure -> {
            Constants.LOG.error("Couldn't send message!", failure);
            afterwards.run();
        });
    }

    private static void logQueue(RestAction<?> action) {
        MinecraftToDiscordBridge.logQueue(action, () -> {});
    }

    public static String getAvatarUrl(GameProfile profile) {
        return TemplateUtil.replace((String)DissonanceConfig.AVATAR_API.get(), Map.of("%username%", profile.name(), "%uuid%", profile.id().toString(), "%random%", UUID.randomUUID().toString()));
    }

    @Nullable
    public static Member getOrFetchMember(Guild guild, String name) {
        Member member = guild.getMemberByTag(name, "0000");
        if (member != null) {
            return member;
        }
        List members = (List)guild.findMembers(m -> m.getUser().getName().equalsIgnoreCase(name)).get();
        if (!members.isEmpty()) {
            return (Member)members.getFirst();
        }
        return null;
    }

    public static String parsePlayerMessage(@Nullable TextChannel channel, String rawText) {
        if (channel != null && ((Boolean)DissonanceConfig.ALLOW_MENTIONS.get()).booleanValue() && ((Boolean)DissonanceConfig.RESOLVE_USERNAME_MENTIONS.get()).booleanValue()) {
            Matcher matcher = MENTION_PATTERN.matcher(rawText);
            StringBuilder result = new StringBuilder();
            while (matcher.find()) {
                String username = matcher.group(0).replaceFirst("@", "");
                Member member = MinecraftToDiscordBridge.getOrFetchMember(MinecraftToDiscordBridge.getOutputChannel().getGuild(), username);
                if (member != null) {
                    matcher.appendReplacement(result, member.getAsMention());
                    continue;
                }
                matcher.appendReplacement(result, "@" + username);
            }
            matcher.appendTail(result);
            rawText = result.toString();
        }
        return rawText;
    }

    public static String formatPlayerMessage(class_1657 player, String message, boolean webhook) {
        return !webhook || (Boolean)DissonanceConfig.USE_TEMPLATE_FOR_WEBHOOKS.get() != false ? TemplateUtil.replaceWithPlayer((String)DissonanceConfig.DISCORD_MESSAGE_TEMPLATE.get(), player, Map.of("%content%", message)) : message;
    }

    public static void onPlayerChatMessage(class_1657 player, String rawText) {
        if (!ENABLED) {
            return;
        }
        GameProfile profile = player.method_7334();
        TextChannel channel = MinecraftToDiscordBridge.getOutputChannel();
        String parsedMessage = MinecraftToDiscordBridge.parsePlayerMessage(channel, rawText);
        HashSet<Message.MentionType> allowedMentions = new HashSet<Message.MentionType>();
        allowedMentions.add(Message.MentionType.EMOJI);
        if (((Boolean)DissonanceConfig.ALLOW_MENTIONS.get()).booleanValue()) {
            allowedMentions.add(Message.MentionType.USER);
            if (((Boolean)DissonanceConfig.ALLOW_MASS_PINGS.get()).booleanValue()) {
                allowedMentions.add(Message.MentionType.EVERYONE);
                allowedMentions.add(Message.MentionType.HERE);
                allowedMentions.add(Message.MentionType.ROLE);
            }
        }
        boolean webhook = MinecraftToDiscordBridge.shouldUseWebhook();
        String formatted = MinecraftToDiscordBridge.formatPlayerMessage(player, parsedMessage, webhook);
        if (webhook) {
            MinecraftToDiscordBridge.logQueue((RestAction)WEBHOOK.sendMessage(formatted).setAvatarUrl(MinecraftToDiscordBridge.getAvatarUrl(profile)).setUsername(profile.name()).setAllowedMentions(allowedMentions));
        } else {
            MinecraftToDiscordBridge.logQueue((RestAction)channel.sendMessage((CharSequence)formatted).setAllowedMentions(allowedMentions));
        }
    }

    private static String replaceIfPlayer(@Nullable class_1657 player, String template, Map<String, String> placeholders) {
        return player != null ? TemplateUtil.replaceWithPlayer(template, player, placeholders) : TemplateUtil.replace(template, placeholders);
    }

    public static void handleEvent(@Nullable class_1657 player, DissonanceConfig.EventConfigValue eventValue, Map<String, String> placeholders, @Nullable Color colorOverride, Runnable afterwards) {
        WebhookMessageCreateAction action;
        boolean usingDescription;
        if (!ENABLED || !((Boolean)eventValue.enabled.get()).booleanValue()) {
            return;
        }
        boolean usingEmbed = (Boolean)eventValue.useEmbed.get();
        String title = MinecraftToDiscordBridge.replaceIfPlayer(player, (String)eventValue.titleTemplate.get(), placeholders);
        boolean usingTitle = !title.isEmpty();
        String description = usingEmbed ? MinecraftToDiscordBridge.replaceIfPlayer(player, (String)eventValue.descriptionTemplate.get(), placeholders) : "";
        boolean bl = usingDescription = !description.isEmpty();
        if (!usingTitle && !usingDescription) {
            return;
        }
        String content = title;
        MessageEmbed embed = null;
        if (usingEmbed) {
            EmbedBuilder builder = new EmbedBuilder();
            if (usingTitle) {
                builder.setTitle(title);
            }
            if (usingDescription) {
                builder.setDescription((CharSequence)description);
            }
            builder.setColor(colorOverride == null ? Color.decode((String)eventValue.color.get()) : colorOverride);
            if (((Boolean)eventValue.usePlayerAuthor.get()).booleanValue() && player != null) {
                GameProfile profile = player.method_7334();
                builder.setAuthor((Boolean)DissonanceConfig.NICKNAME_AUTHORS.get() != false ? player.method_5476().getString() : player.method_7334().name(), null, MinecraftToDiscordBridge.getAvatarUrl(profile));
            }
            content = null;
            embed = builder.build();
        }
        if (((Boolean)DissonanceConfig.USE_WEBHOOK_FOR_EVENTS.get()).booleanValue() && MinecraftToDiscordBridge.shouldUseWebhook()) {
            action = usingEmbed ? WEBHOOK.sendMessageEmbeds(embed, new MessageEmbed[0]) : WEBHOOK.sendMessage(content);
        } else {
            TextChannel output = MinecraftToDiscordBridge.getOutputChannel();
            assert (output != null);
            action = usingEmbed ? output.sendMessageEmbeds(embed, new MessageEmbed[0]) : output.sendMessage((CharSequence)content);
        }
        MinecraftToDiscordBridge.logQueue(action, afterwards);
    }

    public static void handleEvent(@Nullable class_1657 player, DissonanceConfig.EventConfigValue eventValue, Map<String, String> placeholders, @Nullable Color colorOverride) {
        MinecraftToDiscordBridge.handleEvent(player, eventValue, placeholders, colorOverride, () -> {});
    }

    public static void onPlayerJoin(class_1657 player) {
        MinecraftToDiscordBridge.handleEvent(player, DissonanceConfig.EVENT_GAME_JOIN, EMPTY, null);
    }

    public static void onPlayerLeave(class_1657 player) {
        MinecraftToDiscordBridge.handleEvent(player, DissonanceConfig.EVENT_GAME_LEAVE, EMPTY, null);
        DiscordLinking.MC_TO_DISCORD_CACHE.remove(player.method_5667());
    }

    public static void onAdvancementAwarded(class_3222 player, class_8779 advancement, class_185 displayInfo) {
        class_189 type = displayInfo.method_815();
        Map<String, String> placeholders = Map.of("%default_announcement%", type.method_54932(advancement, player).getString(), "%default_title%", type.method_30756().getString(), "%advancement_name%", class_161.method_53622((class_8779)advancement).getString(), "%advancement_description%", displayInfo.method_817().getString(), "%advancement_type%", type.method_15434());
        DissonanceConfig.EventConfigValue configValue = DissonanceConfig.EVENT_GAME_ADVANCEMENT;
        MinecraftToDiscordBridge.handleEvent((class_1657)player, configValue, placeholders, ((String)configValue.color.get()).equalsIgnoreCase("#FFFFFF") ? new Color(type.method_830().method_532()) : null);
    }

    public static void onPlayerDeath(class_1657 player, class_2561 message) {
        Map<String, String> placeholders = Map.of("%default_announcement%", message.getString());
        MinecraftToDiscordBridge.handleEvent(player, DissonanceConfig.EVENT_GAME_DEATH, placeholders, null);
    }

    public static void onServerStarted() {
        MinecraftToDiscordBridge.handleEvent(null, DissonanceConfig.EVENT_SERVER_START, EMPTY, null);
    }

    public static void onServerStopped(Runnable onShutDown) {
        MinecraftToDiscordBridge.handleEvent(null, DissonanceConfig.EVENT_SERVER_STOP, EMPTY, null, onShutDown);
    }

    public static void onMiscMessage(class_2561 message) {
        Map<String, String> placeholders = Map.of("%message%", message.getString());
        MinecraftToDiscordBridge.handleEvent(null, DissonanceConfig.EVENT_GAME_MISC_MESSAGE, placeholders, null);
    }
}

