/*
 * Decompiled with CFR 0.152.
 */
package lol.sylvie.dissonance.minecraft.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.sql.SQLException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import lol.sylvie.dissonance.Constants;
import lol.sylvie.dissonance.discord.linking.DiscordLinking;
import lol.sylvie.dissonance.minecraft.MinecraftToDiscordBridge;
import lol.sylvie.dissonance.platform.Services;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class MinecraftCommands {
    private static final SimpleCommandExceptionType NO_CHANNEL = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"The output channel cannot be accessed or the bot is missing required permissions."));
    private static final SimpleCommandExceptionType ALREADY_LINKED = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"You already have a Discord account linked."));
    private static final SimpleCommandExceptionType NOT_LINKED = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"You do not have a Discord account linked."));
    private static final SimpleCommandExceptionType DATABASE_ERROR = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"There was an error accessing the link database! Contact the server owner."));
    private static final SimpleCommandExceptionType LINKING_OFF = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Account linking is unavailable."));

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder builder = class_2170.method_9247((String)"dissonance");
        MinecraftCommands.registerPurgeCommand((LiteralArgumentBuilder<class_2168>)builder);
        MinecraftCommands.registerLinkCommand((LiteralArgumentBuilder<class_2168>)builder);
        MinecraftCommands.registerUnlinkCommand((LiteralArgumentBuilder<class_2168>)builder);
        dispatcher.register(builder);
    }

    public static Predicate<class_2168> getPermissionPredicate(String permission, int value) {
        return s -> s.method_43737() ? Services.PLATFORM.hasPermission(s.method_44023(), permission, value) : s.method_9259(value);
    }

    private static void registerPurgeCommand(LiteralArgumentBuilder<class_2168> root) {
        root.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"purge").requires(class_2168::method_43737)).requires(MinecraftCommands.getPermissionPredicate("dissonance.purge", 4))).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            TextChannel channel = MinecraftToDiscordBridge.getOutputChannel();
            if (channel == null || !channel.getGuild().getSelfMember().hasPermission((GuildChannel)channel, new Permission[]{Permission.MESSAGE_MANAGE})) {
                throw NO_CHANNEL.create();
            }
            ((CompletableFuture)((CompletableFuture)channel.getIterableHistory().takeAsync(IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")).thenAccept(arg_0 -> ((TextChannel)channel).purgeMessages(arg_0))).thenAccept(f -> ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Successfully purged messages!"), false))).exceptionally(error -> {
                Constants.LOG.error("Couldn't purge messages.", error);
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"There was an error while trying to purge messages."));
                return null;
            });
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Attempting to purge messages..."));
            return 0;
        })));
    }

    private static void registerUnlinkCommand(LiteralArgumentBuilder<class_2168> root) {
        root.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"unlink").requires(MinecraftCommands.getPermissionPredicate("dissonance.unlink", 0))).executes(context -> {
            if (!DiscordLinking.isConnected()) {
                throw LINKING_OFF.create();
            }
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            UUID uuid = player.method_5667();
            if (DiscordLinking.getDiscordFromMinecraft(uuid) == null) {
                throw NOT_LINKED.create();
            }
            try {
                DiscordLinking.removeLinkFromMinecraft(uuid);
                class_5250 message = class_2561.method_43470((String)"Successfully unlinked account!");
                if (DiscordLinking.isWhitelistEnabled()) {
                    player.field_13987.method_52396((class_2561)message.method_27692(class_124.field_1060));
                } else {
                    ((class_2168)context.getSource()).method_9226(() -> message, false);
                }
            }
            catch (SQLException exception) {
                throw DATABASE_ERROR.create();
            }
            return 0;
        }));
    }

    private static void registerLinkCommand(LiteralArgumentBuilder<class_2168> root) {
        root.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"link").requires(MinecraftCommands.getPermissionPredicate("dissonance.link", 0))).executes(context -> {
            if (!DiscordLinking.isConnected()) {
                throw LINKING_OFF.create();
            }
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            UUID uuid = player.method_5667();
            if (DiscordLinking.getDiscordFromMinecraft(uuid) != null) {
                throw ALREADY_LINKED.create();
            }
            String linkCode = DiscordLinking.generateCode(player.method_7334());
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Your link code is ").method_10852((class_2561)class_2561.method_43470((String)linkCode).method_27692(class_124.field_1067)), false);
            return 0;
        }));
    }
}

