/*
 * Decompiled with CFR 0.152.
 */
package me.candiesjar.fallbackserver;

import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Dependency;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.regex.Pattern;
import lombok.Generated;
import me.candiesjar.fallbackserver.cache.OnlineLobbiesManager;
import me.candiesjar.fallbackserver.cache.PlayerCacheManager;
import me.candiesjar.fallbackserver.cache.ServerTypeManager;
import me.candiesjar.fallbackserver.commands.base.FallbackVelocityCommand;
import me.candiesjar.fallbackserver.commands.base.HubCommand;
import me.candiesjar.fallbackserver.enums.VelocityConfig;
import me.candiesjar.fallbackserver.enums.VelocityVersion;
import me.candiesjar.fallbackserver.libs.net.byteflux.libby.Library;
import me.candiesjar.fallbackserver.libs.net.byteflux.libby.VelocityLibraryManager;
import me.candiesjar.fallbackserver.listeners.CommandListener;
import me.candiesjar.fallbackserver.listeners.JoinListener;
import me.candiesjar.fallbackserver.listeners.KickListener;
import me.candiesjar.fallbackserver.listeners.PlayerListener;
import me.candiesjar.fallbackserver.listeners.ReconnectListener;
import me.candiesjar.fallbackserver.listeners.ServerSwitchListener;
import me.candiesjar.fallbackserver.objects.text.TextFile;
import me.candiesjar.fallbackserver.stats.VelocityMetrics;
import me.candiesjar.fallbackserver.utils.LoaderUtil;
import me.candiesjar.fallbackserver.utils.PluginUtil;
import me.candiesjar.fallbackserver.utils.Utils;
import me.candiesjar.fallbackserver.utils.WorldUtil;
import me.candiesjar.fallbackserver.utils.checks.OutdatedChecks;
import me.candiesjar.fallbackserver.utils.tasks.PingTask;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.slf4j.Logger;
import ru.vyarus.yaml.updater.YamlUpdater;
import ru.vyarus.yaml.updater.profile.ProdConfigurator;
import ru.vyarus.yaml.updater.util.FileUtils;

@Plugin(id="fallbackservervelocity", name="FallbackServerVelocity", version="3.2.0-Beta3.5", url="github.com/sasi2006166", authors={"CandiesJar"}, dependencies={@Dependency(id="limboapi", optional=true)})
public class FallbackServerVelocity {
    private static FallbackServerVelocity instance;
    private TextFile configTextFile;
    private TextFile messagesTextFile;
    private TextFile serversTextFile;
    private TextFile versionTextFile;
    public final String version = "3.2.0-Beta3.5";
    private boolean limboApi = false;
    private Pattern pattern;
    private MiniMessage miniMessage;
    private boolean reconnect = false;
    private boolean beta = false;
    private boolean outdated = false;
    private boolean ajQueue = false;
    private boolean maintenance = false;
    private boolean debug = false;
    private final ProxyServer server;
    private final Logger logger;
    private final ComponentLogger componentLogger;
    private final VelocityMetrics.Factory metricsFactory;
    private final PluginContainer pluginContainer;
    private final Path path;
    private ServerTypeManager serverTypeManager;
    private OnlineLobbiesManager onlineLobbiesManager;
    private PlayerCacheManager playerCacheManager;
    private final ChannelIdentifier reconnectIdentifier = MinecraftChannelIdentifier.create((String)"fs", (String)"reconnect");

    @Inject
    public FallbackServerVelocity(ProxyServer server, Logger logger, VelocityMetrics.Factory metricsFactory, PluginContainer pluginContainer, @DataDirectory Path path, ComponentLogger componentLogger) {
        this.server = server;
        this.logger = logger;
        this.metricsFactory = metricsFactory;
        this.pluginContainer = pluginContainer;
        this.path = path;
        this.componentLogger = componentLogger;
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        instance = this;
        this.miniMessage = MiniMessage.miniMessage();
        this.serverTypeManager = ServerTypeManager.getInstance();
        this.onlineLobbiesManager = OnlineLobbiesManager.getInstance();
        this.playerCacheManager = PlayerCacheManager.getInstance();
        this.pattern = Pattern.compile("#[a-fA-F0-9]{6}");
        this.getComponentLogger().info(this.getMiniMessage().deserialize((Object)"<gradient:#00ffff:#0055ff>\n  _____     _ _ _                _     ____                          \n |  ___|_ _| | | |__   __ _  ___| | __/ ___|  ___ _ ____   _____ _ __\n | |_ / _` | | | '_ \\ / _` |/ __| |/ /\\___ \\ / _ \\ '__\\ \\ / / _ \\ '__|\n |  _| (_| | | | |_) | (_| | (__|   <  ___) |  __/ |   \\ V /  __/ |   \n |_|  \\__,_|_|_|_.__/ \\__,_|\\___|_|\\_\\|____/ \\___|_|    \\_/ \\___|_|  \n</gradient>"));
        this.loadDependencies();
        this.loadConfiguration();
        OutdatedChecks.handle();
        this.updateConfiguration();
        this.checkPlugins();
        this.loadServers();
        this.loadCommands();
        this.loadListeners();
        this.loadStats(this.metricsFactory);
        this.loadTask();
        this.getComponentLogger().info(this.getMiniMessage().deserialize((Object)"<gray>[<aqua>!<gray>] <aqua>FallbackServer <gray>loaded successfully"));
        this.checkBeta();
        this.checkUpdate();
        this.sendOutdated();
        this.checkDebug();
    }

    @Subscribe
    public void onProxyShutdown(ProxyShutdownEvent event) {
        this.getComponentLogger().info(this.getMiniMessage().deserialize((Object)"<gray>[<aqua>!<gray>] <aqua>FallbackServer <gray>is disabling.."));
    }

    private void loadDependencies() {
        VelocityLibraryManager<FallbackServerVelocity> libraryManager = new VelocityLibraryManager<FallbackServerVelocity>((Logger)this.getComponentLogger(), this.getPath(), this.getServer().getPluginManager(), this);
        Library library = Library.builder().groupId("me{}carleslc{}Simple-YAML").artifactId("Simple-Yaml").version("1.8.4").build();
        Library updater = Library.builder().groupId("ru{}vyarus").artifactId("yaml-config-updater").version("1.4.2").build();
        libraryManager.addJitPack();
        libraryManager.addMavenCentral();
        libraryManager.loadLibrary(library);
        libraryManager.loadLibrary(updater);
    }

    private void loadConfiguration() {
        this.configTextFile = new TextFile(this.path, "config.yml");
        this.messagesTextFile = new TextFile(this.path, "messages.yml");
        this.serversTextFile = new TextFile(this.path, "servers.yml");
        this.versionTextFile = new TextFile(this.path, "version.yml");
    }

    private void updateConfiguration() {
        if (!this.outdated && this.pluginContainer.getDescription().getVersion().isEmpty()) {
            return;
        }
        if (!this.outdated && ((String)this.pluginContainer.getDescription().getVersion().get()).equals(VelocityVersion.VERSION.getString())) {
            return;
        }
        this.getComponentLogger().info(this.getMiniMessage().deserialize((Object)"<gray>[<aqua>!<gray>] Updating configuration..."));
        ((ProdConfigurator)YamlUpdater.create((File)new File(this.getPath() + "/config.yml"), (InputStream)FileUtils.findFile((String)"https://raw.githubusercontent.com/sasi2006166/Fallback-Server/main/src/main/resources/config.yml")).backup(true)).update();
        ((ProdConfigurator)YamlUpdater.create((File)new File(this.getPath() + "/messages.yml"), (InputStream)FileUtils.findFile((String)"https://raw.githubusercontent.com/sasi2006166/Fallback-Server/main/src/main/resources/messages.yml")).backup(true)).update();
        this.versionTextFile.getConfig().set("version", this.pluginContainer.getDescription().getVersion().get());
        this.versionTextFile.save();
        this.loadConfiguration();
    }

    private void loadCommands() {
        this.getComponentLogger().info(this.getMiniMessage().deserialize((Object)"<gray>[<aqua>!<gray>] Loading commands..."));
        CommandMeta meta = this.server.getCommandManager().metaBuilder("fallbackserver").aliases(new String[]{"fsv", "fallback", "fs"}).build();
        this.server.getCommandManager().register(meta, (Command)new FallbackVelocityCommand(this, this));
        boolean isLobbyCommandEnabled = VelocityConfig.LOBBY_COMMAND.get(Boolean.class);
        if (isLobbyCommandEnabled) {
            String[] aliases = VelocityConfig.LOBBY_ALIASES.getStringList().toArray(new String[0]);
            if (aliases.length == 0) {
                this.getComponentLogger().error(this.getMiniMessage().deserialize((Object)"<gray>[<aqua>!<gray>] \u00a7cYou have to set at least one alias for the lobby command!"));
                this.getComponentLogger().error(this.getMiniMessage().deserialize((Object)"<gray>[<aqua>!<gray>] \u00a7cUsing default 'hub' alias."));
                aliases = new String[]{"hub"};
            }
            CommandMeta commandMeta = this.server.getCommandManager().metaBuilder(VelocityConfig.LOBBY_ALIASES.getStringList().get(0)).aliases(aliases).build();
            this.server.getCommandManager().register(commandMeta, (Command)new HubCommand(this));
        }
    }

    private void checkPlugins() {
        if (this.getServer().getPluginManager().getPlugin("ajQueue").isPresent()) {
            this.setAjQueue(true);
        }
        if (this.getServer().getPluginManager().getPlugin("Maintenance").isPresent()) {
            PluginContainer container = (PluginContainer)this.getServer().getPluginManager().getPlugin("Maintenance").get();
            String author = container.getDescription().getAuthors().toString();
            if (!author.equalsIgnoreCase("kennytv")) {
                return;
            }
            this.setMaintenance(true);
        }
        if (this.getServer().getPluginManager().getPlugin("limboapi").isPresent()) {
            this.setLimboApi(true);
        }
        if (this.getServer().getPluginManager().getPlugin("velocity-tools").isPresent()) {
            PluginUtil.handle();
        }
    }

    private void loadListeners() {
        this.getComponentLogger().info(this.getMiniMessage().deserialize((Object)"<gray>[<aqua>!<gray>] Preparing events..."));
        this.server.getEventManager().register((Object)this, (Object)new KickListener(this));
        boolean updateChecker = VelocityConfig.UPDATER.get(Boolean.class);
        boolean disabledServers = VelocityConfig.USE_COMMAND_BLOCKER.get(Boolean.class);
        boolean joinSorting = VelocityConfig.JOIN_BALANCING.get(Boolean.class);
        if (updateChecker) {
            this.server.getEventManager().register((Object)this, (Object)new PlayerListener(this));
        }
        if (disabledServers) {
            this.server.getEventManager().register((Object)this, (Object)new CommandListener(this));
        }
        if (joinSorting) {
            this.server.getEventManager().register((Object)this, (Object)new JoinListener(this));
        }
    }

    private void loadStats(VelocityMetrics.Factory factory) {
        boolean shouldUseStatistics = VelocityConfig.TELEMETRY.get(Boolean.class);
        if (shouldUseStatistics) {
            factory.make(this, 12602);
        }
    }

    private void loadTask() {
        String mode = VelocityConfig.PING_MODE.get(String.class);
        this.getComponentLogger().info(this.getMiniMessage().deserialize((Object)("<gray>[<aqua>!<gray>] Using <aqua>" + mode + " <gray>mode for pinging")));
        PingTask.start(mode);
    }

    private void checkBeta() {
        if (this.getVersion().contains("Beta")) {
            this.setBeta(true);
            this.getComponentLogger().warn(" ");
            this.getComponentLogger().warn(this.getMiniMessage().deserialize((Object)"<gray>You're running a <red><bold>BETA VERSION <gray>of the plugin."));
            this.getComponentLogger().warn(this.getMiniMessage().deserialize((Object)"<gray>Updater is disabled for debugging purposes."));
            this.getComponentLogger().warn(this.getMiniMessage().deserialize((Object)"<gray>If you find any bugs, please report them on discord."));
            this.getComponentLogger().warn(" ");
        }
    }

    private void checkUpdate() {
        Utils.getUpdates().whenComplete((result, throwable) -> {
            if (throwable != null) {
                this.getComponentLogger().info(this.getMiniMessage().deserialize((Object)"<gray>[<aqua>!<gray>] An error occurred while checking for updates"));
                this.getComponentLogger().info(this.getMiniMessage().deserialize((Object)throwable.getMessage()));
                return;
            }
            if (result != null && result.booleanValue()) {
                this.getComponentLogger().info(this.getMiniMessage().deserialize((Object)"<gray>[<aqua>!<gray>] A new version of FallbackServerVelocity is available!"));
            }
        });
    }

    private void checkDebug() {
        boolean useDebug = VelocityConfig.DEBUG.get(Boolean.class);
        if (useDebug) {
            this.setDebug(true);
            this.getComponentLogger().warn(" ");
            this.getComponentLogger().warn("You are using the debug mode");
            this.getComponentLogger().warn("Enable this mode only if developer");
            this.getComponentLogger().warn("is asking for it.");
            this.getComponentLogger().warn(" ");
        }
    }

    private void sendOutdated() {
        if (this.outdated) {
            this.getComponentLogger().error(" ");
            this.getComponentLogger().error("Your configuration is outdated!");
            this.getComponentLogger().error("Please update your configuration");
            this.getComponentLogger().error("by deleting the old one and restarting");
            this.getComponentLogger().error("the server.");
            this.getComponentLogger().error(" ");
        }
    }

    public void loadServers() {
        LoaderUtil.loadServers(this.getConfigTextFile().getConfig().getConfigurationSection("settings.fallback"));
        LoaderUtil.loadServers(this.getServersTextFile().getConfig().getConfigurationSection("servers"));
    }

    public void loadReconnect() {
        if (this.reconnect) {
            return;
        }
        this.getComponentLogger().info(this.getMiniMessage().deserialize((Object)"<gray>[<aqua>!<gray>] Running machine checks"));
        if (!this.limboApi) {
            this.getComponentLogger().error("LimboAPI is missing from your plugins folder, for enabling");
            this.getComponentLogger().error("reconnect method you need to install LimboAPI.");
            this.getComponentLogger().error("You can download it from https://github.com/Elytrium/LimboAPI/releases");
            this.setReconnect(false);
            return;
        }
        int coreCount = Runtime.getRuntime().availableProcessors();
        if (coreCount < 2) {
            this.getComponentLogger().error("You're using a single core for your proxy.");
            this.getComponentLogger().error("There is no issue with this, but in long term ");
            this.getComponentLogger().error("it may cause performance issues.");
        }
        WorldUtil.createLimbo();
        this.server.getEventManager().register((Object)this, (Object)new ServerSwitchListener(this));
        this.server.getEventManager().register((Object)this, (Object)new ReconnectListener(this));
        boolean physical = VelocityConfig.RECONNECT_USE_PHYSICAL.get(Boolean.class);
        if (physical) {
            this.server.getChannelRegistrar().register(new ChannelIdentifier[]{this.reconnectIdentifier});
        }
        this.setReconnect(true);
    }

    public void reloadAll() {
        PingTask.getScheduledTask().cancel();
        this.getServerTypeManager().clear();
        this.getOnlineLobbiesManager().clear();
        this.configTextFile.reload();
        this.messagesTextFile.reload();
        this.serversTextFile.reload();
        this.loadServers();
        PingTask.reload();
    }

    @Generated
    public boolean isLimboApi() {
        return this.limboApi;
    }

    @Generated
    public ProxyServer getServer() {
        return this.server;
    }

    @Generated
    public Logger getLogger() {
        return this.logger;
    }

    @Generated
    public ComponentLogger getComponentLogger() {
        return this.componentLogger;
    }

    @Generated
    public VelocityMetrics.Factory getMetricsFactory() {
        return this.metricsFactory;
    }

    @Generated
    public PluginContainer getPluginContainer() {
        return this.pluginContainer;
    }

    @Generated
    public ServerTypeManager getServerTypeManager() {
        return this.serverTypeManager;
    }

    @Generated
    public OnlineLobbiesManager getOnlineLobbiesManager() {
        return this.onlineLobbiesManager;
    }

    @Generated
    public PlayerCacheManager getPlayerCacheManager() {
        return this.playerCacheManager;
    }

    @Generated
    public static FallbackServerVelocity getInstance() {
        return instance;
    }

    @Generated
    public TextFile getConfigTextFile() {
        return this.configTextFile;
    }

    @Generated
    public TextFile getMessagesTextFile() {
        return this.messagesTextFile;
    }

    @Generated
    public TextFile getServersTextFile() {
        return this.serversTextFile;
    }

    @Generated
    public TextFile getVersionTextFile() {
        return this.versionTextFile;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public void setLimboApi(boolean limboApi) {
        this.limboApi = limboApi;
    }

    @Generated
    public Pattern getPattern() {
        return this.pattern;
    }

    @Generated
    public MiniMessage getMiniMessage() {
        return this.miniMessage;
    }

    @Generated
    public boolean isReconnect() {
        return this.reconnect;
    }

    @Generated
    public void setReconnect(boolean reconnect) {
        this.reconnect = reconnect;
    }

    @Generated
    public boolean isBeta() {
        return this.beta;
    }

    @Generated
    public void setBeta(boolean beta) {
        this.beta = beta;
    }

    @Generated
    public boolean isOutdated() {
        return this.outdated;
    }

    @Generated
    public void setOutdated(boolean outdated) {
        this.outdated = outdated;
    }

    @Generated
    public boolean isAjQueue() {
        return this.ajQueue;
    }

    @Generated
    public void setAjQueue(boolean ajQueue) {
        this.ajQueue = ajQueue;
    }

    @Generated
    public boolean isMaintenance() {
        return this.maintenance;
    }

    @Generated
    public void setMaintenance(boolean maintenance) {
        this.maintenance = maintenance;
    }

    @Generated
    public boolean isDebug() {
        return this.debug;
    }

    @Generated
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Generated
    public Path getPath() {
        return this.path;
    }

    @Generated
    public ChannelIdentifier getReconnectIdentifier() {
        return this.reconnectIdentifier;
    }
}

