/*
 * Decompiled with CFR 0.152.
 */
package me.candiesjar.fallbackserver.cache;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;

public class OnlineLobbiesManager {
    private static OnlineLobbiesManager instance;
    private final HashMap<String, List<RegisteredServer>> onlineLobbies = Maps.newHashMap();

    public static OnlineLobbiesManager getInstance() {
        if (instance == null) {
            instance = new OnlineLobbiesManager();
        }
        return instance;
    }

    private OnlineLobbiesManager() {
    }

    public List<RegisteredServer> get(String key) {
        return this.onlineLobbies.get(key);
    }

    public void put(String key, RegisteredServer registeredServer) {
        List<RegisteredServer> serverInfos = this.onlineLobbies.get(key);
        serverInfos.add(registeredServer);
        this.onlineLobbies.put(key, serverInfos);
    }

    public void remove(String key, RegisteredServer registeredServer) {
        List<RegisteredServer> serverInfos = this.onlineLobbies.get(key);
        serverInfos.remove(registeredServer);
        this.onlineLobbies.put(key, serverInfos);
    }

    public boolean containsValue(String key, RegisteredServer registeredServer) {
        List<RegisteredServer> serverInfos = this.onlineLobbies.get(key);
        return serverInfos.contains(registeredServer);
    }

    public void firstLoad(String key) {
        this.onlineLobbies.put(key, Lists.newArrayList());
    }

    public void clear() {
        this.onlineLobbies.clear();
    }

    @Generated
    public HashMap<String, List<RegisteredServer>> getOnlineLobbies() {
        return this.onlineLobbies;
    }
}

