/*
 * Decompiled with CFR 0.152.
 */
package me.candiesjar.fallbackserver.commands.base;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import me.candiesjar.fallbackserver.FallbackServerVelocity;
import me.candiesjar.fallbackserver.commands.interfaces.SubCommand;
import me.candiesjar.fallbackserver.commands.subcommands.AddSubCommand;
import me.candiesjar.fallbackserver.commands.subcommands.GroupSubCommand;
import me.candiesjar.fallbackserver.commands.subcommands.ReloadSubCommand;
import me.candiesjar.fallbackserver.commands.subcommands.ServersSubCommand;
import me.candiesjar.fallbackserver.commands.subcommands.StatusSubCommand;
import me.candiesjar.fallbackserver.enums.VelocityConfig;
import me.candiesjar.fallbackserver.enums.VelocityMessages;
import me.candiesjar.fallbackserver.objects.text.Placeholder;
import me.candiesjar.fallbackserver.utils.player.ChatUtil;

public class FallbackVelocityCommand
implements SimpleCommand {
    private final FallbackServerVelocity plugin;
    private final HashMap<String, SubCommand> subCommands = Maps.newHashMap();

    public FallbackVelocityCommand(FallbackServerVelocity fallbackServerVelocity, FallbackServerVelocity plugin) {
        this.plugin = plugin;
        this.subCommands.put("reload", new ReloadSubCommand(fallbackServerVelocity));
        this.subCommands.put("status", new StatusSubCommand(fallbackServerVelocity));
        this.subCommands.put("servers", new ServersSubCommand(fallbackServerVelocity));
        this.subCommands.put("group", new GroupSubCommand(fallbackServerVelocity));
        this.subCommands.put("add", new AddSubCommand(fallbackServerVelocity));
    }

    public void execute(SimpleCommand.Invocation invocation) {
        CommandSource commandSource = invocation.source();
        String[] args = (String[])invocation.arguments();
        String adminPermission = VelocityConfig.ADMIN_PERMISSION.get(String.class);
        boolean commandWithoutPermission = VelocityConfig.HIDE_COMMAND.get(Boolean.class);
        if (!commandSource.hasPermission(adminPermission) && commandWithoutPermission) {
            return;
        }
        if (!commandSource.hasPermission(adminPermission)) {
            String messageTemplate = "<dark_gray>\u00bb <gray>Running <aqua><underlined>Fallback Server version</underlined> <gray>by <aqua><underlined>CandiesJar</underlined>";
            String formattedMessage = messageTemplate.replace("version", this.plugin.getVersion());
            commandSource.sendMessage(this.plugin.getMiniMessage().deserialize((Object)formattedMessage));
            return;
        }
        if (args.length == 0) {
            VelocityMessages.MAIN_COMMAND.sendList(commandSource, new Placeholder("version", this.plugin.getVersion()));
            return;
        }
        if (!this.subCommands.containsKey(args[0].toLowerCase())) {
            VelocityMessages.CORRECT_SYNTAX.send(commandSource, new Placeholder("prefix", ChatUtil.getFormattedString(VelocityMessages.PREFIX, new Placeholder[0])));
            return;
        }
        SubCommand subCommand = this.subCommands.get(args[0].toLowerCase());
        if (!subCommand.isEnabled()) {
            return;
        }
        if (!commandSource.hasPermission(subCommand.getPermission())) {
            VelocityMessages.NO_PERMISSION.send(commandSource, new Placeholder("prefix", ChatUtil.getFormattedString(VelocityMessages.PREFIX, new Placeholder[0])), new Placeholder("permission", subCommand.getPermission()));
            return;
        }
        subCommand.perform(commandSource, args);
    }

    public CompletableFuture<List<String>> suggestAsync(SimpleCommand.Invocation invocation) {
        return CompletableFuture.supplyAsync(() -> {
            CommandSource commandSource = invocation.source();
            if (!commandSource.hasPermission(VelocityConfig.ADMIN_PERMISSION.get(String.class))) {
                return Collections.emptyList();
            }
            if (!VelocityConfig.TAB_COMPLETE.get(Boolean.class).booleanValue()) {
                return Collections.emptyList();
            }
            String[] args = (String[])invocation.arguments();
            switch (args.length) {
                case 0: 
                case 1: {
                    LinkedList completion = Lists.newLinkedList(this.subCommands.keySet());
                    Collections.sort(completion);
                    return completion;
                }
            }
            return Collections.emptyList();
        });
    }
}

