/*
 * Decompiled with CFR 0.152.
 */
package me.candiesjar.fallbackserver.commands.subcommands;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.util.List;
import lombok.Generated;
import me.candiesjar.fallbackserver.FallbackServerVelocity;
import me.candiesjar.fallbackserver.commands.interfaces.SubCommand;
import me.candiesjar.fallbackserver.enums.VelocityConfig;
import me.candiesjar.fallbackserver.enums.VelocityMessages;
import me.candiesjar.fallbackserver.managers.ServerManager;
import me.candiesjar.fallbackserver.objects.ServerType;
import me.candiesjar.fallbackserver.objects.text.Placeholder;
import me.candiesjar.fallbackserver.utils.Utils;
import org.simpleyaml.configuration.ConfigurationSection;

public class AddSubCommand
implements SubCommand {
    private final FallbackServerVelocity plugin;

    @Override
    public String getPermission() {
        return VelocityConfig.ADD_COMMAND_PERMISSION.get(String.class);
    }

    @Override
    public boolean isEnabled() {
        return VelocityConfig.ADD_COMMAND.get(Boolean.class);
    }

    @Override
    public void perform(CommandSource commandSource, String[] args) {
        if (args.length != 3) {
            VelocityMessages.EMPTY_GROUP.send(commandSource, new Placeholder[0]);
            return;
        }
        String group = args[1];
        String serverName = args[2];
        if (!ServerManager.checkIfGroupExists(group)) {
            return;
        }
        RegisteredServer server = this.plugin.getServer().getServer(serverName).orElse(null);
        if (server == null) {
            return;
        }
        ServerType serverType = this.plugin.getServerTypeManager().get(group);
        List<String> servers = serverType.getServers();
        if (servers.contains(serverName)) {
            return;
        }
        this.addServer(group, serverName);
        Utils.printDebug("\u00a77[\u00a7a+\u00a77] Added server \u00a7a" + serverName + " \u00a77to group \u00a7a" + group, true);
    }

    private void addServer(String group, String serverName) {
        ConfigurationSection section = this.plugin.getServersTextFile().getConfig().getConfigurationSection("servers." + group);
        List servers = section.getStringList("servers");
        servers.add(serverName);
        section.set("servers", (Object)servers);
        this.plugin.getServersTextFile().save();
    }

    @Generated
    public AddSubCommand(FallbackServerVelocity plugin) {
        this.plugin = plugin;
    }
}

