/*
 * Decompiled with CFR 0.152.
 */
package me.candiesjar.fallbackserver.commands.subcommands;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import lombok.Generated;
import me.candiesjar.fallbackserver.FallbackServerVelocity;
import me.candiesjar.fallbackserver.commands.interfaces.SubCommand;
import me.candiesjar.fallbackserver.enums.VelocityConfig;
import me.candiesjar.fallbackserver.handler.DebugLimboHandler;
import me.candiesjar.fallbackserver.utils.WorldUtil;
import me.candiesjar.fallbackserver.utils.player.ChatUtil;
import net.elytrium.limboapi.api.LimboSessionHandler;
import net.kyori.adventure.text.Component;

public class DebugSubCommand
implements SubCommand {
    private final FallbackServerVelocity plugin;

    @Override
    public String getPermission() {
        return VelocityConfig.DEBUG_PERMISSION.get(String.class);
    }

    @Override
    public boolean isEnabled() {
        return this.plugin.isDebug();
    }

    @Override
    public void perform(CommandSource commandSource, String[] args) {
        if (args.length < 2) {
            commandSource.sendMessage((Component)Component.text((String)ChatUtil.formatColor("&cIncorrent arguments!")));
            return;
        }
        String command = args[1];
        if (command.equalsIgnoreCase("spawn")) {
            Player player = (Player)commandSource;
            WorldUtil.getFallbackLimbo().spawnPlayer(player, (LimboSessionHandler)new DebugLimboHandler());
        }
        if (command.equalsIgnoreCase("ping")) {
            if (args.length < 3) {
                commandSource.sendMessage((Component)Component.text((String)ChatUtil.formatColor("&cNo server provided!")));
                return;
            }
            String serverName = args[2];
            commandSource.sendMessage((Component)Component.text((String)ChatUtil.formatColor("&cPinging server " + serverName + "...")));
            RegisteredServer serverInfo = (RegisteredServer)this.plugin.getServer().getServer(serverName).get();
            serverInfo.ping().whenComplete((result, error) -> {
                if (error != null || result == null) {
                    commandSource.sendMessage((Component)Component.text((String)ChatUtil.formatColor("&cError while pinging server!")));
                    return;
                }
                commandSource.sendMessage((Component)Component.text((String)ChatUtil.formatColor("&aServer pinged successfully!")));
                commandSource.sendMessage((Component)Component.text((String)ChatUtil.formatColor("&aPlayers online: " + result.getPlayers().get())));
                commandSource.sendMessage((Component)Component.text((String)ChatUtil.formatColor("&aVersion: " + result.getVersion().getName())));
                commandSource.sendMessage((Component)Component.text((String)ChatUtil.formatColor("&aMax players: " + result.asBuilder().getMaximumPlayers())));
            });
        }
    }

    @Generated
    public DebugSubCommand(FallbackServerVelocity plugin) {
        this.plugin = plugin;
    }
}

