/*
 * Decompiled with CFR 0.152.
 */
package me.candiesjar.fallbackserver.commands.subcommands;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import me.candiesjar.fallbackserver.FallbackServerVelocity;
import me.candiesjar.fallbackserver.cache.OnlineLobbiesManager;
import me.candiesjar.fallbackserver.commands.interfaces.SubCommand;
import me.candiesjar.fallbackserver.enums.VelocityConfig;
import me.candiesjar.fallbackserver.enums.VelocityMessages;
import me.candiesjar.fallbackserver.managers.ServerManager;
import me.candiesjar.fallbackserver.objects.text.Placeholder;

public class ServersSubCommand
implements SubCommand {
    private final OnlineLobbiesManager onlineLobbiesManager;

    public ServersSubCommand(FallbackServerVelocity plugin) {
        this.onlineLobbiesManager = plugin.getOnlineLobbiesManager();
    }

    @Override
    public String getPermission() {
        return VelocityConfig.SERVERS_COMMAND_PERMISSION.get(String.class);
    }

    @Override
    public boolean isEnabled() {
        return VelocityConfig.SERVERS_COMMAND.get(Boolean.class);
    }

    @Override
    public void perform(CommandSource sender, String[] args) {
        HashMap<String, List<RegisteredServer>> onlineLobbies = this.onlineLobbiesManager.getOnlineLobbies();
        if (onlineLobbies.isEmpty()) {
            return;
        }
        VelocityMessages.SERVERS_COMMAND_HEADER.sendList(sender, new Placeholder[0]);
        onlineLobbies.forEach((group, servers) -> {
            servers.removeIf(Objects::isNull);
            if (!servers.isEmpty()) {
                VelocityMessages.SERVERS_COMMAND_GROUP.send(sender, new Placeholder("group", (String)group));
                servers.forEach(server -> {
                    String status = ServerManager.checkMaintenance(server) ? VelocityMessages.SERVERS_COMMAND_MAINTENANCE.get(String.class) : VelocityMessages.SERVERS_COMMAND_ONLINE.get(String.class);
                    VelocityMessages.SERVERS_COMMAND_LIST.send(sender, new Placeholder("server", server.getServerInfo().getName()), new Placeholder("status", status));
                });
            }
        });
        VelocityMessages.SERVERS_COMMAND_FOOTER.sendList(sender, new Placeholder[0]);
    }
}

