/*
 * Decompiled with CFR 0.152.
 */
package me.candiesjar.fallbackserver.handler;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.event.player.KickedFromServerEvent;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.PingOptions;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.scheduler.ScheduledTask;
import com.velocitypowered.api.scheduler.Scheduler;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import me.candiesjar.fallbackserver.FallbackServerVelocity;
import me.candiesjar.fallbackserver.enums.TitleMode;
import me.candiesjar.fallbackserver.enums.VelocityConfig;
import me.candiesjar.fallbackserver.enums.VelocityMessages;
import me.candiesjar.fallbackserver.objects.text.Placeholder;
import me.candiesjar.fallbackserver.utils.ReconnectUtil;
import me.candiesjar.fallbackserver.utils.player.ChatUtil;
import me.candiesjar.fallbackserver.utils.player.TitleUtil;
import net.elytrium.limboapi.api.Limbo;
import net.elytrium.limboapi.api.LimboSessionHandler;
import net.elytrium.limboapi.api.player.LimboPlayer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.title.Title;

public class FallbackLimboHandler
implements LimboSessionHandler {
    private final AtomicInteger tries = new AtomicInteger(0);
    private final AtomicInteger dots = new AtomicInteger(0);
    private final int timeout = VelocityConfig.RECONNECT_PING_TIMEOUT.get(Integer.class);
    private final int maxTries = VelocityConfig.RECONNECT_MAX_TRIES.get(Integer.class);
    private final PingOptions.Builder pingOptions = PingOptions.builder().timeout(Duration.ofSeconds(this.timeout));
    private final FallbackServerVelocity fallbackServerVelocity = FallbackServerVelocity.getInstance();
    private final Scheduler scheduler = this.fallbackServerVelocity.getServer().getScheduler();
    private final RegisteredServer target;
    private final UUID uuid;
    private final Player player;
    private LimboPlayer limboPlayer;
    private ScheduledTask reconnectTask;
    private ScheduledTask titleTask;
    private ScheduledTask connectTask;

    public void onSpawn(Limbo server, LimboPlayer limboPlayer) {
        this.limboPlayer = limboPlayer;
        limboPlayer.disableFalling();
        TitleMode titleMode = TitleMode.fromString(VelocityConfig.RECONNECT_TITLE_MODE.get(String.class));
        this.titleTask = this.scheduleTask(() -> this.sendTitles(VelocityMessages.RECONNECT_TITLE, VelocityMessages.RECONNECT_SUB_TITLE), this.getTitleDelay(this.player), titleMode.getPeriod());
        this.reconnectTask = this.scheduleTask(() -> this.startReconnect(limboPlayer), 0, VelocityConfig.RECONNECT_TASK_DELAY.get(Integer.class));
        boolean physical = VelocityConfig.RECONNECT_USE_PHYSICAL.get(Boolean.class);
        if (physical) {
            String physicalServerName = VelocityConfig.RECONNECT_PHYSICAL_SERVER.get(String.class);
            RegisteredServer physicalServer = this.fallbackServerVelocity.getServer().getServer(physicalServerName).orElse(null);
            limboPlayer.disconnect(physicalServer);
        }
    }

    public void onChat(String chat) {
        if (chat.startsWith("/")) {
            String command = chat.substring(1);
            this.fallbackServerVelocity.getServer().getCommandManager().executeImmediatelyAsync((CommandSource)this.player, command);
            return;
        }
        for (UUID uuid : this.fallbackServerVelocity.getPlayerCacheManager().getReconnectMap().keySet()) {
            Player target = this.fallbackServerVelocity.getServer().getPlayer(uuid).orElse(null);
            if (target == null) continue;
            String fullMessage = this.player.getUsername() + ": " + chat;
            target.sendMessage((Component)Component.text((String)fullMessage));
        }
    }

    private void startReconnect(LimboPlayer limboPlayer) {
        boolean maxTries;
        boolean bl = maxTries = this.tries.getAndIncrement() == this.maxTries;
        if (maxTries) {
            boolean fallback = VelocityConfig.RECONNECT_USE_FALLBACK.get(Boolean.class);
            if (fallback) {
                this.handleFallback(limboPlayer);
                return;
            }
            ReconnectUtil.cancelReconnect(this.uuid);
            boolean physical = VelocityConfig.RECONNECT_USE_PHYSICAL.get(Boolean.class);
            if (physical) {
                this.player.disconnect((Component)Component.empty());
                return;
            }
            limboPlayer.disconnect();
            return;
        }
        this.target.ping(this.pingOptions.build()).whenComplete((ping, throwable) -> {
            if (throwable != null || ping == null) {
                return;
            }
            int connectedPlayers = ping.asBuilder().getOnlinePlayers();
            int maxPlayers = ping.asBuilder().getMaximumPlayers();
            int check = VelocityConfig.RECONNECT_PLAYER_COUNT_CHECK.get(Integer.class);
            if (connectedPlayers == maxPlayers) {
                this.tries.set(this.maxTries);
                return;
            }
            if (maxPlayers != check) {
                return;
            }
            this.titleTask.cancel();
            this.reconnectTask.cancel();
            this.titleTask = this.scheduleTask(() -> this.sendTitles(VelocityMessages.CONNECTING_TITLE, VelocityMessages.CONNECTING_SUB_TITLE), 1, 1);
            this.connectTask = this.scheduleTask(() -> {
                this.target.ping().whenComplete((ping1, throwable1) -> {
                    if (throwable1 != null || ping1 == null) {
                        this.handleFallback(limboPlayer);
                    }
                });
                this.handleConnection(limboPlayer);
            }, VelocityConfig.RECONNECT_TASK_DELAY.get(Integer.class) + 2, 0);
        });
    }

    private void handleConnection(LimboPlayer limboPlayer) {
        boolean physical;
        this.titleTask.cancel();
        this.clearPlayerTitle();
        this.showConnectedTitle();
        boolean clearChat = VelocityConfig.CLEAR_CHAT_RECONNECT.get(Boolean.class);
        if (clearChat) {
            ChatUtil.clearChat(this.player);
        }
        if (physical = VelocityConfig.RECONNECT_USE_PHYSICAL.get(Boolean.class).booleanValue()) {
            this.player.createConnectionRequest(this.target).fireAndForget();
            return;
        }
        limboPlayer.disconnect(this.target);
    }

    private void handleFallback(LimboPlayer limboPlayer) {
        limboPlayer.flushPackets();
        RegisteredServer registeredServer = (RegisteredServer)this.fallbackServerVelocity.getServer().getServer("FallbackLimbo").get();
        TextComponent reason = Component.text((String)"Lost Connection");
        KickedFromServerEvent.ServerKickResult serverKickResult = KickedFromServerEvent.RedirectPlayer.create((RegisteredServer)registeredServer);
        KickedFromServerEvent kickedFromServerEvent = new KickedFromServerEvent(this.player, registeredServer, (Component)reason, false, serverKickResult);
        this.fallbackServerVelocity.getServer().getEventManager().fireAndForget((Object)kickedFromServerEvent);
        KickedFromServerEvent.ServerKickResult serverKickResult2 = kickedFromServerEvent.getResult();
        if (serverKickResult2 instanceof KickedFromServerEvent.RedirectPlayer) {
            KickedFromServerEvent.RedirectPlayer redirectPlayer = (KickedFromServerEvent.RedirectPlayer)serverKickResult2;
            registeredServer = redirectPlayer.getServer();
        }
        boolean physical = VelocityConfig.RECONNECT_USE_PHYSICAL.get(Boolean.class);
        if (kickedFromServerEvent.getResult() instanceof KickedFromServerEvent.DisconnectPlayer) {
            if (physical) {
                this.player.disconnect((Component)Component.empty());
                return;
            }
            limboPlayer.disconnect();
            return;
        }
        if (physical) {
            this.clearPlayerTitle();
            this.player.createConnectionRequest(registeredServer).fireAndForget();
            this.scheduleTask(() -> {
                ReconnectUtil.cancelReconnect(this.uuid);
                VelocityMessages.RECONNECTION_FAILED.send((CommandSource)this.player, new Placeholder("server", this.target.getServerInfo().getName()), new Placeholder("prefix", ChatUtil.getFormattedString(VelocityMessages.PREFIX, new Placeholder[0])));
            }, 4, 0);
            return;
        }
        this.clearPlayerTitle();
        limboPlayer.disconnect(registeredServer);
        this.scheduleTask(() -> {
            ReconnectUtil.cancelReconnect(this.uuid);
            VelocityMessages.RECONNECTION_FAILED.send((CommandSource)this.player, new Placeholder("server", this.target.getServerInfo().getName()), new Placeholder("prefix", ChatUtil.getFormattedString(VelocityMessages.PREFIX, new Placeholder[0])));
        }, 4, 0);
    }

    private void sendTitles(VelocityMessages title, VelocityMessages subTitle) {
        int currentDots = this.dots.incrementAndGet() % 5;
        TitleMode titleMode = TitleMode.fromString(VelocityConfig.RECONNECT_TITLE_MODE.get(String.class));
        switch (titleMode) {
            case NORMAL: {
                TitleUtil.sendReconnectingTitle(0, 20, currentDots, title, subTitle, this.player);
                break;
            }
            case STATIC: {
                TitleUtil.sendTitle(0, 20, 0, title.get(String.class), subTitle.get(String.class), this.target, this.player);
                break;
            }
            case PULSE: {
                TitleUtil.sendTitle(1, 20, VelocityMessages.RECONNECT_TITLE_BEAT.get(Integer.class), title.get(String.class), subTitle.get(String.class), this.target, this.player);
            }
        }
    }

    private void showConnectedTitle() {
        int fadeIn = VelocityMessages.CONNECTED_FADE_IN.get(Integer.class);
        int stay = VelocityMessages.CONNECTED_STAY.get(Integer.class);
        int fadeOut = VelocityMessages.CONNECTED_FADE_OUT.get(Integer.class);
        int delay = VelocityMessages.CONNECTED_DELAY.get(Integer.class);
        this.scheduler.buildTask((Object)this.fallbackServerVelocity, () -> TitleUtil.sendTitle(fadeIn, stay, fadeOut, VelocityMessages.CONNECTED_TITLE.get(String.class), VelocityMessages.CONNECTED_SUB_TITLE.get(String.class), this.target, this.player)).delay((long)delay, TimeUnit.SECONDS).schedule();
        this.scheduler.buildTask((Object)this.fallbackServerVelocity, () -> ReconnectUtil.cancelReconnect(this.uuid)).delay(3L, TimeUnit.SECONDS).schedule();
    }

    private ScheduledTask scheduleTask(Runnable runnable, int delay, int period) {
        return this.scheduler.buildTask((Object)this.fallbackServerVelocity, runnable).delay((long)delay, TimeUnit.SECONDS).repeat((long)period, TimeUnit.SECONDS).schedule();
    }

    public void clearPlayerTitle() {
        this.player.showTitle(Title.title((Component)Component.empty(), (Component)Component.empty()));
        this.player.clearTitle();
        this.player.resetTitle();
    }

    private int getTitleDelay(Player player) {
        if (player.getProtocolVersion().greaterThan((Object)ProtocolVersion.MINECRAFT_1_20_2)) {
            return 3;
        }
        return 0;
    }

    @Generated
    public FallbackLimboHandler(RegisteredServer target, UUID uuid, Player player) {
        this.target = target;
        this.uuid = uuid;
        this.player = player;
    }

    @Generated
    public RegisteredServer getTarget() {
        return this.target;
    }

    @Generated
    public LimboPlayer getLimboPlayer() {
        return this.limboPlayer;
    }

    @Generated
    public ScheduledTask getReconnectTask() {
        return this.reconnectTask;
    }

    @Generated
    public ScheduledTask getTitleTask() {
        return this.titleTask;
    }

    @Generated
    public ScheduledTask getConnectTask() {
        return this.connectTask;
    }
}

