/*
 * Decompiled with CFR 0.152.
 */
package me.candiesjar.fallbackserver.listeners;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.command.CommandExecuteEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import me.candiesjar.fallbackserver.FallbackServerVelocity;
import me.candiesjar.fallbackserver.enums.VelocityConfig;
import me.candiesjar.fallbackserver.enums.VelocityMessages;
import me.candiesjar.fallbackserver.objects.text.Placeholder;
import me.candiesjar.fallbackserver.utils.player.ChatUtil;

public class CommandListener {
    private final FallbackServerVelocity fallbackServerVelocity;

    @Subscribe
    public void onPlayerChat(CommandExecuteEvent event) {
        List blockedCommands;
        boolean isBlacklistedCommand;
        CommandSource commandSource = event.getCommandSource();
        if (!(commandSource instanceof Player)) {
            return;
        }
        Player player = (Player)commandSource;
        Optional serverConnectionOptional = player.getCurrentServer();
        if (serverConnectionOptional.isEmpty()) {
            return;
        }
        ServerConnection serverConnection = (ServerConnection)serverConnectionOptional.get();
        String serverName = serverConnection.getServerInfo().getName();
        String command = event.getCommand();
        if (player.hasPermission(VelocityConfig.ADMIN_PERMISSION.get(String.class))) {
            return;
        }
        if (!command.isEmpty()) {
            String[] args = command.split(" ");
            command = args[0];
        }
        if (isBlacklistedCommand = ChatUtil.checkMessage(command, blockedCommands = this.fallbackServerVelocity.getConfigTextFile().getConfig().getStringList("settings.command_blocker_list." + serverName))) {
            event.setResult(CommandExecuteEvent.CommandResult.denied());
            VelocityMessages.BLOCKED_COMMAND.send((CommandSource)player, new Placeholder("prefix", ChatUtil.getFormattedString(VelocityMessages.PREFIX, new Placeholder[0])));
        }
    }

    @Generated
    public CommandListener(FallbackServerVelocity fallbackServerVelocity) {
        this.fallbackServerVelocity = fallbackServerVelocity;
    }
}

