/*
 * Decompiled with CFR 0.152.
 */
package me.candiesjar.fallbackserver.listeners;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.player.KickedFromServerEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import me.candiesjar.fallbackserver.FallbackServerVelocity;
import me.candiesjar.fallbackserver.cache.OnlineLobbiesManager;
import me.candiesjar.fallbackserver.cache.ServerTypeManager;
import me.candiesjar.fallbackserver.enums.VelocityConfig;
import me.candiesjar.fallbackserver.enums.VelocityMessages;
import me.candiesjar.fallbackserver.managers.ServerManager;
import me.candiesjar.fallbackserver.objects.ServerType;
import me.candiesjar.fallbackserver.objects.text.Placeholder;
import me.candiesjar.fallbackserver.utils.ConditionUtil;
import me.candiesjar.fallbackserver.utils.player.ChatUtil;
import me.candiesjar.fallbackserver.utils.player.TitleUtil;
import net.kyori.adventure.text.Component;

public class KickListener {
    private final FallbackServerVelocity plugin;
    private final ServerTypeManager serverTypeManager;
    private final OnlineLobbiesManager onlineLobbiesManager;
    private final Map<String, LongAdder> pendingConnections;

    public KickListener(FallbackServerVelocity plugin) {
        this.plugin = plugin;
        this.serverTypeManager = plugin.getServerTypeManager();
        this.onlineLobbiesManager = plugin.getOnlineLobbiesManager();
        this.pendingConnections = Maps.newConcurrentMap();
    }

    @Subscribe(priority=32767)
    public void onPlayerKick(KickedFromServerEvent event) {
        if (event.kickedDuringServerConnect()) {
            return;
        }
        Player player = event.getPlayer();
        RegisteredServer kickedFrom = event.getServer();
        String kickedName = kickedFrom.getServerInfo() == null ? "" : kickedFrom.getServerInfo().getName();
        boolean isEmpty = event.getServerKickReason().isEmpty();
        String kickReasonString = isEmpty ? "Lost Connection" : ChatUtil.componentToString((Component)event.getServerKickReason().get());
        String group = ServerManager.getGroupByServer(kickedName) == null ? "default" : ServerManager.getGroupByServer(kickedName);
        ServerType serverType = this.serverTypeManager.get(group);
        if (kickedName.equalsIgnoreCase("FallbackLimbo")) {
            this.handleFallback(event, kickedFrom, player, kickReasonString, kickedName, true);
            return;
        }
        boolean physical = VelocityConfig.RECONNECT_USE_PHYSICAL.get(Boolean.class);
        if (physical && kickedName.equalsIgnoreCase(VelocityConfig.RECONNECT_PHYSICAL_SERVER.get(String.class))) {
            this.handleFallback(event, kickedFrom, player, kickReasonString, kickedName, true);
            return;
        }
        if (serverType == null) {
            this.handleFallback(event, kickedFrom, player, kickReasonString, kickedName, false);
            return;
        }
        boolean isReconnect = serverType.isReconnect();
        if (isReconnect && this.plugin.isReconnect()) {
            return;
        }
        this.handleFallback(event, kickedFrom, player, kickReasonString, kickedName, false);
    }

    private void handleFallback(KickedFromServerEvent event, RegisteredServer kickedFrom, Player player, String kickReasonString, String kickedName, boolean reconnect) {
        boolean useTitle;
        boolean clearChat;
        boolean ignoredServer;
        List<String> ignoredReasons = VelocityConfig.IGNORED_REASONS.getStringList();
        if (this.shouldIgnore(kickReasonString, ignoredReasons)) {
            event.setResult((KickedFromServerEvent.ServerKickResult)KickedFromServerEvent.DisconnectPlayer.create((Component)Component.text((String)ChatUtil.formatColor(kickReasonString))));
            return;
        }
        boolean bl = ignoredServer = VelocityConfig.USE_IGNORED_SERVERS.get(Boolean.class) != false && VelocityConfig.IGNORED_SERVERS_LIST.getStringList().contains(kickedName);
        if (ignoredServer) {
            event.setResult((KickedFromServerEvent.ServerKickResult)KickedFromServerEvent.DisconnectPlayer.create((Component)Component.text((String)ChatUtil.formatColor(kickReasonString))));
            return;
        }
        String group = ServerManager.getGroupByServer(kickedName) == null ? "default" : ServerManager.getGroupByServer(kickedName);
        ArrayList lobbies = Lists.newArrayList(this.onlineLobbiesManager.get(group));
        lobbies.removeIf(Objects::isNull);
        lobbies.remove(kickedFrom);
        boolean useMaintenance = this.plugin.isMaintenance();
        if (useMaintenance) {
            lobbies.removeIf(ServerManager::checkMaintenance);
        }
        if (lobbies.isEmpty()) {
            if (kickReasonString.isEmpty()) {
                String disconnectMessage = VelocityMessages.NO_SERVER.get(String.class).replace("%prefix%", ChatUtil.getFormattedString(VelocityMessages.PREFIX, new Placeholder[0]));
                event.setResult((KickedFromServerEvent.ServerKickResult)KickedFromServerEvent.DisconnectPlayer.create((Component)Component.text((String)ChatUtil.formatColor(disconnectMessage))));
                return;
            }
            event.setResult((KickedFromServerEvent.ServerKickResult)KickedFromServerEvent.DisconnectPlayer.create((Component)Component.text((String)ChatUtil.formatColor(kickReasonString))));
            return;
        }
        lobbies.sort(Comparator.comparingInt(server -> server.getPlayersConnected().size() + this.getPendingConnections(server.getServerInfo().getName())));
        RegisteredServer registeredServer = (RegisteredServer)lobbies.get(0);
        event.setResult(KickedFromServerEvent.RedirectPlayer.create((RegisteredServer)registeredServer));
        this.incrementPendingConnections(registeredServer.getServerInfo().getName());
        this.plugin.getServer().getScheduler().buildTask((Object)this.plugin, () -> this.decrementPendingConnections(registeredServer.getServerInfo().getName())).delay(1L, TimeUnit.SECONDS).schedule();
        if (!reconnect && (clearChat = VelocityConfig.CLEAR_CHAT_FALLBACK.get(Boolean.class).booleanValue())) {
            ChatUtil.clearChat(player);
        }
        if (useTitle = VelocityMessages.USE_FALLBACK_TITLE.get(Boolean.class).booleanValue()) {
            this.plugin.getServer().getScheduler().buildTask((Object)this.plugin, () -> TitleUtil.sendTitle(VelocityMessages.FALLBACK_FADE_IN.get(Integer.class), VelocityMessages.FALLBACK_STAY.get(Integer.class), VelocityMessages.FALLBACK_FADE_OUT.get(Integer.class), VelocityMessages.FALLBACK_TITLE.get(String.class), VelocityMessages.FALLBACK_SUB_TITLE.get(String.class), registeredServer, player)).delay((long)(VelocityMessages.FALLBACK_DELAY.get(Integer.class) + 1), TimeUnit.SECONDS).schedule();
        }
        if (!reconnect) {
            VelocityMessages.KICKED_TO_LOBBY.sendList((CommandSource)player, new Placeholder("server", registeredServer.getServerInfo().getName()), new Placeholder("reason", ChatUtil.formatColor(kickReasonString)));
        }
    }

    private int getPendingConnections(String serverName) {
        if (this.pendingConnections.get(serverName) == null) {
            return 0;
        }
        return this.pendingConnections.get(serverName).intValue();
    }

    private void incrementPendingConnections(String serverName) {
        this.pendingConnections.computeIfAbsent(serverName, key -> new LongAdder()).increment();
    }

    private void decrementPendingConnections(String serverName) {
        LongAdder adder = this.pendingConnections.get(serverName);
        if (adder != null) {
            adder.decrement();
        }
    }

    private boolean shouldIgnore(String reason, List<String> ignoredReasons) {
        return ConditionUtil.checkReason(ignoredReasons, reason);
    }
}

