/*
 * Decompiled with CFR 0.152.
 */
package me.candiesjar.fallbackserver.listeners;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.player.ServerConnectedEvent;
import com.velocitypowered.api.proxy.Player;
import java.util.UUID;
import lombok.Generated;
import me.candiesjar.fallbackserver.FallbackServerVelocity;
import me.candiesjar.fallbackserver.enums.VelocityConfig;
import me.candiesjar.fallbackserver.enums.VelocityMessages;
import me.candiesjar.fallbackserver.handler.FallbackLimboHandler;
import me.candiesjar.fallbackserver.objects.text.Placeholder;
import me.candiesjar.fallbackserver.utils.ReconnectUtil;
import me.candiesjar.fallbackserver.utils.Utils;
import me.candiesjar.fallbackserver.utils.player.ChatUtil;

public class PlayerListener {
    private final FallbackServerVelocity plugin;

    @Subscribe
    public void onPlayerJoin(ServerConnectedEvent event) {
        String adminPermission;
        Player player = event.getPlayer();
        if (!player.hasPermission(adminPermission = VelocityConfig.ADMIN_PERMISSION.get(String.class))) {
            return;
        }
        if (this.plugin.isOutdated()) {
            VelocityMessages.OUTDATED.send((CommandSource)player, new Placeholder("prefix", ChatUtil.getFormattedString(VelocityMessages.PREFIX, new Placeholder[0])));
            return;
        }
        if (this.plugin.isBeta()) {
            return;
        }
        Utils.getUpdates().whenComplete((newUpdate, throwable) -> {
            if (throwable != null) {
                return;
            }
            if (newUpdate != null && newUpdate.booleanValue()) {
                VelocityMessages.NEW_UPDATE.sendList((CommandSource)player, new Placeholder("old_version", this.plugin.getVersion()), new Placeholder("new_version", Utils.getRemoteVersion()));
            }
        });
    }

    @Subscribe(priority=32767)
    public void onDisconnect(DisconnectEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        FallbackLimboHandler limboHandler = this.plugin.getPlayerCacheManager().get(uuid);
        if (limboHandler != null) {
            ReconnectUtil.cancelReconnect(uuid);
        }
    }

    @Generated
    public PlayerListener(FallbackServerVelocity plugin) {
        this.plugin = plugin;
    }
}

