/*
 * Decompiled with CFR 0.152.
 */
package me.candiesjar.fallbackserver.listeners;

import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import me.candiesjar.fallbackserver.FallbackServerVelocity;
import me.candiesjar.fallbackserver.enums.VelocityConfig;
import me.candiesjar.fallbackserver.handler.FallbackLimboHandler;
import me.candiesjar.fallbackserver.managers.ServerManager;
import me.candiesjar.fallbackserver.objects.ServerType;
import me.candiesjar.fallbackserver.utils.ConditionUtil;
import me.candiesjar.fallbackserver.utils.WorldUtil;
import me.candiesjar.fallbackserver.utils.player.ChatUtil;
import net.elytrium.limboapi.api.LimboSessionHandler;
import net.elytrium.limboapi.api.event.LoginLimboRegisterEvent;
import net.kyori.adventure.text.Component;

public class ReconnectListener {
    private final FallbackServerVelocity plugin;

    @Subscribe(priority=32767)
    public void onPlayerKick(LoginLimboRegisterEvent event) {
        event.setOnKickCallback(kickEvent -> {
            boolean clearChat;
            List<String> ignoredReasons;
            String group;
            Player player = event.getPlayer();
            RegisteredServer kickedFrom = kickEvent.getServer();
            String kickedFromName = kickedFrom.getServerInfo().getName();
            if (kickEvent.kickedDuringServerConnect()) {
                return false;
            }
            String string = group = ServerManager.getGroupByServer(kickedFromName) == null ? "default" : ServerManager.getGroupByServer(kickedFromName);
            if (group == null) {
                return false;
            }
            ServerType serverType = this.plugin.getServerTypeManager().get(group);
            if (!serverType.isReconnect()) {
                return false;
            }
            Optional componentOptional = kickEvent.getServerKickReason();
            boolean isEmpty = componentOptional.isEmpty();
            String kickReasonString = isEmpty ? "" : ChatUtil.componentToString((Component)componentOptional.get());
            if (this.shouldIgnore(kickReasonString, ignoredReasons = VelocityConfig.RECONNECT_IGNORED_REASONS.getStringList())) {
                return false;
            }
            if (this.checkIgnoredServer(kickedFromName)) {
                player.disconnect((Component)Component.text((String)kickReasonString));
                return false;
            }
            boolean clearTab = VelocityConfig.RECONNECT_CLEAR_TABLIST.get(Boolean.class);
            if (clearTab) {
                player.getTabList().clearAll();
            }
            if (clearChat = VelocityConfig.CLEAR_CHAT_RECONNECT_JOIN.get(Boolean.class).booleanValue()) {
                ChatUtil.clearChat(player);
            }
            FallbackLimboHandler fallbackLimboHandler = new FallbackLimboHandler(kickedFrom, player.getUniqueId(), player);
            this.plugin.getPlayerCacheManager().put(player.getUniqueId(), fallbackLimboHandler);
            WorldUtil.getFallbackLimbo().spawnPlayer(player, (LimboSessionHandler)fallbackLimboHandler);
            return true;
        });
    }

    private boolean checkIgnoredServer(String serverName) {
        return VelocityConfig.RECONNECT_IGNORED_SERVERS.getStringList().contains(serverName);
    }

    private boolean shouldIgnore(String reason, List<String> ignoredReasons) {
        return ConditionUtil.checkReason(ignoredReasons, reason);
    }

    @Generated
    public ReconnectListener(FallbackServerVelocity plugin) {
        this.plugin = plugin;
    }
}

