/*
 * Decompiled with CFR 0.152.
 */
package me.candiesjar.fallbackserver.listeners;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.player.ServerPostConnectEvent;
import com.velocitypowered.api.event.player.ServerPreConnectEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.util.UUID;
import lombok.Generated;
import me.candiesjar.fallbackserver.FallbackServerVelocity;
import me.candiesjar.fallbackserver.enums.VelocityConfig;
import me.candiesjar.fallbackserver.handler.FallbackLimboHandler;
import me.candiesjar.fallbackserver.utils.ReconnectUtil;
import me.candiesjar.fallbackserver.utils.player.ChatUtil;
import net.elytrium.limboapi.api.player.LimboPlayer;

public class ServerSwitchListener {
    private final FallbackServerVelocity plugin;

    @Subscribe
    public void onServerSwitch(ServerPreConnectEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        if (event.getOriginalServer() == null) {
            return;
        }
        RegisteredServer originalServer = event.getOriginalServer();
        boolean isReconnecting = this.plugin.getPlayerCacheManager().containsKey(uuid);
        if (!isReconnecting) {
            if (originalServer.getServerInfo().getName().equals("FallbackLimbo")) {
                event.setResult(ServerPreConnectEvent.ServerResult.denied());
            }
            return;
        }
        FallbackLimboHandler limboHandler = this.plugin.getPlayerCacheManager().get(uuid);
        RegisteredServer reconnectServer = limboHandler.getTarget();
        if (originalServer.getServerInfo().equals((Object)reconnectServer.getServerInfo())) {
            return;
        }
        boolean physical = VelocityConfig.RECONNECT_USE_PHYSICAL.get(Boolean.class);
        if (physical) {
            String physicalServerName = VelocityConfig.RECONNECT_PHYSICAL_SERVER.get(String.class);
            RegisteredServer physicalServer = this.plugin.getServer().getServer(physicalServerName).orElse(null);
            if (physicalServer != null && originalServer.getServerInfo().equals((Object)physicalServer.getServerInfo())) {
                return;
            }
        }
        if (!originalServer.getServerInfo().getName().equals("FallbackLimbo")) {
            event.setResult(ServerPreConnectEvent.ServerResult.denied());
        }
        ReconnectUtil.cancelReconnect(uuid);
        if (!physical) {
            LimboPlayer limboPlayer = limboHandler.getLimboPlayer();
            limboPlayer.disconnect(originalServer);
            return;
        }
        if (!originalServer.getServerInfo().getName().equals("FallbackLimbo")) {
            player.createConnectionRequest(originalServer).fireAndForget();
            return;
        }
        this.requestKick(player);
    }

    @Subscribe
    public void onServerSwitched(ServerPostConnectEvent event) {
        Player player = event.getPlayer();
        boolean clearChat = VelocityConfig.CLEAR_CHAT_SERVER_SWITCH.get(Boolean.class);
        if (clearChat) {
            ChatUtil.clearChat(player);
        }
    }

    private void requestKick(Player player) {
        ByteArrayDataOutput buf = ByteStreams.newDataOutput();
        buf.writeUTF(player.getUniqueId().toString());
        player.getCurrentServer().ifPresent(sv -> sv.sendPluginMessage(this.plugin.getReconnectIdentifier(), buf.toByteArray()));
    }

    @Generated
    public ServerSwitchListener(FallbackServerVelocity plugin) {
        this.plugin = plugin;
    }
}

