/*
 * Decompiled with CFR 0.152.
 */
package me.candiesjar.fallbackserver.managers;

import com.velocitypowered.api.proxy.server.RegisteredServer;
import eu.kennytv.maintenance.api.MaintenanceProvider;
import eu.kennytv.maintenance.api.proxy.MaintenanceProxy;
import eu.kennytv.maintenance.api.proxy.Server;
import java.util.List;
import lombok.Generated;
import me.candiesjar.fallbackserver.FallbackServerVelocity;
import me.candiesjar.fallbackserver.utils.Utils;
import org.simpleyaml.configuration.ConfigurationSection;

public final class ServerManager {
    private static final FallbackServerVelocity fallbackServerVelocity = FallbackServerVelocity.getInstance();
    private static final ConfigurationSection list = fallbackServerVelocity.getConfigTextFile().getConfig().getConfigurationSection("settings.fallback");

    public static String getGroupByServer(String name) {
        for (String s : list.getKeys(false)) {
            List servers = list.getStringList(s + ".servers");
            if (!servers.contains(name)) continue;
            return s;
        }
        return null;
    }

    public static String getGroupByName(String name) {
        for (String s : list.getKeys(false)) {
            if (!s.equalsIgnoreCase(name)) continue;
            return s;
        }
        return null;
    }

    public static boolean checkIfGroupExists(String group) {
        ConfigurationSection section = fallbackServerVelocity.getConfigTextFile().getConfig().getConfigurationSection("settings.fallback");
        ConfigurationSection servers = fallbackServerVelocity.getServersTextFile().getConfig().getConfigurationSection("servers");
        return section.getKeys(false).contains(group) || servers.getKeys(false).contains(group);
    }

    public static boolean checkMaintenance(RegisteredServer registeredServer) {
        if (!fallbackServerVelocity.isMaintenance()) {
            return false;
        }
        MaintenanceProxy api = (MaintenanceProxy)MaintenanceProvider.get();
        if (api == null) {
            Utils.printDebug("Error in maintenance API, please check if is correctly enabled.", true);
            return false;
        }
        Server server = api.getServer(registeredServer.getServerInfo().getName());
        return api.isMaintenance(server);
    }

    @Generated
    private ServerManager() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

