/*
 * Decompiled with CFR 0.152.
 */
package me.candiesjar.fallbackserver.objects.text;

import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.simpleyaml.configuration.file.YamlFile;

public class TextFile {
    private final YamlFile yamlFile;

    public TextFile(Path path, String fileName) {
        Path configPath;
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectory(path, new FileAttribute[0]);
        }
        if (!Files.exists(configPath = path.resolve(fileName), new LinkOption[0])) {
            try (InputStream in = this.getClass().getClassLoader().getResourceAsStream(fileName);){
                Files.copy(Objects.requireNonNull(in), configPath, new CopyOption[0]);
            }
        }
        this.yamlFile = new YamlFile(configPath.toFile());
        this.yamlFile.load();
    }

    public YamlFile getConfig() {
        return this.yamlFile;
    }

    public void save() {
        this.yamlFile.save();
    }

    public void reload() {
        this.yamlFile.load();
    }
}

