/*
 * Decompiled with CFR 0.152.
 */
package me.candiesjar.fallbackserver.utils;

import java.util.List;
import lombok.Generated;
import me.candiesjar.fallbackserver.FallbackServerVelocity;
import me.candiesjar.fallbackserver.cache.OnlineLobbiesManager;
import me.candiesjar.fallbackserver.cache.ServerTypeManager;
import me.candiesjar.fallbackserver.objects.ServerType;
import me.candiesjar.fallbackserver.utils.Utils;
import org.simpleyaml.configuration.ConfigurationSection;

public final class LoaderUtil {
    private static final FallbackServerVelocity fallbackServerBungee = FallbackServerVelocity.getInstance();
    private static final ServerTypeManager serverTypeManager = fallbackServerBungee.getServerTypeManager();
    private static final OnlineLobbiesManager onlineLobbiesManager = fallbackServerBungee.getOnlineLobbiesManager();

    public static void loadServers(ConfigurationSection section) {
        if (section == null) {
            Utils.printDebug("\u00a77[\u00a7c!\u00a77] There is an error in your configuration", true);
            Utils.printDebug("\u00a77[\u00a7c!\u00a77] Please check the 'settings.fallback' section", true);
            return;
        }
        for (String key : section.getKeys(false)) {
            List servers;
            if (key.equalsIgnoreCase("placeholder")) continue;
            if (key.equalsIgnoreCase("default")) {
                servers = section.getStringList(key + ".servers");
                if (servers.isEmpty()) {
                    Utils.printDebug("\u00a77[\u00a7c!\u00a77] There are no default lobbies", true);
                    Utils.printDebug("\u00a77[\u00a7c!\u00a77] Please add your lobbies to the 'default' section", true);
                    break;
                }
                ServerType serverType = new ServerType(key, null, servers, false);
                serverTypeManager.put(key, serverType);
                onlineLobbiesManager.firstLoad(key);
                continue;
            }
            servers = section.getStringList(key + ".servers");
            if (servers.isEmpty()) {
                Utils.printDebug("\u00a77[\u00a7c!\u00a77] There are no servers", true);
                Utils.printDebug("\u00a77[\u00a7c!\u00a77] Please add your servers to the '" + key + "' section", true);
                break;
            }
            List lobbies = section.getStringList(key + ".lobbies");
            String mode = section.getString(key + ".mode");
            boolean reconnect = false;
            switch (mode) {
                case "RECONNECT": {
                    fallbackServerBungee.loadReconnect();
                    if (!fallbackServerBungee.isReconnect()) break;
                    reconnect = true;
                    break;
                }
            }
            ServerType serverType = new ServerType(key, servers, lobbies, reconnect);
            serverTypeManager.put(key, serverType);
            onlineLobbiesManager.firstLoad(key);
        }
    }

    @Generated
    private LoaderUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

