/*
 * Decompiled with CFR 0.152.
 */
package me.candiesjar.fallbackserver.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import me.candiesjar.fallbackserver.FallbackServerVelocity;

public final class Utils {
    private static final FallbackServerVelocity fallbackServerVelocity = FallbackServerVelocity.getInstance();
    private static String remoteVersion = "Loading";

    public static CompletableFuture<Boolean> getUpdates() {
        if (fallbackServerVelocity.isBeta()) {
            return CompletableFuture.supplyAsync(() -> false);
        }
        return CompletableFuture.supplyAsync(() -> {
            boolean isUpdateAvailable;
            try {
                URLConnection connection = new URL("https://api.spigotmc.org/legacy/update.php?resource=86398").openConnection();
                try (InputStreamReader inputStreamReader = new InputStreamReader(connection.getInputStream());
                     BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                    remoteVersion = bufferedReader.readLine();
                    isUpdateAvailable = !fallbackServerVelocity.getVersion().equalsIgnoreCase(remoteVersion);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return isUpdateAvailable;
        });
    }

    public static void printDebug(String s) {
        fallbackServerVelocity.getComponentLogger().info("[INFO] {}", (Object)s);
    }

    public static void printDebug(String s, boolean exception) {
        if (exception) {
            fallbackServerVelocity.getComponentLogger().error("[ERROR] {}", (Object)s);
            return;
        }
        fallbackServerVelocity.getComponentLogger().warn("[DEBUG] {}", (Object)s);
    }

    public static String getDots(int s) {
        return switch (s % 4) {
            case 1 -> ".";
            case 2 -> "..";
            case 3 -> "...";
            default -> "";
        };
    }

    public static void saveServers(List<String> servers) {
        fallbackServerVelocity.getServersTextFile().getConfig().set("servers", servers);
        fallbackServerVelocity.getServersTextFile().save();
        fallbackServerVelocity.getServersTextFile().reload();
    }

    @Generated
    private Utils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @Generated
    public static String getRemoteVersion() {
        return remoteVersion;
    }
}

