/*
 * Decompiled with CFR 0.152.
 */
package me.candiesjar.fallbackserver.utils;

import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.proxy.server.ServerInfo;
import java.io.File;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import lombok.Generated;
import me.candiesjar.fallbackserver.FallbackServerVelocity;
import me.candiesjar.fallbackserver.enums.VelocityConfig;
import me.candiesjar.fallbackserver.utils.Utils;
import net.elytrium.limboapi.api.Limbo;
import net.elytrium.limboapi.api.LimboFactory;
import net.elytrium.limboapi.api.chunk.Dimension;
import net.elytrium.limboapi.api.chunk.VirtualWorld;
import net.elytrium.limboapi.api.file.BuiltInWorldFileType;
import net.elytrium.limboapi.api.file.WorldFile;
import net.elytrium.limboapi.api.player.GameMode;

public final class WorldUtil {
    private static final FallbackServerVelocity fallbackServerVelocity = FallbackServerVelocity.getInstance();
    private static Limbo fallbackLimbo;
    private static final LimboFactory factory;

    public static void createLimbo() {
        int x = VelocityConfig.RECONNECT_LIMBO_X.get(Integer.class);
        int y = VelocityConfig.RECONNECT_LIMBO_Y.get(Integer.class);
        int z = VelocityConfig.RECONNECT_LIMBO_Z.get(Integer.class);
        float yaw = VelocityConfig.RECONNECT_LIMBO_YAW.get(Integer.class).intValue();
        float pitch = VelocityConfig.RECONNECT_LIMBO_PITCH.get(Integer.class).intValue();
        VirtualWorld world = factory.createVirtualWorld(Dimension.valueOf((String)(switch (worldDimension = VelocityConfig.RECONNECT_LIMBO_DIMENSION.get(String.class)) {
            case "OVERWORLD", "NETHER", "THE_END" -> {
            }
            default -> {
                Utils.printDebug("Invalid dimension, defaulting to OVERWORLD", true);
                yield "OVERWORLD";
            }
        })), (double)x, (double)y, (double)z, yaw, pitch);
        boolean useSchematic = VelocityConfig.RECONNECT_USE_SCHEMATIC.get(Boolean.class);
        if (useSchematic) {
            WorldUtil.loadSchematic(world);
        }
        String name = VelocityConfig.RECONNECT_LIMBO_NAME.get(String.class);
        GameMode gameMode = WorldUtil.getGameMode(VelocityConfig.RECONNECT_LIMBO_GAMEMODE.get(String.class));
        int worldTime = VelocityConfig.RECONNECT_LIMBO_WORLD_TIME.get(Integer.class);
        boolean shouldJoin = VelocityConfig.RECONNECT_JOIN_LIMBO.get(Boolean.class);
        boolean isPhysical = VelocityConfig.RECONNECT_USE_PHYSICAL.get(Boolean.class);
        ServerInfo serverInfo = new ServerInfo("FallbackLimbo", InetSocketAddress.createUnresolved("0.0.0.0", 12345));
        fallbackServerVelocity.getServer().registerServer(serverInfo);
        if (useSchematic || isPhysical) {
            fallbackLimbo = factory.createLimbo(world).setName(name).setWorldTime((long)worldTime).setShouldRejoin(false).setGameMode(gameMode).setShouldRespawn(true);
            return;
        }
        if (shouldJoin) {
            fallbackLimbo = factory.createLimbo(world).setName(name).setWorldTime((long)worldTime).setShouldRejoin(true).setGameMode(gameMode).setShouldRespawn(true);
            return;
        }
        fallbackLimbo = factory.createLimbo(world).setName(name).setWorldTime((long)worldTime).setShouldRejoin(false).setGameMode(gameMode).setShouldRespawn(false);
    }

    private static void loadSchematic(VirtualWorld world) {
        String fileExtension;
        File schematic = new File(fallbackServerVelocity.getPath() + "/schematics");
        if (!Files.exists(schematic.toPath(), new LinkOption[0])) {
            Files.createDirectory(schematic.toPath(), new FileAttribute[0]);
        }
        schematic = new File(schematic, VelocityConfig.RECONNECT_SCHEMATIC_NAME.get(String.class));
        fallbackServerVelocity.getComponentLogger().info(fallbackServerVelocity.getMiniMessage().deserialize((Object)("<gray>[<aqua>!<gray>] Loading schematic: " + schematic)));
        Path path = schematic.toPath();
        if (!Files.exists(path, new LinkOption[0])) {
            Utils.printDebug("Schematic not found", true);
            Utils.printDebug("Please add your schematic to the 'schematics' folder", true);
            return;
        }
        String fileName = schematic.getName();
        WorldFile worldFile = switch (fileExtension = fileName.substring(fileName.lastIndexOf(".") + 1).toUpperCase()) {
            case "SCHEMATIC" -> {
                fallbackServerVelocity.getComponentLogger().info(fallbackServerVelocity.getMiniMessage().deserialize((Object)"<gray>[<aqua>!<gray>] Loading schematic as a SCHEMATIC file"));
                yield factory.openWorldFile(BuiltInWorldFileType.SCHEMATIC, path);
            }
            case "SCHEM" -> {
                fallbackServerVelocity.getComponentLogger().info(fallbackServerVelocity.getMiniMessage().deserialize((Object)"<gray>[<aqua>!<gray>] Loading schematic as a WORLDEDIT_SCHEM file"));
                yield factory.openWorldFile(BuiltInWorldFileType.WORLDEDIT_SCHEM, path);
            }
            case "STRUCTURE" -> {
                fallbackServerVelocity.getComponentLogger().info(fallbackServerVelocity.getMiniMessage().deserialize((Object)"<gray>[<aqua>!<gray>] Loading schematic as a STRUCTURE file"));
                yield factory.openWorldFile(BuiltInWorldFileType.STRUCTURE, path);
            }
            default -> {
                Utils.printDebug("Invalid schematic file", true);
                Utils.printDebug("Please add a valid schematic file", true);
                yield null;
            }
        };
        if (worldFile != null) {
            int schematicX = VelocityConfig.RECONNECT_SCHEMATIC_X.get(Integer.class);
            int schematicY = VelocityConfig.RECONNECT_SCHEMATIC_Y.get(Integer.class);
            int schematicZ = VelocityConfig.RECONNECT_SCHEMATIC_Z.get(Integer.class);
            worldFile.toWorld(factory, world, schematicX, schematicY, schematicZ);
            fallbackServerVelocity.getComponentLogger().info(fallbackServerVelocity.getMiniMessage().deserialize((Object)("<gray>[<aqua>!<gray>] Schematic has been pasted at: " + schematicX + " " + schematicY + " " + schematicZ)));
        }
    }

    private static GameMode getGameMode(String mode) {
        return switch (mode) {
            case "CREATIVE" -> GameMode.CREATIVE;
            case "ADVENTURE" -> GameMode.ADVENTURE;
            case "SPECTATOR" -> GameMode.SPECTATOR;
            default -> GameMode.SURVIVAL;
        };
    }

    @Generated
    private WorldUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @Generated
    public static Limbo getFallbackLimbo() {
        return fallbackLimbo;
    }

    @Generated
    public static LimboFactory getFactory() {
        return factory;
    }

    static {
        factory = (LimboFactory)fallbackServerVelocity.getServer().getPluginManager().getPlugin("limboapi").flatMap(PluginContainer::getInstance).orElseThrow();
    }
}

