/*
 * Decompiled with CFR 0.152.
 */
package me.candiesjar.fallbackserver.utils.player;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import me.candiesjar.fallbackserver.FallbackServerVelocity;
import me.candiesjar.fallbackserver.enums.VelocityMessages;
import me.candiesjar.fallbackserver.objects.text.Placeholder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;

public final class ChatUtil {
    private static final Pattern pattern = ChatUtil.getInstance().getPattern();

    private static FallbackServerVelocity getInstance() {
        return FallbackServerVelocity.getInstance();
    }

    public static String getString(VelocityMessages velocityMessages) {
        return ChatUtil.getInstance().getMessagesTextFile().getConfig().getString(velocityMessages.getPath());
    }

    public static String getString(VelocityMessages velocityMessages, Placeholder ... placeholders) {
        return ChatUtil.applyPlaceholders(ChatUtil.getString(velocityMessages), placeholders);
    }

    public static String getFormattedString(VelocityMessages velocityMessages, Placeholder ... placeholders) {
        return ChatUtil.formatColor(ChatUtil.getString(velocityMessages, placeholders));
    }

    public static List<String> getStringList(VelocityMessages velocityMessages) {
        return ChatUtil.getInstance().getMessagesTextFile().getConfig().getStringList(velocityMessages.getPath());
    }

    public static List<String> getStringList(VelocityMessages velocityMessages, Placeholder ... placeholders) {
        return ChatUtil.getStringList(velocityMessages).stream().map(s -> ChatUtil.applyPlaceholders(s, placeholders)).collect(Collectors.toList());
    }

    public static String applyPlaceholders(String message, Placeholder ... placeholders) {
        for (Placeholder placeholder : placeholders) {
            message = message.replace(placeholder.key(), placeholder.value());
        }
        return message;
    }

    public static String formatColor(String message) {
        return ChatUtil.formatHexColor(message.replace("&", "\u00a7"));
    }

    public static List<String> formatColor(List<String> messages) {
        return messages.stream().map(ChatUtil::formatColor).collect(Collectors.toList());
    }

    public static void sendList(CommandSource commandSource, List<String> messages) {
        messages.forEach(message -> commandSource.sendMessage((Component)Component.text((String)message)));
    }

    public static void sendFormattedList(VelocityMessages velocityMessages, CommandSource commandSource, Placeholder ... placeholders) {
        ChatUtil.sendList(commandSource, ChatUtil.formatColor(ChatUtil.getStringList(velocityMessages, placeholders)));
    }

    public static String componentToString(Component component) {
        return PlainTextComponentSerializer.plainText().serialize(component);
    }

    public static String formatHexColor(String message) {
        if (!ChatUtil.containsHexColor(message)) {
            return message;
        }
        Matcher matcher = pattern.matcher(message);
        while (matcher.find()) {
            String hexCode = matcher.group();
            String formattedHex = hexCode.replace('#', 'x').replaceAll("(.)", "&$1");
            message = message.replace(hexCode, formattedHex);
        }
        return message;
    }

    public static boolean containsHexColor(String message) {
        return message.matches(".*#[a-fA-F0-9]{6}.*");
    }

    public static boolean checkMessage(String message, List<String> blockedMessages) {
        List<String> lowerCasedBlockedMessages = blockedMessages.stream().map(String::toLowerCase).toList();
        return lowerCasedBlockedMessages.contains(message.toLowerCase());
    }

    public static void clearChat(Player player) {
        for (int i = 0; i < 100; ++i) {
            player.sendMessage((Component)Component.text((String)""));
        }
    }

    @Generated
    private ChatUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

