/*
 * Decompiled with CFR 0.152.
 */
package me.candiesjar.fallbackserver.utils.tasks;

import com.google.common.collect.Lists;
import com.velocitypowered.api.proxy.server.PingOptions;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.proxy.server.ServerInfo;
import com.velocitypowered.api.proxy.server.ServerPing;
import com.velocitypowered.api.scheduler.ScheduledTask;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import me.candiesjar.fallbackserver.FallbackServerVelocity;
import me.candiesjar.fallbackserver.cache.OnlineLobbiesManager;
import me.candiesjar.fallbackserver.cache.ServerTypeManager;
import me.candiesjar.fallbackserver.enums.VelocityConfig;
import me.candiesjar.fallbackserver.objects.ServerType;
import me.candiesjar.fallbackserver.utils.Utils;

public final class PingTask {
    private static final FallbackServerVelocity fallbackServerVelocity = FallbackServerVelocity.getInstance();
    private static final ServerTypeManager serverTypeManager = fallbackServerVelocity.getServerTypeManager();
    private static final OnlineLobbiesManager onlineLobbiesManager = fallbackServerVelocity.getOnlineLobbiesManager();
    private static final List<RegisteredServer> lobbyServers = Lists.newArrayList();
    private static ScheduledTask scheduledTask;

    public static void start(String mode) {
        lobbyServers.clear();
        for (ServerType serverType : serverTypeManager.getServerTypeMap().values()) {
            PingTask.loadServerList(serverType.getLobbies());
        }
        long timeout = VelocityConfig.PING_TIMEOUT.get(Integer.class).intValue();
        Duration duration = Duration.ofSeconds(timeout);
        PingOptions pingOptions = PingOptions.builder().timeout(duration).build();
        int taskDelay = VelocityConfig.PING_DELAY.get(Integer.class);
        switch (mode) {
            case "DEFAULT": {
                scheduledTask = fallbackServerVelocity.getServer().getScheduler().buildTask((Object)fallbackServerVelocity, () -> PingTask.pingServers(false, pingOptions)).repeat((long)taskDelay, TimeUnit.SECONDS).schedule();
                break;
            }
            case "SOCKET": {
                scheduledTask = fallbackServerVelocity.getServer().getScheduler().buildTask((Object)fallbackServerVelocity, () -> PingTask.pingServers(true, pingOptions)).repeat((long)taskDelay, TimeUnit.SECONDS).schedule();
                break;
            }
            default: {
                fallbackServerVelocity.getLogger().error("[!] Configuration error, using default ping mode.");
                scheduledTask = fallbackServerVelocity.getServer().getScheduler().buildTask((Object)fallbackServerVelocity, () -> PingTask.pingServers(false, pingOptions)).repeat((long)taskDelay, TimeUnit.SECONDS).schedule();
            }
        }
    }

    private static void pingServers(boolean sockets, PingOptions pingOptions) {
        if (!sockets) {
            PingTask.ping(pingOptions);
            return;
        }
        lobbyServers.forEach(PingTask::socketPing);
    }

    private static void ping(PingOptions pingOptions) {
        lobbyServers.forEach(registeredServer -> registeredServer.ping(pingOptions).whenComplete((result, throwable) -> {
            if (result == null || throwable != null) {
                PingTask.updateFallingServer(registeredServer, true);
                return;
            }
            Optional playersOptional = result.getPlayers();
            if (playersOptional.isEmpty()) {
                PingTask.updateFallingServer(registeredServer, true);
                return;
            }
            ServerPing.Players players = (ServerPing.Players)playersOptional.get();
            if (players.getOnline() == players.getMax()) {
                PingTask.updateFallingServer(registeredServer, true);
                return;
            }
            PingTask.updateFallingServer(registeredServer, false);
        }));
    }

    private static void socketPing(RegisteredServer registeredServer) {
        block3: {
            InetSocketAddress socketAddress = registeredServer.getServerInfo().getAddress();
            int port = socketAddress.getPort();
            String address = socketAddress.getAddress().getHostAddress();
            try {
                InetAddress inetAddress = InetAddress.getByName(address);
                Socket socket = new Socket(inetAddress, port);
                if (socket.isConnected()) {
                    PingTask.updateFallingServer(registeredServer, false);
                }
                socket.close();
            }
            catch (IOException exception) {
                PingTask.updateFallingServer(registeredServer, true);
                if (!fallbackServerVelocity.isDebug()) break block3;
                Utils.printDebug("\u00a77[\u00a7c!\u00a77] Error while pinging server: " + registeredServer.getServerInfo().getName(), true);
            }
        }
    }

    private static void updateFallingServer(RegisteredServer registeredServer, boolean remove) {
        String name = registeredServer.getServerInfo().getName();
        for (ServerType serverType : serverTypeManager.getServerTypeMap().values()) {
            if (!serverType.getLobbies().contains(name)) continue;
            String group = serverType.getName();
            boolean containsValue = onlineLobbiesManager.containsValue(group, registeredServer);
            if (remove) {
                if (!containsValue) continue;
                onlineLobbiesManager.remove(group, registeredServer);
                continue;
            }
            if (containsValue) continue;
            onlineLobbiesManager.put(group, registeredServer);
        }
    }

    private static void loadServerList(List<String> serverList) {
        if (serverList == null) {
            return;
        }
        for (String serverName : serverList) {
            ServerInfo serverInfo;
            RegisteredServer server = fallbackServerVelocity.getServer().getServer(serverName).orElse(null);
            if (server == null || (serverInfo = PingTask.getServerInfo(serverName)) == null || lobbyServers.contains(server)) continue;
            lobbyServers.add(server);
        }
    }

    private static ServerInfo getServerInfo(String serverName) {
        return fallbackServerVelocity.getServer().getServer(serverName).map(RegisteredServer::getServerInfo).orElse(null);
    }

    public static void reload() {
        String mode = VelocityConfig.PING_MODE.get(String.class);
        PingTask.start(mode);
    }

    @Generated
    private PingTask() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @Generated
    public static ScheduledTask getScheduledTask() {
        return scheduledTask;
    }
}

