/*
 * Decompiled with CFR 0.152.
 */
package me.candiesjar.fallbackserveraddon;

import com.github.Anon8281.universalScheduler.UniversalScheduler;
import com.tchristofferson.configupdater.ConfigUpdater;
import java.io.File;
import java.util.Collections;
import lombok.Generated;
import me.candiesjar.fallbackserver.libs.com.alessiodp.libby.BukkitLibraryManager;
import me.candiesjar.fallbackserver.libs.com.alessiodp.libby.Library;
import me.candiesjar.fallbackserver.libs.com.alessiodp.libby.relocation.Relocation;
import me.candiesjar.fallbackserveraddon.commands.FallbackAddonCommand;
import me.candiesjar.fallbackserveraddon.listeners.addon.PingListener;
import me.candiesjar.fallbackserveraddon.listeners.standalone.MessageListener;
import me.candiesjar.fallbackserveraddon.listeners.standalone.PlayerListener;
import me.candiesjar.fallbackserveraddon.utils.PacketEventsUtil;
import me.candiesjar.fallbackserveraddon.utils.ScoreboardUtil;
import me.candiesjar.fallbackserveraddon.utils.UpdateUtil;
import me.candiesjar.fallbackserveraddon.utils.Utils;
import me.candiesjar.fallbackserveraddon.utils.tasks.GeneralTask;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public final class FallbackServerAddon
extends JavaPlugin {
    public static FallbackServerAddon instance;
    private boolean placeholderApi = false;
    private boolean pLib = false;
    private boolean pEvents = false;
    private boolean allPluginsLoaded = true;
    private boolean locked = false;

    public void onEnable() {
        instance = this;
        this.getServer().getConsoleSender().sendMessage("\n  ______ _____            _     _             \n |  ____/ ____|  /\\      | |   | |            \n | |__ | (___   /  \\   __| | __| | ___  _ __  \n |  __| \\___ \\ / /\\ \\ / _` |/ _` |/ _ \\| '_ \\ \n | |    ____) / ____ \\ (_| | (_| | (_) | | | |\n |_|   |_____/_/    \\_\\__,_|\\__,_|\\___/|_| |_|\n");
        this.getServer().getConsoleSender().sendMessage("[FallbackServerAddon] \u00a77[\u00a7b!\u00a77] Warming up...");
        this.loadDependencies();
        this.loadConfig();
        this.checkVersion();
        this.schedule();
        this.getServer().getConsoleSender().sendMessage("[FallbackServerAddon] \u00a77[\u00a7a!\u00a77] Loaded successfully.");
    }

    public void onDisable() {
        this.getCommand("fallbackserveraddon").unregister(Utils.getCommandMap(this));
        Utils.unregisterEvent(new PlayerListener(this));
        Utils.unregisterEvent(new PingListener(this));
        this.getServer().getConsoleSender().sendMessage("[FallbackServerAddon] \u00a77[\u00a7c!\u00a77] Un-Loaded.");
    }

    private void loadDependencies() {
        BukkitLibraryManager bukkitLibraryManager = new BukkitLibraryManager((Plugin)this);
        bukkitLibraryManager.addJitPack();
        Relocation scoreboardRelocation = new Relocation("scoreboard", "me{}candiesjar{}libs{}scoreboard");
        Library scoreboard = Library.builder().groupId("fr{}mrmicky").artifactId("FastBoard").version("2.1.3").relocate(scoreboardRelocation).build();
        Relocation schedulerRelocation = new Relocation("scheduler", "me{}candiesjar{}libs{}scheduler");
        Library scheduler = Library.builder().groupId("com{}github{}Anon8281").artifactId("UniversalScheduler").version("0.1.6").relocate(schedulerRelocation).build();
        Relocation updaterRelocation = new Relocation("updater", "me{}candiesjar{}libs{}updater");
        Library configUpdater = Library.builder().groupId("com{}tchristofferson").artifactId("ConfigUpdater").version("2.1-SNAPSHOT").relocate(updaterRelocation).url("https://github.com/frafol/Config-Updater/releases/download/compile/ConfigUpdater-2.1-SNAPSHOT.jar").build();
        bukkitLibraryManager.loadLibrary(scoreboard);
        bukkitLibraryManager.loadLibrary(scheduler);
        bukkitLibraryManager.loadLibrary(configUpdater);
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            this.getServer().getConsoleSender().sendMessage("[FallbackServerAddon] \u00a77[\u00a7b!\u00a77] PlaceholderAPI support enabled.");
            this.placeholderApi = true;
        }
        if (this.getServer().getPluginManager().getPlugin("ProtocolLib") != null) {
            this.pLib = true;
        }
        if (this.getServer().getPluginManager().getPlugin("PacketEvents") != null) {
            this.pEvents = true;
        }
    }

    private void checkVersion() {
        if (this.getDescription().getVersion().contains("Beta")) {
            this.getServer().getConsoleSender().sendMessage("[FallbackServerAddon]  ");
            this.getServer().getConsoleSender().sendMessage("[FallbackServerAddon] \u00a77You're running a \u00a7c\u00a7lBETA VERSION \u00a77of the plugin.");
            this.getServer().getConsoleSender().sendMessage("[FallbackServerAddon] \u00a77If you find any bugs, please report them on discord.");
            this.getServer().getConsoleSender().sendMessage("[FallbackServerAddon]  ");
        }
        UpdateUtil.checkForUpdates();
    }

    private void updateConfig(File versionFile, YamlConfiguration version) {
        File configFile = new File(this.getDataFolder(), "config.yml");
        if (this.getDescription().getVersion().equals(version.getString("version"))) {
            return;
        }
        this.getServer().getConsoleSender().sendMessage("[FallbackServerAddon] \u00a77[\u00a7b!\u00a77] Creating new configurations...");
        ConfigUpdater.update((Plugin)this, (String)"config.yml", (File)configFile, Collections.emptyList());
        version.set("version", (Object)this.getDescription().getVersion());
        version.save(versionFile);
        this.saveDefaultConfig();
    }

    private void schedule() {
        GeneralTask.schedule(this, UniversalScheduler.getScheduler((Plugin)this));
    }

    public void loadConfig() {
        File versionFile = new File(this.getDataFolder(), "version.yml");
        YamlConfiguration version = YamlConfiguration.loadConfiguration((File)versionFile);
        this.saveDefaultConfig();
        this.updateConfig(versionFile, version);
    }

    public void executeStart() {
        if (!this.getConfig().getBoolean("settings.protocollib_support", true)) {
            this.pLib = false;
        }
        if (!this.getConfig().getBoolean("settings.packetevents_support", true)) {
            this.pEvents = false;
        }
        this.getCommand("fallbackserveraddon").setExecutor((CommandExecutor)new FallbackAddonCommand(this));
        this.getCommand("fallbackserveraddon").setTabCompleter((TabCompleter)new FallbackAddonCommand(this));
        String mode = this.getConfig().getString("settings.mode", "NONE");
        UpdateUtil.sendUpdateMessage();
        switch (mode) {
            case "STANDALONE": {
                ScoreboardUtil.taskBoards();
                this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)this);
                this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, "fs:reconnect", (PluginMessageListener)new MessageListener(this));
                this.getServer().getConsoleSender().sendMessage("[FallbackServerAddon] \u00a77[\u00a7b!\u00a77] Detected standalone mode, start completed.");
                break;
            }
            case "ADDON": {
                this.registerPing();
                this.getServer().getConsoleSender().sendMessage("[FallbackServerAddon] \u00a77[\u00a7b!\u00a77] Detected addon mode, start completed.");
                break;
            }
            default: {
                this.sendSetup();
            }
        }
    }

    public void executeReload(String oldValue) {
        String mode = this.getConfig().getString("settings.mode", "NONE");
        UpdateUtil.sendUpdateMessage();
        switch (mode) {
            case "STANDALONE": {
                if (oldValue.equalsIgnoreCase("ADDON")) {
                    Utils.unregisterEvent(new PingListener(this));
                    PacketEventsUtil.terminate();
                }
                if (oldValue.equalsIgnoreCase("STANDALONE")) {
                    return;
                }
                ScoreboardUtil.reloadBoards();
                this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)this);
                this.getServer().getConsoleSender().sendMessage("[FallbackServerAddon] \u00a77[\u00a7b!\u00a77] Detected standalone mode, start completed.");
                break;
            }
            case "ADDON": {
                if (oldValue.equalsIgnoreCase("STANDALONE")) {
                    Utils.unregisterEvent(new PlayerListener(this));
                }
                if (oldValue.equalsIgnoreCase("ADDON")) {
                    return;
                }
                this.registerPing();
                this.getServer().getConsoleSender().sendMessage("[FallbackServerAddon] \u00a77[\u00a7b!\u00a77] Detected addon mode, start completed.");
                break;
            }
            default: {
                if (oldValue.equalsIgnoreCase("STANDALONE")) {
                    Utils.unregisterEvent(new PlayerListener(this));
                }
                if (oldValue.equalsIgnoreCase("ADDON")) {
                    Utils.unregisterEvent(new PingListener(this));
                }
                this.sendSetup();
            }
        }
    }

    private void sendSetup() {
        this.getServer().getConsoleSender().sendMessage("[FallbackServerAddon] \u00a77[\u00a7c!\u00a77] Detected an invalid mode...");
        this.getServer().getConsoleSender().sendMessage("[FallbackServerAddon]");
        this.getServer().getConsoleSender().sendMessage("[FallbackServerAddon] \u00a77[\u00a7c!\u00a77] \u00a7c\u00a7lFIRST SETUP GUIDE");
        this.getServer().getConsoleSender().sendMessage("[FallbackServerAddon] \u00a77[\u00a7e!\u00a77] \u00a7eSelect the mode of your server!");
        this.getServer().getConsoleSender().sendMessage("[FallbackServerAddon] \u00a77[\u00a7e!\u00a77] \u00a7eYou can choose between \u00a7bSTANDALONE \u00a7eor \u00a7bADDON\u00a7e.");
        this.getServer().getConsoleSender().sendMessage("[FallbackServerAddon] \u00a77[\u00a7e!\u00a77] \u00a7eYou can change the mode in the config.yml file.");
        this.getServer().getConsoleSender().sendMessage("[FallbackServerAddon] \u00a77[\u00a7e!\u00a77] \u00a7eAfter you have selected the mode, restart the server.");
        this.getServer().getConsoleSender().sendMessage("[FallbackServerAddon] \u00a77[\u00a7e!\u00a77] \u00a7eCheck the config.yml for more information about this.");
        this.getServer().getConsoleSender().sendMessage("[FallbackServerAddon]");
        this.getServer().getConsoleSender().sendMessage("[FallbackServerAddon] \u00a77[\u00a7c!\u00a77] \u00a7cThe plugin is now in passive mode:");
        this.getServer().getConsoleSender().sendMessage("[FallbackServerAddon] \u00a77[\u00a7c!\u00a77] \u00a7cUse \u00a7b/fsa reload \u00a7cwhen you finished the setup.");
        this.getServer().getConsoleSender().sendMessage("[FallbackServerAddon]");
    }

    private void registerPing() {
        if (this.pEvents) {
            PacketEventsUtil.registerHandler();
            return;
        }
        this.getServer().getPluginManager().registerEvents((Listener)new PingListener(this), (Plugin)this);
    }

    @Generated
    public void setPlaceholderApi(boolean placeholderApi) {
        this.placeholderApi = placeholderApi;
    }

    @Generated
    public void setPLib(boolean pLib) {
        this.pLib = pLib;
    }

    @Generated
    public void setPEvents(boolean pEvents) {
        this.pEvents = pEvents;
    }

    @Generated
    public void setAllPluginsLoaded(boolean allPluginsLoaded) {
        this.allPluginsLoaded = allPluginsLoaded;
    }

    @Generated
    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    @Generated
    public static FallbackServerAddon getInstance() {
        return instance;
    }

    @Generated
    public boolean isPlaceholderApi() {
        return this.placeholderApi;
    }

    @Generated
    public boolean isPLib() {
        return this.pLib;
    }

    @Generated
    public boolean isPEvents() {
        return this.pEvents;
    }

    @Generated
    public boolean isAllPluginsLoaded() {
        return this.allPluginsLoaded;
    }

    @Generated
    public boolean isLocked() {
        return this.locked;
    }
}

