/*
 * Decompiled with CFR 0.152.
 */
package me.candiesjar.fallbackserveraddon.listeners.addon;

import com.github.Anon8281.universalScheduler.UniversalScheduler;
import com.github.Anon8281.universalScheduler.scheduling.schedulers.TaskScheduler;
import me.candiesjar.fallbackserveraddon.FallbackServerAddon;
import me.candiesjar.fallbackserveraddon.utils.Utils;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.plugin.Plugin;

public class PingListener
implements Listener {
    private final FallbackServerAddon plugin;
    private final TaskScheduler scheduler;
    private boolean received = false;
    private boolean finished = false;

    public PingListener(FallbackServerAddon plugin) {
        this.plugin = plugin;
        this.scheduler = UniversalScheduler.getScheduler((Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPing(ServerListPingEvent event) {
        if (this.finished) {
            return;
        }
        if (!this.plugin.isLocked()) {
            return;
        }
        event.setMaxPlayers(this.plugin.getConfig().getInt("settings.addon.override_player_count_number", -1));
        if (this.received) {
            return;
        }
        this.received = true;
        if (this.plugin.getConfig().getBoolean("settings.addon.auto_remove", false)) {
            this.scheduler.runTaskLater(() -> this.plugin.getServer().getPluginManager().disablePlugin((Plugin)this.plugin), (long)this.plugin.getConfig().getInt("settings.disable_after", 30) * 20L);
            return;
        }
        this.scheduler.runTaskLater(() -> {
            this.finished = true;
            Utils.unregisterEvent(this);
        }, (long)this.plugin.getConfig().getInt("settings.addon.disable_after", 30) * 20L);
    }
}

