/*
 * Decompiled with CFR 0.152.
 */
package me.candiesjar.fallbackserveraddon.listeners.addon.packetevents;

import com.github.Anon8281.universalScheduler.UniversalScheduler;
import com.github.Anon8281.universalScheduler.scheduling.schedulers.TaskScheduler;
import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListenerAbstract;
import com.github.retrooper.packetevents.event.PacketListenerCommon;
import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.wrapper.status.server.WrapperStatusServerResponse;
import com.google.gson.JsonObject;
import me.candiesjar.fallbackserveraddon.FallbackServerAddon;
import me.candiesjar.fallbackserveraddon.utils.Utils;
import org.bukkit.plugin.Plugin;

public class PacketHandler
extends PacketListenerAbstract {
    private final FallbackServerAddon plugin = FallbackServerAddon.getInstance();
    private final TaskScheduler scheduler = UniversalScheduler.getScheduler((Plugin)this.plugin);
    private boolean received = false;
    private boolean finished = false;

    public void onPacketSend(PacketSendEvent event) {
        if (event.getPacketType() != PacketType.Status.Server.RESPONSE) {
            return;
        }
        WrapperStatusServerResponse response = new WrapperStatusServerResponse(event);
        if (this.finished) {
            return;
        }
        if (!this.plugin.isLocked()) {
            return;
        }
        JsonObject serverInfo = response.getComponent();
        JsonObject players = serverInfo.getAsJsonObject("players");
        players.addProperty("max", (Number)this.plugin.getConfig().getInt("settings.addon.override_player_count_number", -1));
        players.addProperty("online", (Number)players.get("online").getAsInt());
        response.setComponent(serverInfo);
        if (this.received) {
            return;
        }
        this.received = true;
        if (this.plugin.getConfig().getBoolean("settings.addon.auto_remove", false)) {
            this.scheduler.runTaskLater(() -> this.plugin.getServer().getPluginManager().disablePlugin((Plugin)this.plugin), (long)this.plugin.getConfig().getInt("settings.disable_after", 30) * 20L);
            return;
        }
        this.scheduler.runTaskLater(() -> {
            this.finished = true;
            Utils.unregisterEvent(PacketEvents.getAPI(), (PacketListenerCommon)this);
        }, (long)this.plugin.getConfig().getInt("settings.addon.disable_after", 30) * 20L);
    }
}

