/*
 * Decompiled with CFR 0.152.
 */
package me.candiesjar.fallbackserveraddon.listeners.standalone;

import me.candiesjar.fallbackserver.libs.paperlib.PaperLib;
import me.candiesjar.fallbackserveraddon.FallbackServerAddon;
import me.candiesjar.fallbackserveraddon.utils.ScoreboardUtil;
import me.candiesjar.fallbackserveraddon.utils.player.ActionBarUtil;
import me.candiesjar.fallbackserveraddon.utils.player.BossBarUtil;
import me.candiesjar.fallbackserveraddon.utils.player.ChatUtil;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.weather.WeatherChangeEvent;

public class PlayerListener
implements Listener {
    private final FallbackServerAddon plugin;

    public PlayerListener(FallbackServerAddon plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.getConfig().getBoolean("settings.standalone.teleport_worldspawn", true)) {
            this.teleport(player, player.getWorld().getSpawnLocation());
        }
        if (!this.plugin.getConfig().getString("settings.standalone.join_gamemode", "NONE").equals("NONE")) {
            switch (this.plugin.getConfig().getString("settings.standalone.join_gamemode", "NONE")) {
                case "SURVIVAL": {
                    player.setGameMode(GameMode.SURVIVAL);
                    break;
                }
                case "CREATIVE": {
                    player.setGameMode(GameMode.CREATIVE);
                    break;
                }
                case "ADVENTURE": {
                    player.setGameMode(GameMode.ADVENTURE);
                    break;
                }
                case "SPECTATOR": {
                    player.setGameMode(GameMode.SPECTATOR);
                    break;
                }
            }
        }
        if (this.plugin.getConfig().getBoolean("settings.standalone.actionbar.enabled", false)) {
            ActionBarUtil.startActionBar(player, this.plugin.getConfig().getString("settings.standalone.actionbar.message"));
        }
        if (this.plugin.getConfig().getBoolean("settings.standalone.bossbar.enabled", false)) {
            BossBarUtil.sendBossBar(player, ChatUtil.color(player, this.plugin.getConfig().getString("settings.standalone.bossbar.message")), this.plugin.getConfig().getString("settings.standalone.bossbar.color"), this.plugin.getConfig().getString("settings.standalone.bossbar.style"), this.plugin.getConfig().getDouble("settings.standalone.bossbar.progress"));
        }
        if (this.plugin.getConfig().getBoolean("settings.standalone.scoreboard.enabled", false)) {
            ScoreboardUtil.createScoreboard(player);
        }
        if (!this.plugin.getConfig().getString("settings.standalone.join_sound").equals("NONE")) {
            Sound sound = Sound.valueOf((String)this.plugin.getConfig().getString("settings.standalone.join_sound"));
            player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
        }
        if (this.plugin.getConfig().getString("settings.standalone.join_message").equals("none")) {
            event.setJoinMessage(null);
            return;
        }
        event.setJoinMessage(ChatUtil.color(player, this.plugin.getConfig().getString("settings.standalone.join_message", null)).replace("%player_name%", player.getName()));
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        BossBarUtil.removeBossBar(player);
        ActionBarUtil.stopActionBar(player);
        ScoreboardUtil.deleteScoreboard(player);
        if (this.plugin.getConfig().getString("settings.standalone.quit_message").equals("none")) {
            event.setQuitMessage(null);
            return;
        }
        event.setQuitMessage(ChatUtil.color(player, this.plugin.getConfig().getString("settings.standalone.quit_message", null)).replace("%player_name%", player.getName()));
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        if (this.plugin.getConfig().getBoolean("settings.standalone.event_blocker.interact", true)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityInteract(PlayerInteractEntityEvent event) {
        if (this.plugin.getConfig().getBoolean("settings.standalone.event_blocker.pvp", true)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent event) {
        if (this.plugin.getConfig().getBoolean("settings.standalone.event_blocker.item_drop", true)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPickup(PlayerPickupItemEvent event) {
        if (this.plugin.getConfig().getBoolean("settings.standalone.event_blocker.item_pickup", true)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) {
        if (this.plugin.getConfig().getBoolean("settings.standalone.event_blocker.chat", false)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onCommand(PlayerCommandPreprocessEvent event) {
        if (this.plugin.getConfig().getBoolean("settings.standalone.event_blocker.command", false)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onMove(PlayerMoveEvent event) {
        if (this.plugin.getConfig().getBoolean("settings.standalone.event_blocker.move", false)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onDamage(EntityDamageEvent event) {
        if (this.plugin.getConfig().getBoolean("settings.standalone.event_blocker.damage", true)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onBreak(BlockBreakEvent event) {
        if (this.plugin.getConfig().getBoolean("settings.standalone.event_blocker.block_break", true)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlace(BlockPlaceEvent event) {
        if (this.plugin.getConfig().getBoolean("settings.standalone.event_blocker.block_place", true)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onWeather(WeatherChangeEvent event) {
        if (this.plugin.getConfig().getBoolean("settings.standalone.event_blocker.weather_cycle", true)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onHunger(FoodLevelChangeEvent event) {
        if (this.plugin.getConfig().getBoolean("settings.standalone.event_blocker.hunger", true)) {
            event.setFoodLevel(20);
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onSpawn(CreatureSpawnEvent event) {
        if (this.plugin.getConfig().getBoolean("settings.standalone.event_blocker.entity_spawn", true)) {
            event.setCancelled(true);
        }
    }

    private void teleport(Player player, Location location) {
        if (PaperLib.isPaper() && PaperLib.getMinecraftVersion() >= 575) {
            PaperLib.teleportAsync((Entity)player, location);
            return;
        }
        player.teleport(player.getWorld().getSpawnLocation());
    }
}

