/*
 * Decompiled with CFR 0.152.
 */
package me.candiesjar.fallbackserveraddon.utils;

import com.github.Anon8281.universalScheduler.UniversalScheduler;
import com.github.Anon8281.universalScheduler.scheduling.tasks.MyScheduledTask;
import com.google.common.collect.Maps;
import fr.mrmicky.fastboard.FastBoard;
import fr.mrmicky.fastboard.FastBoardBase;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import me.candiesjar.fallbackserveraddon.FallbackServerAddon;
import me.candiesjar.fallbackserveraddon.utils.player.ChatUtil;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public final class ScoreboardUtil {
    private static final Map<UUID, FastBoard> scoreboards = Maps.newConcurrentMap();
    private static final FallbackServerAddon instance = FallbackServerAddon.getInstance();
    private static MyScheduledTask taskBoard;

    public static void createScoreboard(Player player) {
        UniversalScheduler.getScheduler((Plugin)instance).runTaskLater(() -> {
            FastBoard board = new FastBoard(player){

                public boolean hasLinesMaxLength() {
                    return true;
                }
            };
            scoreboards.put(player.getUniqueId(), board);
        }, 20L);
    }

    public static void deleteScoreboard(Player player) {
        Optional.ofNullable(scoreboards.remove(player.getUniqueId())).ifPresent(FastBoardBase::delete);
    }

    public static void taskBoards() {
        taskBoard = UniversalScheduler.getScheduler((Plugin)instance).runTaskTimer(ScoreboardUtil::updateScoreboards, 20L, (long)instance.getConfig().getInt("settings.standalone.scoreboard.update_interval"));
    }

    public static void reloadBoards() {
        if (taskBoard != null) {
            taskBoard.cancel();
        }
        ScoreboardUtil.taskBoards();
    }

    private static void updateScoreboards() {
        instance.getServer().getOnlinePlayers().forEach(player -> {
            FastBoard board = scoreboards.get(player.getUniqueId());
            if (board == null) {
                return;
            }
            ScoreboardUtil.updateBoard(player, board);
        });
    }

    private static void updateBoard(Player player, FastBoard board) {
        String title = ChatUtil.color(player, instance.getConfig().getString("settings.standalone.scoreboard.title"));
        List<String> lines = ScoreboardUtil.parsePlaceholders(player, instance.getConfig().getStringList("settings.standalone.scoreboard.lines"));
        board.updateTitle(title);
        board.updateLines(lines);
    }

    private static List<String> parsePlaceholders(Player player, List<String> list) {
        return list.stream().map(s -> ChatUtil.color(player, s)).collect(Collectors.toList());
    }

    @Generated
    private ScoreboardUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

