/*
 * Decompiled with CFR 0.152.
 */
package me.candiesjar.fallbackserveraddon.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import me.candiesjar.fallbackserveraddon.FallbackServerAddon;

public final class UpdateUtil {
    private static final FallbackServerAddon plugin = FallbackServerAddon.getInstance();
    private static String remoteVersion = "Loading";
    private static boolean updateAvailable = false;

    public static void checkForUpdates() {
        CompletableFuture.runAsync(() -> {
            try {
                URL url = new URL("https://api.spigotmc.org/legacy/update.php?resource=86398");
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                int responseCode = connection.getResponseCode();
                if (responseCode != 200) {
                    plugin.getLogger().severe("Cannot fetch updates. HTTP response code: " + responseCode);
                    return;
                }
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                    remoteVersion = reader.readLine();
                }
                updateAvailable = !plugin.getDescription().getVersion().equals(remoteVersion);
            }
            catch (IOException e) {
                plugin.getLogger().severe("Cannot fetch for updates.");
            }
        });
    }

    public static void sendUpdateMessage() {
        if (updateAvailable) {
            plugin.getServer().getConsoleSender().sendMessage("[FallbackServerAddon] \u00a77[\u00a7e!\u00a77] \u00a77An update is available for FallbackServerAddon.");
        }
    }

    @Generated
    private UpdateUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @Generated
    public static String getRemoteVersion() {
        return remoteVersion;
    }

    @Generated
    public static boolean isUpdateAvailable() {
        return updateAvailable;
    }
}

