/*
 * Decompiled with CFR 0.152.
 */
package me.candiesjar.fallbackserveraddon.utils.nms;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import java.lang.reflect.Method;
import lombok.Generated;
import me.candiesjar.fallbackserveraddon.FallbackServerAddon;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;

public final class ActionBarCreator {
    private static String nmsVersion;
    private static boolean useOldMethods;

    public static void sendActionBar(Player player, String message, FallbackServerAddon instance) {
        if (!player.isOnline()) {
            return;
        }
        nmsVersion = instance.getServer().getClass().getPackage().getName();
        if ((nmsVersion = nmsVersion.substring(nmsVersion.lastIndexOf(".") + 1)).startsWith("v1_7_")) {
            return;
        }
        if (instance.isPLib()) {
            ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
            PacketContainer packet = protocolManager.createPacket(PacketType.Play.Server.SET_ACTION_BAR_TEXT);
            packet.getChatComponents().write(0, (Object)WrappedChatComponent.fromText((String)message));
            protocolManager.sendServerPacket(player, packet);
            return;
        }
        if (nmsVersion.equalsIgnoreCase("craftbukkit")) {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacy((String)message));
            return;
        }
        if (nmsVersion.equalsIgnoreCase("v1_8_R1")) {
            useOldMethods = true;
        }
        Object packet = ActionBarCreator.createActionBarPacket(message);
        ActionBarCreator.sendPacket(player, packet);
    }

    private static Object createActionBarPacket(String message) throws Exception {
        Class<?> packetPlayOutChatClass = ActionBarCreator.getNMSClass("PacketPlayOutChat");
        Object packet = useOldMethods ? ActionBarCreator.createOldActionBarPacket(message, packetPlayOutChatClass) : ActionBarCreator.createNewActionBarPacket(message, packetPlayOutChatClass);
        return packet;
    }

    private static Object createOldActionBarPacket(String message, Class<?> packetPlayOutChatClass) throws Exception {
        Class<?> chatSerializerClass = ActionBarCreator.getNMSClass("ChatSerializer");
        Class<?> iChatBaseComponentClass = ActionBarCreator.getNMSClass("IChatBaseComponent");
        Method chatSerializerMethod = chatSerializerClass.getDeclaredMethod("a", String.class);
        Object cbc = iChatBaseComponentClass.cast(chatSerializerMethod.invoke(chatSerializerClass, "{\"text\": \"" + message + "\"}"));
        return packetPlayOutChatClass.getConstructor(iChatBaseComponentClass, Byte.TYPE).newInstance(cbc, (byte)2);
    }

    private static Object createNewActionBarPacket(String message, Class<?> packetPlayOutChatClass) throws Exception {
        Class<?> chatComponentTextClass = ActionBarCreator.getNMSClass("ChatComponentText");
        Class<?> iChatBaseComponentClass = ActionBarCreator.getNMSClass("IChatBaseComponent");
        try {
            Class<?> chatMessageTypeClass = ActionBarCreator.getNMSClass("ChatMessageType");
            Object chatMessageType = ActionBarCreator.getChatMessageType(chatMessageTypeClass);
            Object chatCompontentText = chatComponentTextClass.getConstructor(String.class).newInstance(message);
            return packetPlayOutChatClass.getConstructor(iChatBaseComponentClass, chatMessageTypeClass).newInstance(chatCompontentText, chatMessageType);
        }
        catch (ClassNotFoundException exception) {
            Object chatCompontentText = chatComponentTextClass.getConstructor(String.class).newInstance(message);
            return packetPlayOutChatClass.getConstructor(iChatBaseComponentClass, Byte.TYPE).newInstance(chatCompontentText, (byte)2);
        }
    }

    private static Object getChatMessageType(Class<?> chatMessageTypeClass) {
        ?[] chatMessageTypes = chatMessageTypeClass.getEnumConstants();
        Object chatMessageType = null;
        for (Object obj : chatMessageTypes) {
            if (!obj.toString().equals("GAME_INFO")) continue;
            chatMessageType = obj;
        }
        return chatMessageType;
    }

    private static Object getCraftPlayerHandle(Object craftPlayer) throws Exception {
        Method craftPlayerHandleMethod = craftPlayer.getClass().getDeclaredMethod("getHandle", new Class[0]);
        return craftPlayerHandleMethod.invoke(craftPlayer, new Object[0]);
    }

    private static Class<?> getCraftPlayerClass() throws ClassNotFoundException {
        return Class.forName("org.bukkit.craftbukkit." + nmsVersion + ".entity.CraftPlayer");
    }

    private static Class<?> getNMSClass(String className) throws ClassNotFoundException {
        return Class.forName("net.minecraft.server." + nmsVersion + "." + className);
    }

    private static void sendPacket(Player player, Object packet) throws Exception {
        Class<?> craftPlayerClass = ActionBarCreator.getCraftPlayerClass();
        Object craftPlayer = craftPlayerClass.cast(player);
        Object craftPlayerHandle = ActionBarCreator.getCraftPlayerHandle(craftPlayer);
        Object playerConnection = craftPlayerHandle.getClass().getDeclaredField("playerConnection").get(craftPlayerHandle);
        Method sendPacketMethod = playerConnection.getClass().getDeclaredMethod("sendPacket", ActionBarCreator.getNMSClass("Packet"));
        sendPacketMethod.invoke(playerConnection, packet);
    }

    @Generated
    private ActionBarCreator() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        useOldMethods = false;
    }
}

