/*
 * Decompiled with CFR 0.152.
 */
package me.candiesjar.fallbackserveraddon.utils.player;

import com.github.Anon8281.universalScheduler.UniversalScheduler;
import com.github.Anon8281.universalScheduler.scheduling.schedulers.TaskScheduler;
import lombok.Generated;
import me.candiesjar.fallbackserveraddon.FallbackServerAddon;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public final class BossBarUtil {
    private static final FallbackServerAddon plugin = FallbackServerAddon.getInstance();
    private static final TaskScheduler scheduler = UniversalScheduler.getScheduler((Plugin)plugin);

    public static void sendBossBar(Player player, String message, String barColor, String barStyle, double progress) {
        if (BossBarUtil.validVersion()) {
            BossBar bossBar = plugin.getServer().createBossBar(message, BossBarUtil.parseBarColor(barColor), BossBarUtil.parseBarStyle(barStyle), new BarFlag[0]);
            bossBar.setProgress(progress);
            bossBar.addPlayer(player);
            scheduler.runTaskTimer(() -> BossBarUtil.updateBossBar(player, message), 20L, 20L);
        }
    }

    public static void removeBossBar(Player player) {
        if (BossBarUtil.validVersion() && plugin.getConfig().getBoolean("settings.standalone.bossbar.enabled", false)) {
            plugin.getServer().getBossBars().forEachRemaining(bar -> {
                if (bar.getPlayers().contains(player)) {
                    bar.removePlayer(player);
                }
            });
        }
    }

    private static void updateBossBar(Player player, String message) {
        if (BossBarUtil.validVersion()) {
            plugin.getServer().getBossBars().forEachRemaining(bar -> {
                if (bar.getPlayers().contains(player)) {
                    bar.setTitle(message);
                }
            });
        }
    }

    private static BarColor parseBarColor(String barColor) {
        switch (barColor) {
            case "BLUE": {
                return BarColor.BLUE;
            }
            case "GREEN": {
                return BarColor.GREEN;
            }
            case "PINK": {
                return BarColor.PINK;
            }
            case "PURPLE": {
                return BarColor.PURPLE;
            }
            case "RED": {
                return BarColor.RED;
            }
            case "YELLOW": {
                return BarColor.YELLOW;
            }
        }
        return BarColor.WHITE;
    }

    private static BarStyle parseBarStyle(String barStyle) {
        switch (barStyle) {
            case "SEGMENTED_6": {
                return BarStyle.SEGMENTED_6;
            }
            case "SEGMENTED_10": {
                return BarStyle.SEGMENTED_10;
            }
            case "SEGMENTED_12": {
                return BarStyle.SEGMENTED_12;
            }
            case "SEGMENTED_20": {
                return BarStyle.SEGMENTED_20;
            }
        }
        return BarStyle.SOLID;
    }

    private static boolean validVersion() {
        String nmsVersion = plugin.getServer().getClass().getPackage().getName();
        return !(nmsVersion = nmsVersion.substring(nmsVersion.lastIndexOf(".") + 1)).startsWith("v1_8_") && !nmsVersion.startsWith("v1_7_");
    }

    @Generated
    private BossBarUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

