/*
 * Decompiled with CFR 0.152.
 */
package me.candiesjar.fallbackserveraddon.utils.player;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import me.candiesjar.fallbackserveraddon.FallbackServerAddon;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public final class ChatUtil {
    private static final FallbackServerAddon instance = FallbackServerAddon.getInstance();

    public static String color(String message) {
        return ChatUtil.convertHexColors(message).replace("&", "\u00a7");
    }

    public static String color(Player player, String message) {
        return ChatUtil.convertHexColors(ChatUtil.applyPlaceholder((OfflinePlayer)player, message)).replace("&", "\u00a7");
    }

    private static String convertHexColors(String message) {
        if (!ChatUtil.containsHexColor(message)) {
            return message;
        }
        Pattern hexPattern = Pattern.compile("(#[A-Fa-f0-9]{6}|<#[A-Fa-f0-9]{6}>|&#[A-Fa-f0-9]{6})");
        Matcher matcher = hexPattern.matcher(message);
        StringBuilder buffer = new StringBuilder();
        while (matcher.find()) {
            String hexCode = matcher.group();
            String colorCode = hexCode.substring(1, 7);
            if (hexCode.startsWith("<#") && hexCode.endsWith(">")) {
                colorCode = hexCode.substring(2, 8);
            } else if (hexCode.startsWith("&#")) {
                colorCode = hexCode.substring(2, 8);
            }
            String minecraftColorCode = ChatUtil.convertHexToColorCode(colorCode);
            matcher.appendReplacement(buffer, minecraftColorCode);
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private static String convertHexToColorCode(String hexCode) {
        char[] ch = hexCode.toCharArray();
        StringBuilder builder = new StringBuilder();
        for (char c : ch) {
            builder.append("&").append(c);
        }
        return builder.toString();
    }

    private static boolean containsHexColor(String message) {
        String hexColorPattern = "(?i)&#[a-f0-9]{6}";
        return message.matches(".*" + hexColorPattern + ".*");
    }

    private static String applyPlaceholder(OfflinePlayer player, String text) {
        if (!instance.isPlaceholderApi()) {
            return text;
        }
        return PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)text);
    }

    @Generated
    private ChatUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

