/*
 * Decompiled with CFR 0.152.
 */
package com.example.loginsystem;

import com.example.loginsystem.LoginSystem;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;

public class AdminGUIMenu
extends AbstractContainerMenu {
    private final Container container;
    private final LoginSystem loginSystem;

    public AdminGUIMenu(int id, Inventory playerInventory, Container container, LoginSystem loginSystem) {
        super(container.m_6643_() == 27 ? MenuType.f_39959_ : MenuType.f_39962_, id);
        int col;
        this.container = container;
        this.loginSystem = loginSystem;
        int containerRows = container.m_6643_() / 9;
        for (int row = 0; row < containerRows; ++row) {
            for (col = 0; col < 9; ++col) {
                this.m_38897_(new Slot(container, col + row * 9, 8 + col * 18, 18 + row * 18){

                    public boolean m_5857_(@Nonnull ItemStack stack) {
                        return false;
                    }

                    public boolean m_8010_(@Nonnull Player player) {
                        return false;
                    }
                });
            }
        }
        int yOffset = containerRows * 18 + 18 + 14;
        for (int row = 0; row < 3; ++row) {
            for (int col2 = 0; col2 < 9; ++col2) {
                this.m_38897_(new Slot((Container)playerInventory, col2 + row * 9 + 9, 8 + col2 * 18, yOffset + row * 18));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, 8 + col * 18, yOffset + 58));
        }
    }

    public void m_150399_(int slotId, int button, @Nonnull ClickType clickType, @Nonnull Player player) {
        UUID targetUUID;
        String password;
        if (slotId < 0 || slotId >= this.container.m_6643_()) {
            return;
        }
        ItemStack clickedItem = this.container.m_8020_(slotId);
        if (clickedItem.m_41619_() || !(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        CompoundTag tag = clickedItem.m_41783_();
        if (tag == null) {
            return;
        }
        String action = tag.m_128461_("GUIAction");
        if ("ViewPlayers".equals(action)) {
            serverPlayer.m_6915_();
            this.loginSystem.openPlayersListGUI(serverPlayer);
            return;
        }
        if ("DeletePlayers".equals(action)) {
            serverPlayer.m_6915_();
            this.loginSystem.openDeletePlayersGUI(serverPlayer);
            return;
        }
        if ("DeleteThisPlayer".equals(action) && tag.m_128441_("PlayerUUID")) {
            UUID targetUUID2 = UUID.fromString(tag.m_128461_("PlayerUUID"));
            this.deletePlayer(serverPlayer, targetUUID2);
            serverPlayer.m_6915_();
            this.loginSystem.openDeletePlayersGUI(serverPlayer);
            return;
        }
        if (clickedItem.m_41720_() == Items.f_42680_ && tag.m_128441_("PlayerUUID") && (password = this.loginSystem.getPasswordForPlayer(targetUUID = UUID.fromString(tag.m_128461_("PlayerUUID")))) != null) {
            serverPlayer.m_213846_((Component)Component.m_237113_((String)("\u00a76Password: \u00a7a" + password)).m_130940_(ChatFormatting.GOLD));
        }
    }

    private void deletePlayer(ServerPlayer admin, UUID targetUUID) {
        block19: {
            try {
                String playerName = this.loginSystem.getPlayerName(admin.m_20194_(), targetUUID);
                if (this.loginSystem.isEnableDatabase()) {
                    try (Connection conn = DriverManager.getConnection(this.loginSystem.getJdbcUrl());){
                        String sql = "DELETE FROM player_passwords WHERE uuid = ?";
                        try (PreparedStatement pstmt = conn.prepareStatement(sql);){
                            pstmt.setString(1, targetUUID.toString());
                            int rowsAffected = pstmt.executeUpdate();
                            if (rowsAffected > 0) {
                                this.loginSystem.removePlayerPassword(targetUUID);
                                admin.m_213846_((Component)Component.m_237113_((String)("\ufffdaDeleted password for player: " + playerName)).m_130940_(ChatFormatting.GREEN));
                            } else {
                                admin.m_213846_((Component)Component.m_237113_((String)("\ufffdcNo password found for player: " + playerName)).m_130940_(ChatFormatting.RED));
                            }
                            break block19;
                        }
                    }
                }
                if (this.loginSystem.hasPlayerPassword(targetUUID)) {
                    this.loginSystem.removePlayerPassword(targetUUID);
                    this.loginSystem.savePasswordsToFile();
                    admin.m_213846_((Component)Component.m_237113_((String)("\ufffdaDeleted password for player: " + playerName)).m_130940_(ChatFormatting.GREEN));
                } else {
                    admin.m_213846_((Component)Component.m_237113_((String)("\ufffdcNo password found for player: " + playerName)).m_130940_(ChatFormatting.RED));
                }
            }
            catch (SQLException e) {
                admin.m_213846_((Component)Component.m_237113_((String)"\ufffdcFailed to delete password from database!").m_130940_(ChatFormatting.RED));
                LoginSystem.LOGGER.error("Failed to delete password for UUID: " + String.valueOf(targetUUID), (Throwable)e);
            }
        }
    }

    @NotNull
    public ItemStack m_7648_(@Nonnull Player player, int index) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(@Nonnull Player player) {
        return player.m_20310_(2);
    }

    public void m_6877_(@Nonnull Player player) {
        super.m_6877_(player);
    }
}

