/*
 * Decompiled with CFR 0.152.
 */
package com.example.loginsystem;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Properties;
import java.util.UUID;
import org.apache.logging.log4j.Logger;

public class LanguageManager {
    private final Logger logger;
    private final File langDir;
    private final HashMap<String, Properties> languages = new HashMap();
    private final HashMap<UUID, String> playerLanguages = new HashMap();
    private String defaultLanguage;
    public static final String[] SUPPORTED_LANGUAGES = new String[]{"en", "ar", "fr", "de", "zh"};

    public LanguageManager(Logger logger, String defaultLanguage) {
        this.logger = logger;
        this.defaultLanguage = defaultLanguage != null && !defaultLanguage.isEmpty() ? defaultLanguage : "en";
        this.langDir = new File("config/loginsystem/languages");
        if (!this.langDir.exists()) {
            this.langDir.mkdirs();
        }
        this.initializeLanguageFiles();
        this.loadAllLanguages();
    }

    private void initializeLanguageFiles() {
        this.createEnglishFile();
        this.createArabicFile();
        this.createFrenchFile();
        this.createGermanFile();
        this.createChineseFile();
    }

    private void createEnglishFile() {
        File file = new File(this.langDir, "en.properties");
        if (!file.exists()) {
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
                writer.write("# English Language File for Login System\n\n");
                writer.write("# Registration Messages\n");
                writer.write("register.success=\u2705 Registration successful!\n");
                writer.write("register.already=\u26a0\ufe0f You are already registered!\n");
                writer.write("register.password.mismatch=\u274c Passwords do not match!\n");
                writer.write("register.title=Registration Complete\n");
                writer.write("register.subtitle=Welcome to the server!\n\n");
                writer.write("# Login Messages\n");
                writer.write("login.success=\u2705 Login successful!\n");
                writer.write("login.incorrect=\u274c Incorrect password!\n");
                writer.write("login.notRegistered=\u26a0\ufe0f You are not registered! Use /register first.\n");
                writer.write("login.already=\u26a0\ufe0f You are already logged in!\n");
                writer.write("login.title=Login Successful\n");
                writer.write("login.subtitle=Welcome back!\n");
                writer.write("login.prompt=Please login or register\n");
                writer.write("login.promptSubtitle=/register <password> <confirm> or /login <password>\n\n");
                writer.write("# Timeout Messages\n");
                writer.write("timeout.kick=\u23f0 You were kicked for not logging in!\n");
                writer.write("timeout.warning=\u23f0 Time remaining: %s seconds\n");
                writer.write("timeout.bossbar=Login Timeout\n\n");
                writer.write("# Password Change\n");
                writer.write("password.changed=\u2705 Password changed successfully!\n");
                writer.write("password.oldIncorrect=\u274c Old password is incorrect.\n");
                writer.write("password.mustLogin=\u26a0\ufe0f You must be logged in to change your password.\n\n");
                writer.write("# Restriction Messages\n");
                writer.write("restrict.chat=\u274c You must be logged in to chat! Use /register or /login\n");
                writer.write("restrict.command=\u274c You must be logged in to use commands!\n");
                writer.write("restrict.move=\u274c You must be logged in to move!\n");
                writer.write("restrict.break=\u274c You must be logged in to break blocks!\n");
                writer.write("restrict.place=\u274c You must be logged in to place blocks!\n");
                writer.write("restrict.attack=\u274c You must be logged in to attack!\n");
                writer.write("restrict.drop=\u26a0\ufe0f You must be logged in to drop items. Your item has been returned.\n\n");
                writer.write("# Language Command\n");
                writer.write("language.changed=\u2705 Language changed to: %s\n");
                writer.write("language.available=Available languages: en, ar, fr, de, zh\n");
                writer.write("language.usage=Usage: /language <en|ar|fr|de|zh>\n");
            }
            catch (IOException e) {
                this.logger.error("Failed to create English language file", (Throwable)e);
            }
        }
    }

    private void createArabicFile() {
        File file = new File(this.langDir, "ar.properties");
        if (!file.exists()) {
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
                writer.write("# \u0645\u0644\u0641 \u0627\u0644\u0644\u063a\u0629 \u0627\u0644\u0639\u0631\u0628\u064a\u0629 \u0644\u0646\u0638\u0627\u0645 \u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644\n\n");
                writer.write("# \u0631\u0633\u0627\u0626\u0644 \u0627\u0644\u062a\u0633\u062c\u064a\u0644\n");
                writer.write("register.success=\u2705 \u062a\u0645 \u0627\u0644\u062a\u0633\u062c\u064a\u0644 \u0628\u0646\u062c\u0627\u062d!\n");
                writer.write("register.already=\u26a0\ufe0f \u0623\u0646\u062a \u0645\u0633\u062c\u0644 \u0628\u0627\u0644\u0641\u0639\u0644!\n");
                writer.write("register.password.mismatch=\u274c \u0643\u0644\u0645\u0627\u062a \u0627\u0644\u0645\u0631\u0648\u0631 \u063a\u064a\u0631 \u0645\u062a\u0637\u0627\u0628\u0642\u0629!\n");
                writer.write("register.title=\u0627\u0643\u062a\u0645\u0644 \u0627\u0644\u062a\u0633\u062c\u064a\u0644\n");
                writer.write("register.subtitle=\u0645\u0631\u062d\u0628\u0627\u064b \u0628\u0643 \u0641\u064a \u0627\u0644\u0633\u064a\u0631\u0641\u0631!\n\n");
                writer.write("# \u0631\u0633\u0627\u0626\u0644 \u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644\n");
                writer.write("login.success=\u2705 \u062a\u0645 \u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644 \u0628\u0646\u062c\u0627\u062d!\n");
                writer.write("login.incorrect=\u274c \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u063a\u064a\u0631 \u0635\u062d\u064a\u062d\u0629!\n");
                writer.write("login.notRegistered=\u26a0\ufe0f \u0623\u0646\u062a \u063a\u064a\u0631 \u0645\u0633\u062c\u0644! \u0627\u0633\u062a\u062e\u062f\u0645 /register \u0623\u0648\u0644\u0627\u064b.\n");
                writer.write("login.already=\u26a0\ufe0f \u0623\u0646\u062a \u0645\u0633\u062c\u0644 \u062f\u062e\u0648\u0644\u0643 \u0628\u0627\u0644\u0641\u0639\u0644!\n");
                writer.write("login.title=\u062a\u0645 \u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644\n");
                writer.write("login.subtitle=\u0645\u0631\u062d\u0628\u0627\u064b \u0628\u0639\u0648\u062f\u062a\u0643!\n");
                writer.write("login.prompt=\u0627\u0644\u0631\u062c\u0627\u0621 \u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644 \u0623\u0648 \u0627\u0644\u062a\u0633\u062c\u064a\u0644\n");
                writer.write("login.promptSubtitle=/register <\u0643\u0644\u0645\u0629_\u0627\u0644\u0645\u0631\u0648\u0631> <\u062a\u0623\u0643\u064a\u062f> \u0623\u0648 /login <\u0643\u0644\u0645\u0629_\u0627\u0644\u0645\u0631\u0648\u0631>\n\n");
                writer.write("# \u0631\u0633\u0627\u0626\u0644 \u0627\u0646\u062a\u0647\u0627\u0621 \u0627\u0644\u0648\u0642\u062a\n");
                writer.write("timeout.kick=\u23f0 \u062a\u0645 \u0637\u0631\u062f\u0643 \u0644\u0639\u062f\u0645 \u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644!\n");
                writer.write("timeout.warning=\u23f0 \u0627\u0644\u0648\u0642\u062a \u0627\u0644\u0645\u062a\u0628\u0642\u064a: %s \u062b\u0627\u0646\u064a\u0629\n");
                writer.write("timeout.bossbar=\u0648\u0642\u062a \u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644\n\n");
                writer.write("# \u062a\u063a\u064a\u064a\u0631 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631\n");
                writer.write("password.changed=\u2705 \u062a\u0645 \u062a\u063a\u064a\u064a\u0631 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u0628\u0646\u062c\u0627\u062d!\n");
                writer.write("password.oldIncorrect=\u274c \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631 \u0627\u0644\u0642\u062f\u064a\u0645\u0629 \u063a\u064a\u0631 \u0635\u062d\u064a\u062d\u0629.\n");
                writer.write("password.mustLogin=\u26a0\ufe0f \u064a\u062c\u0628 \u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644 \u0644\u062a\u063a\u064a\u064a\u0631 \u0643\u0644\u0645\u0629 \u0627\u0644\u0645\u0631\u0648\u0631.\n\n");
                writer.write("# \u0631\u0633\u0627\u0626\u0644 \u0627\u0644\u0642\u064a\u0648\u062f\n");
                writer.write("restrict.chat=\u274c \u064a\u062c\u0628 \u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644 \u0644\u0644\u062f\u0631\u062f\u0634\u0629! \u0627\u0633\u062a\u062e\u062f\u0645 /register \u0623\u0648 /login\n");
                writer.write("restrict.command=\u274c \u064a\u062c\u0628 \u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644 \u0644\u0627\u0633\u062a\u062e\u062f\u0627\u0645 \u0627\u0644\u0623\u0648\u0627\u0645\u0631!\n");
                writer.write("restrict.move=\u274c \u064a\u062c\u0628 \u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644 \u0644\u0644\u062a\u062d\u0631\u0643!\n");
                writer.write("restrict.break=\u274c \u064a\u062c\u0628 \u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644 \u0644\u0643\u0633\u0631 \u0627\u0644\u0643\u062a\u0644!\n");
                writer.write("restrict.place=\u274c \u064a\u062c\u0628 \u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644 \u0644\u0648\u0636\u0639 \u0627\u0644\u0643\u062a\u0644!\n");
                writer.write("restrict.attack=\u274c \u064a\u062c\u0628 \u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644 \u0644\u0644\u0647\u062c\u0648\u0645!\n");
                writer.write("restrict.drop=\u26a0\ufe0f \u064a\u062c\u0628 \u062a\u0633\u062c\u064a\u0644 \u0627\u0644\u062f\u062e\u0648\u0644 \u0644\u0625\u0633\u0642\u0627\u0637 \u0627\u0644\u0639\u0646\u0627\u0635\u0631. \u062a\u0645 \u0625\u0631\u062c\u0627\u0639 \u0627\u0644\u0639\u0646\u0635\u0631.\n\n");
                writer.write("# \u0623\u0645\u0631 \u0627\u0644\u0644\u063a\u0629\n");
                writer.write("language.changed=\u2705 \u062a\u0645 \u062a\u063a\u064a\u064a\u0631 \u0627\u0644\u0644\u063a\u0629 \u0625\u0644\u0649: %s\n");
                writer.write("language.available=\u0627\u0644\u0644\u063a\u0627\u062a \u0627\u0644\u0645\u062a\u0627\u062d\u0629: en, ar, fr, de, zh\n");
                writer.write("language.usage=\u0627\u0644\u0627\u0633\u062a\u062e\u062f\u0627\u0645: /language <en|ar|fr|de|zh>\n");
            }
            catch (IOException e) {
                this.logger.error("Failed to create Arabic language file", (Throwable)e);
            }
        }
    }

    private void createFrenchFile() {
        File file = new File(this.langDir, "fr.properties");
        if (!file.exists()) {
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
                writer.write("# Fichier de langue fran\u00e7aise pour le syst\u00e8me de connexion\n\n");
                writer.write("# Messages d'inscription\n");
                writer.write("register.success=\u2705 Inscription r\u00e9ussie!\n");
                writer.write("register.already=\u26a0\ufe0f Vous \u00eates d\u00e9j\u00e0 inscrit!\n");
                writer.write("register.password.mismatch=\u274c Les mots de passe ne correspondent pas!\n");
                writer.write("register.title=Inscription termin\u00e9e\n");
                writer.write("register.subtitle=Bienvenue sur le serveur!\n\n");
                writer.write("# Messages de connexion\n");
                writer.write("login.success=\u2705 Connexion r\u00e9ussie!\n");
                writer.write("login.incorrect=\u274c Mot de passe incorrect!\n");
                writer.write("login.notRegistered=\u26a0\ufe0f Vous n'\u00eates pas inscrit! Utilisez /register d'abord.\n");
                writer.write("login.already=\u26a0\ufe0f Vous \u00eates d\u00e9j\u00e0 connect\u00e9!\n");
                writer.write("login.title=Connexion r\u00e9ussie\n");
                writer.write("login.subtitle=Bon retour!\n");
                writer.write("login.prompt=Veuillez vous connecter ou vous inscrire\n");
                writer.write("login.promptSubtitle=/register <mot_de_passe> <confirmer> ou /login <mot_de_passe>\n\n");
                writer.write("# Messages de d\u00e9lai d'attente\n");
                writer.write("timeout.kick=\u23f0 Vous avez \u00e9t\u00e9 expuls\u00e9 pour ne pas vous \u00eatre connect\u00e9!\n");
                writer.write("timeout.warning=\u23f0 Temps restant: %s secondes\n");
                writer.write("timeout.bossbar=D\u00e9lai de connexion\n\n");
                writer.write("# Changement de mot de passe\n");
                writer.write("password.changed=\u2705 Mot de passe chang\u00e9 avec succ\u00e8s!\n");
                writer.write("password.oldIncorrect=\u274c L'ancien mot de passe est incorrect.\n");
                writer.write("password.mustLogin=\u26a0\ufe0f Vous devez \u00eatre connect\u00e9 pour changer votre mot de passe.\n\n");
                writer.write("# Messages de restriction\n");
                writer.write("restrict.chat=\u274c Vous devez \u00eatre connect\u00e9 pour discuter! Utilisez /register ou /login\n");
                writer.write("restrict.command=\u274c Vous devez \u00eatre connect\u00e9 pour utiliser les commandes!\n");
                writer.write("restrict.move=\u274c Vous devez \u00eatre connect\u00e9 pour vous d\u00e9placer!\n");
                writer.write("restrict.break=\u274c Vous devez \u00eatre connect\u00e9 pour casser des blocs!\n");
                writer.write("restrict.place=\u274c Vous devez \u00eatre connect\u00e9 pour placer des blocs!\n");
                writer.write("restrict.attack=\u274c Vous devez \u00eatre connect\u00e9 pour attaquer!\n");
                writer.write("restrict.drop=\u26a0\ufe0f Vous devez \u00eatre connect\u00e9 pour jeter des objets. Votre objet a \u00e9t\u00e9 retourn\u00e9.\n\n");
                writer.write("# Commande de langue\n");
                writer.write("language.changed=\u2705 Langue chang\u00e9e en: %s\n");
                writer.write("language.available=Langues disponibles: en, ar, fr, de, zh\n");
                writer.write("language.usage=Usage: /language <en|ar|fr|de|zh>\n");
            }
            catch (IOException e) {
                this.logger.error("Failed to create French language file", (Throwable)e);
            }
        }
    }

    private void createGermanFile() {
        File file = new File(this.langDir, "de.properties");
        if (!file.exists()) {
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
                writer.write("# Deutsche Sprachdatei f\u00fcr das Anmeldesystem\n\n");
                writer.write("# Registrierungsnachrichten\n");
                writer.write("register.success=\u2705 Registrierung erfolgreich!\n");
                writer.write("register.already=\u26a0\ufe0f Sie sind bereits registriert!\n");
                writer.write("register.password.mismatch=\u274c Passw\u00f6rter stimmen nicht \u00fcberein!\n");
                writer.write("register.title=Registrierung abgeschlossen\n");
                writer.write("register.subtitle=Willkommen auf dem Server!\n\n");
                writer.write("# Anmeldenachrichten\n");
                writer.write("login.success=\u2705 Anmeldung erfolgreich!\n");
                writer.write("login.incorrect=\u274c Falsches Passwort!\n");
                writer.write("login.notRegistered=\u26a0\ufe0f Sie sind nicht registriert! Verwenden Sie zuerst /register.\n");
                writer.write("login.already=\u26a0\ufe0f Sie sind bereits angemeldet!\n");
                writer.write("login.title=Anmeldung erfolgreich\n");
                writer.write("login.subtitle=Willkommen zur\u00fcck!\n");
                writer.write("login.prompt=Bitte anmelden oder registrieren\n");
                writer.write("login.promptSubtitle=/register <passwort> <best\u00e4tigen> oder /login <passwort>\n\n");
                writer.write("# Timeout-Nachrichten\n");
                writer.write("timeout.kick=\u23f0 Sie wurden gekickt, weil Sie sich nicht angemeldet haben!\n");
                writer.write("timeout.warning=\u23f0 Verbleibende Zeit: %s Sekunden\n");
                writer.write("timeout.bossbar=Anmelde-Timeout\n\n");
                writer.write("# Passwort \u00e4ndern\n");
                writer.write("password.changed=\u2705 Passwort erfolgreich ge\u00e4ndert!\n");
                writer.write("password.oldIncorrect=\u274c Das alte Passwort ist falsch.\n");
                writer.write("password.mustLogin=\u26a0\ufe0f Sie m\u00fcssen angemeldet sein, um Ihr Passwort zu \u00e4ndern.\n\n");
                writer.write("# Einschr\u00e4nkungsnachrichten\n");
                writer.write("restrict.chat=\u274c Sie m\u00fcssen angemeldet sein, um zu chatten! Verwenden Sie /register oder /login\n");
                writer.write("restrict.command=\u274c Sie m\u00fcssen angemeldet sein, um Befehle zu verwenden!\n");
                writer.write("restrict.move=\u274c Sie m\u00fcssen angemeldet sein, um sich zu bewegen!\n");
                writer.write("restrict.break=\u274c Sie m\u00fcssen angemeldet sein, um Bl\u00f6cke abzubauen!\n");
                writer.write("restrict.place=\u274c Sie m\u00fcssen angemeldet sein, um Bl\u00f6cke zu platzieren!\n");
                writer.write("restrict.attack=\u274c Sie m\u00fcssen angemeldet sein, um anzugreifen!\n");
                writer.write("restrict.drop=\u26a0\ufe0f Sie m\u00fcssen angemeldet sein, um Gegenst\u00e4nde fallen zu lassen. Ihr Gegenstand wurde zur\u00fcckgegeben.\n\n");
                writer.write("# Sprachbefehl\n");
                writer.write("language.changed=\u2705 Sprache ge\u00e4ndert zu: %s\n");
                writer.write("language.available=Verf\u00fcgbare Sprachen: en, ar, fr, de, zh\n");
                writer.write("language.usage=Verwendung: /language <en|ar|fr|de|zh>\n");
            }
            catch (IOException e) {
                this.logger.error("Failed to create German language file", (Throwable)e);
            }
        }
    }

    private void createChineseFile() {
        File file = new File(this.langDir, "zh.properties");
        if (!file.exists()) {
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
                writer.write("# \u767b\u5f55\u7cfb\u7edf\u4e2d\u6587\u8bed\u8a00\u6587\u4ef6\n\n");
                writer.write("# \u6ce8\u518c\u6d88\u606f\n");
                writer.write("register.success=\u2705 \u6ce8\u518c\u6210\u529f\uff01\n");
                writer.write("register.already=\u26a0\ufe0f \u60a8\u5df2\u7ecf\u6ce8\u518c\u8fc7\u4e86\uff01\n");
                writer.write("register.password.mismatch=\u274c \u5bc6\u7801\u4e0d\u5339\u914d\uff01\n");
                writer.write("register.title=\u6ce8\u518c\u5b8c\u6210\n");
                writer.write("register.subtitle=\u6b22\u8fce\u6765\u5230\u670d\u52a1\u5668\uff01\n\n");
                writer.write("# \u767b\u5f55\u6d88\u606f\n");
                writer.write("login.success=\u2705 \u767b\u5f55\u6210\u529f\uff01\n");
                writer.write("login.incorrect=\u274c \u5bc6\u7801\u9519\u8bef\uff01\n");
                writer.write("login.notRegistered=\u26a0\ufe0f \u60a8\u5c1a\u672a\u6ce8\u518c\uff01\u8bf7\u5148\u4f7f\u7528 /register\u3002\n");
                writer.write("login.already=\u26a0\ufe0f \u60a8\u5df2\u7ecf\u767b\u5f55\u4e86\uff01\n");
                writer.write("login.title=\u767b\u5f55\u6210\u529f\n");
                writer.write("login.subtitle=\u6b22\u8fce\u56de\u6765\uff01\n");
                writer.write("login.prompt=\u8bf7\u767b\u5f55\u6216\u6ce8\u518c\n");
                writer.write("login.promptSubtitle=/register <\u5bc6\u7801> <\u786e\u8ba4> \u6216 /login <\u5bc6\u7801>\n\n");
                writer.write("# \u8d85\u65f6\u6d88\u606f\n");
                writer.write("timeout.kick=\u23f0 \u60a8\u56e0\u672a\u767b\u5f55\u800c\u88ab\u8e22\u51fa\uff01\n");
                writer.write("timeout.warning=\u23f0 \u5269\u4f59\u65f6\u95f4\uff1a%s \u79d2\n");
                writer.write("timeout.bossbar=\u767b\u5f55\u8d85\u65f6\n\n");
                writer.write("# \u4fee\u6539\u5bc6\u7801\n");
                writer.write("password.changed=\u2705 \u5bc6\u7801\u4fee\u6539\u6210\u529f\uff01\n");
                writer.write("password.oldIncorrect=\u274c \u65e7\u5bc6\u7801\u4e0d\u6b63\u786e\u3002\n");
                writer.write("password.mustLogin=\u26a0\ufe0f \u60a8\u5fc5\u987b\u767b\u5f55\u624d\u80fd\u4fee\u6539\u5bc6\u7801\u3002\n\n");
                writer.write("# \u9650\u5236\u6d88\u606f\n");
                writer.write("restrict.chat=\u274c \u60a8\u5fc5\u987b\u767b\u5f55\u624d\u80fd\u804a\u5929\uff01\u8bf7\u4f7f\u7528 /register \u6216 /login\n");
                writer.write("restrict.command=\u274c \u60a8\u5fc5\u987b\u767b\u5f55\u624d\u80fd\u4f7f\u7528\u547d\u4ee4\uff01\n");
                writer.write("restrict.move=\u274c \u60a8\u5fc5\u987b\u767b\u5f55\u624d\u80fd\u79fb\u52a8\uff01\n");
                writer.write("restrict.break=\u274c \u60a8\u5fc5\u987b\u767b\u5f55\u624d\u80fd\u7834\u574f\u65b9\u5757\uff01\n");
                writer.write("restrict.place=\u274c \u60a8\u5fc5\u987b\u767b\u5f55\u624d\u80fd\u653e\u7f6e\u65b9\u5757\uff01\n");
                writer.write("restrict.attack=\u274c \u60a8\u5fc5\u987b\u767b\u5f55\u624d\u80fd\u653b\u51fb\uff01\n");
                writer.write("restrict.drop=\u26a0\ufe0f \u60a8\u5fc5\u987b\u767b\u5f55\u624d\u80fd\u4e22\u5f03\u7269\u54c1\u3002\u60a8\u7684\u7269\u54c1\u5df2\u5f52\u8fd8\u3002\n\n");
                writer.write("# \u8bed\u8a00\u547d\u4ee4\n");
                writer.write("language.changed=\u2705 \u8bed\u8a00\u5df2\u66f4\u6539\u4e3a\uff1a%s\n");
                writer.write("language.available=\u53ef\u7528\u8bed\u8a00\uff1aen, ar, fr, de, zh\n");
                writer.write("language.usage=\u7528\u6cd5\uff1a/language <en|ar|fr|de|zh>\n");
            }
            catch (IOException e) {
                this.logger.error("Failed to create Chinese language file", (Throwable)e);
            }
        }
    }

    private void loadAllLanguages() {
        for (String lang : SUPPORTED_LANGUAGES) {
            boolean loaded;
            Properties props;
            block25: {
                props = new Properties();
                loaded = false;
                File langFile = new File(this.langDir, lang + ".properties");
                if (langFile.exists()) {
                    try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(langFile), StandardCharsets.UTF_8);){
                        props.load(reader);
                        loaded = true;
                        this.logger.info("Loaded language from config: " + lang);
                    }
                    catch (IOException e) {
                        this.logger.warn("Failed to load language file from config: " + lang, (Throwable)e);
                    }
                }
                if (!loaded) {
                    try (InputStream stream = this.getClass().getResourceAsStream("/languages/" + lang + ".properties");){
                        if (stream == null) break block25;
                        try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                            props.load(reader);
                            loaded = true;
                            this.logger.info("Loaded language from resources: " + lang);
                        }
                    }
                    catch (IOException e) {
                        this.logger.warn("Failed to load language from resources: " + lang, (Throwable)e);
                    }
                }
            }
            if (loaded && !props.isEmpty()) {
                this.languages.put(lang, props);
                continue;
            }
            this.logger.error("Failed to load language: " + lang + " - No valid file found!");
        }
    }

    public String getMessage(UUID playerId, String key, Object ... args) {
        String lang = this.playerLanguages.getOrDefault(playerId, this.defaultLanguage);
        Properties props = this.languages.get(lang);
        if (props == null) {
            props = this.languages.get(this.defaultLanguage);
        }
        String message = props.getProperty(key, key);
        if (args.length > 0) {
            message = String.format(message, args);
        }
        return message;
    }

    public void setPlayerLanguage(UUID playerId, String language) {
        if (this.languages.containsKey(language)) {
            this.playerLanguages.put(playerId, language);
        }
    }

    public String getPlayerLanguage(UUID playerId) {
        return this.playerLanguages.getOrDefault(playerId, this.defaultLanguage);
    }

    public boolean isLanguageSupported(String language) {
        return this.languages.containsKey(language);
    }

    public void removePlayer(UUID playerId) {
        this.playerLanguages.remove(playerId);
    }
}

