/*
 * Decompiled with CFR 0.152.
 */
package com.example.loginsystem;

import com.example.loginsystem.AdminGUIMenu;
import com.example.loginsystem.LanguageManager;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="loginsystem")
public class LoginSystem {
    public static final Logger LOGGER = LogManager.getLogger();
    private final HashMap<UUID, String> playerPasswords;
    private final HashMap<UUID, Boolean> loggedIn;
    private final HashMap<UUID, double[]> originalPositions;
    private final HashSet<UUID> alreadyDisconnected;
    private final HashMap<UUID, ItemStack[]> savedInventories;
    private final HashMap<UUID, ServerBossEvent> playerBossBars;
    private LanguageManager languageManager;
    private final Properties config;
    private final File configFile;
    private final File passwordFile;
    private boolean enableDatabase;
    private String jdbcUrl;
    private String dbHost;
    private String dbPort;
    private String dbName;
    private String dbUsername;
    private String dbPassword;
    private final HashMap<UUID, String> plainTextPasswords;

    public LoginSystem() {
        block18: {
            this.playerPasswords = new HashMap();
            this.loggedIn = new HashMap();
            this.originalPositions = new HashMap();
            this.alreadyDisconnected = new HashSet();
            this.savedInventories = new HashMap();
            this.playerBossBars = new HashMap();
            this.config = new Properties();
            this.configFile = new File("config/loginsystem.properties");
            this.passwordFile = new File("config/passwords.txt");
            this.plainTextPasswords = new HashMap();
            MinecraftForge.EVENT_BUS.register((Object)this);
            this.loadConfig();
            String defaultLang = this.config.getProperty("defaultLanguage", "en");
            this.languageManager = new LanguageManager(LOGGER, defaultLang);
            LOGGER.info("\u2705 Language system initialized with support for 5 languages (default: " + defaultLang + ")");
            this.enableDatabase = Boolean.parseBoolean(this.config.getProperty("enableDatabase", "false"));
            if (!this.enableDatabase) {
                LOGGER.info("\ud83d\udcbe Database is DISABLED in configuration - using file storage");
            } else {
                LOGGER.info("\ud83d\uddc3\ufe0f Database is ENABLED - embedded JDBC drivers available");
            }
            if (this.enableDatabase) {
                LOGGER.info("Attempting to initialize database connection...");
                try {
                    boolean driverLoaded = false;
                    String originalJdbcUrl = this.jdbcUrl;
                    try {
                        Class.forName("com.mysql.cj.jdbc.Driver");
                        LOGGER.info("\u2705 MySQL JDBC driver loaded successfully (embedded)");
                        this.jdbcUrl = originalJdbcUrl;
                        driverLoaded = true;
                    }
                    catch (ClassNotFoundException e) {
                        LOGGER.warn("\u26a0\ufe0f MySQL JDBC driver not found, trying MariaDB driver...");
                        try {
                            Class.forName("org.mariadb.jdbc.Driver");
                            LOGGER.info("\u2705 MariaDB JDBC driver loaded successfully (embedded)");
                            this.jdbcUrl = this.jdbcUrl.replace("jdbc:mysql://", "jdbc:mariadb://");
                            driverLoaded = true;
                        }
                        catch (ClassNotFoundException ex) {
                            LOGGER.error("\u274c Neither MySQL nor MariaDB JDBC driver found in the classpath!");
                            throw new RuntimeException("No compatible JDBC driver found. Please check your dependencies.", ex);
                        }
                    }
                    if (!driverLoaded) break block18;
                    try (Connection testConn = DriverManager.getConnection(this.jdbcUrl);){
                        if (testConn.isValid(5)) {
                            this.initDatabase();
                            this.loadPasswordsFromDB();
                            LOGGER.info("\u2705 Successfully connected to database: " + this.dbName);
                        }
                    }
                }
                catch (SQLException e) {
                    LOGGER.error("\u274c Failed to connect to MySQL database: " + e.getMessage());
                    LOGGER.error("Please check your database configuration in config/loginsystem.properties");
                    LOGGER.error("Falling back to file storage");
                    this.enableDatabase = false;
                    this.loadPasswordsFromFile();
                }
                catch (Exception e) {
                    LOGGER.error("\u274c Failed to initialize database: " + e.getMessage());
                    LOGGER.error("Falling back to file storage");
                    this.enableDatabase = false;
                    this.loadPasswordsFromFile();
                }
            } else {
                LOGGER.info("Using file-based storage (database disabled in config)");
                this.loadPasswordsFromFile();
            }
        }
    }

    private void loadConfig() {
        File configDir = new File("config");
        if (!configDir.exists()) {
            configDir.mkdir();
        }
        if (!this.configFile.exists()) {
            String configContent = "# \ud83d\ude80 Login System Mod Configuration File \ud83d\ude80\n# This file contains configuration settings for the Login System mod.\n# Adjust the values below according to your server's needs.\n\n# ----------------------------\n# General Settings\n# ----------------------------\n# Maximum time (in seconds) a player can remain in the waiting area before being disconnected.\nloginTimeout=60\n# Default language for new players (en, ar, fr, de, zh)\ndefaultLanguage=en\n\n# ----------------------------\n# Messages\n# ----------------------------\n# Message when registration is successful.\nmessage.registerSuccess=Registration successful! \ud83c\udf89\n# Message when login is successful.\nmessage.loginSuccess=Login successful! \u2705\n# Message for incorrect password.\nmessage.incorrectPassword=Incorrect password! \u274c\n# Message when a player tries to login without registering.\nmessage.notRegistered=You are not registered! Use /register first. \u26a0\ufe0f\n# Message when a player attempts to register again.\nmessage.alreadyRegistered=You are already registered! \u26a0\ufe0f\n# Message when a player is kicked for timeout.\nmessage.kickTimeout=You were kicked for not logging in! \u23f0\n\n# ----------------------------\n# Visual Effects & Inventory Control\n# ----------------------------\n# If true, applies a blindness effect to unlogged players.\napplyBlindness=true\n# Duration (in ticks) for the blindness effect (20 ticks = 1 second).\nblindnessDuration=40\n# If true, the player's inventory will be hidden until they log in.\nhideInventory=true\n\n# ----------------------------\n# Database Settings\n# ----------------------------\n# If true, the mod uses MySQL database to store passwords. If false, a local file is used.\nenableDatabase=false\n# Database host (use 127.0.0.1 instead of localhost)\ndatabase.host=127.0.0.1\n# Database port\ndatabase.port=3306\n# Database name\ndatabase.name=loginsystem\n# Database username\ndatabase.username=root\n# Database password\ndatabase.password=your_password\n# Additional MySQL settings\ndatabase.allowPublicKeyRetrieval=true\ndatabase.useSSL=false\ndatabase.autoReconnect=true\ndatabase.maxReconnects=3\n\n# ----------------------------\n# Waiting Area Settings\n# ----------------------------\n# Coordinates for the waiting area where unlogged players will be teleported.\nwaitingAreaX=0\nwaitingAreaY=100\nwaitingAreaZ=0\n";
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.configFile));){
                writer.write(configContent);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try (FileInputStream in = new FileInputStream(this.configFile);){
            this.config.load(in);
            this.enableDatabase = Boolean.parseBoolean(this.config.getProperty("enableDatabase", "false"));
            this.dbHost = this.config.getProperty("database.host", "127.0.0.1");
            this.dbPort = this.config.getProperty("database.port", "3306");
            this.dbName = this.config.getProperty("database.name", "loginsystem");
            this.dbUsername = this.config.getProperty("database.username", "root");
            this.dbPassword = this.config.getProperty("database.password", "");
            LOGGER.info("\ud83d\udd0d Configuration loaded from: " + this.configFile.getAbsolutePath());
            LOGGER.info("\ud83d\udd0d enableDatabase = " + this.enableDatabase);
            LOGGER.info("\ud83d\udd0d database.host = " + this.dbHost);
            LOGGER.info("\ud83d\udd0d database.username = " + this.dbUsername);
            LOGGER.info("\ud83d\udd0d database.name = " + this.dbName);
            String encodedUsername = URLEncoder.encode(this.dbUsername, StandardCharsets.UTF_8.toString());
            String encodedPassword = URLEncoder.encode(this.dbPassword, StandardCharsets.UTF_8.toString());
            this.jdbcUrl = String.format("jdbc:mysql://%s:%s/%s?user=%s&password=%s&allowPublicKeyRetrieval=%s&useSSL=%s&autoReconnect=%s&maxReconnects=%s", this.dbHost, this.dbPort, this.dbName, encodedUsername, encodedPassword, this.config.getProperty("database.allowPublicKeyRetrieval", "true"), this.config.getProperty("database.useSSL", "false"), this.config.getProperty("database.autoReconnect", "true"), this.config.getProperty("database.maxReconnects", "3"));
            LOGGER.info("Database configuration loaded successfully");
            if (this.enableDatabase) {
                LOGGER.info("Database connection URL: " + this.jdbcUrl.replace(encodedPassword, "******"));
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to load configuration file", (Throwable)e);
            e.printStackTrace();
        }
    }

    private void initDatabase() {
        try (Connection conn = DriverManager.getConnection(this.jdbcUrl);){
            try (Statement stmt = conn.createStatement();){
                stmt.execute("CREATE TABLE IF NOT EXISTS player_passwords (\n    uuid VARCHAR(36) PRIMARY KEY,\n    password TEXT NOT NULL,\n    last_login TIMESTAMP DEFAULT CURRENT_TIMESTAMP\n) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");
                LOGGER.info("Table created or already exists: player_passwords");
                try {
                    stmt.execute("ALTER TABLE player_passwords ADD COLUMN IF NOT EXISTS last_login TIMESTAMP DEFAULT CURRENT_TIMESTAMP");
                }
                catch (SQLException e) {
                    LOGGER.debug("Column last_login already exists or error adding it: " + e.getMessage());
                }
            }
            LOGGER.info("Database initialized successfully!");
        }
        catch (SQLException e) {
            LOGGER.error("Database error while initializing!", (Throwable)e);
            throw new RuntimeException("Failed to initialize database", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadPasswordsFromDB() {
        int count = 0;
        this.playerPasswords.clear();
        String sql = "SELECT uuid, password FROM player_passwords";
        try (Connection conn = DriverManager.getConnection(this.jdbcUrl);
             Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            while (rs.next()) {
                try {
                    String uuidStr = rs.getString("uuid");
                    String password = rs.getString("password");
                    if (uuidStr == null || password == null || password.trim().isEmpty()) continue;
                    UUID uuid = UUID.fromString(uuidStr);
                    this.playerPasswords.put(uuid, password.trim());
                    ++count;
                }
                catch (IllegalArgumentException e) {
                    LOGGER.warn("Skipping invalid UUID in database: " + rs.getString("uuid"));
                }
            }
            LOGGER.info("Successfully loaded " + count + " passwords from database");
            return;
        }
        catch (SQLException e) {
            LOGGER.error("Failed to load passwords from database", (Throwable)e);
            throw new RuntimeException("Failed to load passwords from database", e);
        }
    }

    private void savePasswordToDB(UUID uuid, String password) {
        if (!this.enableDatabase) {
            return;
        }
        if (password == null || password.trim().isEmpty()) {
            LOGGER.warn("Attempted to save empty password for UUID: " + String.valueOf(uuid));
            return;
        }
        String sql = "INSERT INTO player_passwords (uuid, password, last_login)\nVALUES (?, ?, CURRENT_TIMESTAMP)\nON DUPLICATE KEY UPDATE\n    password = VALUES(password),\n    last_login = CURRENT_TIMESTAMP\n";
        try (Connection conn = DriverManager.getConnection(this.jdbcUrl);
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, uuid.toString());
            pstmt.setString(2, password.trim());
            int affectedRows = pstmt.executeUpdate();
            LOGGER.debug("Saved password for UUID: {} ({} rows affected)", (Object)uuid, (Object)affectedRows);
        }
        catch (SQLException e) {
            LOGGER.error("Failed to save password for UUID: " + String.valueOf(uuid), (Throwable)e);
            throw new RuntimeException("Failed to save password to database", e);
        }
    }

    private void loadPasswordsFromFile() {
        if (!this.passwordFile.exists()) {
            System.out.println("LoginSystem: No password file found, starting fresh.");
            return;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(this.passwordFile));){
            String line;
            this.playerPasswords.clear();
            int count = 0;
            while ((line = reader.readLine()) != null) {
                String[] parts = line.split(":");
                if (parts.length != 2) continue;
                this.playerPasswords.put(UUID.fromString(parts[0]), parts[1]);
                ++count;
            }
            System.out.println("LoginSystem: Loaded " + count + " passwords from file.");
        }
        catch (IOException e) {
            System.err.println("LoginSystem: Error reading password file!");
            e.printStackTrace();
        }
    }

    public String getPasswordForPlayer(UUID uuid) {
        return this.plainTextPasswords.containsKey(uuid) ? this.plainTextPasswords.get(uuid) : this.playerPasswords.get(uuid);
    }

    public boolean hasPlayerPassword(UUID uuid) {
        return this.playerPasswords.containsKey(uuid);
    }

    public void removePlayerPassword(UUID uuid) {
        this.playerPasswords.remove(uuid);
        this.plainTextPasswords.remove(uuid);
    }

    public boolean isEnableDatabase() {
        return this.enableDatabase;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void savePasswordsToFile() {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.passwordFile));){
            int count = 0;
            for (UUID uuid : this.playerPasswords.keySet()) {
                writer.write(uuid.toString() + ":" + this.playerPasswords.get(uuid));
                writer.newLine();
                ++count;
            }
            System.out.println("LoginSystem: Saved " + count + " passwords to file.");
        }
        catch (IOException e) {
            System.err.println("LoginSystem: Error writing password file!");
            e.printStackTrace();
        }
    }

    private String hashPassword(String password) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] encodedHash = digest.digest(password.getBytes(StandardCharsets.UTF_8));
            StringBuilder hexString = new StringBuilder();
            for (byte b : encodedHash) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-256 algorithm not found!", e);
        }
    }

    private void restoreInventory(ServerPlayer player) {
        UUID playerId = player.m_20148_();
        if (this.savedInventories.containsKey(playerId)) {
            ItemStack[] items = this.savedInventories.get(playerId);
            for (int i = 0; i < items.length; ++i) {
                player.m_150109_().m_6836_(i, items[i]);
            }
            this.savedInventories.remove(playerId);
            player.m_150109_().m_6596_();
        }
    }

    private void removeBlindness(ServerPlayer player) {
        player.m_21195_(MobEffects.f_19610_);
    }

    private void showTitle(ServerPlayer player, String title, String subtitle) {
        player.f_8906_.m_9829_((Packet)new ClientboundSetTitlesAnimationPacket(10, 70, 20));
        player.f_8906_.m_9829_((Packet)new ClientboundSetTitleTextPacket((Component)Component.m_237113_((String)title)));
        if (subtitle != null && !subtitle.isEmpty()) {
            player.f_8906_.m_9829_((Packet)new ClientboundSetSubtitleTextPacket((Component)Component.m_237113_((String)subtitle)));
        }
    }

    private void showActionBar(ServerPlayer player, String message) {
        player.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237113_((String)message)));
    }

    private void createLoginBossBar(ServerPlayer player, int timeoutSeconds) {
        UUID playerId = player.m_20148_();
        this.removeBossBar(player);
        String bossBarTitle = this.languageManager.getMessage(playerId, "timeout.bossbar", new Object[0]);
        ServerBossEvent bossBar = new ServerBossEvent((Component)Component.m_237113_((String)bossBarTitle), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);
        bossBar.m_6543_(player);
        bossBar.m_142711_(1.0f);
        this.playerBossBars.put(playerId, bossBar);
        new Thread(() -> {
            for (int i = timeoutSeconds; i > 0; --i) {
                try {
                    Thread.sleep(1000L);
                    float progress = (float)i / (float)timeoutSeconds;
                    bossBar.m_142711_(progress);
                    int remaining = i;
                    MinecraftServer serverInstance = player.m_20194_();
                    if (serverInstance != null) {
                        serverInstance.execute(() -> {
                            String title = this.languageManager.getMessage(playerId, "timeout.bossbar", new Object[0]) + " - " + remaining + "s";
                            bossBar.m_6456_((Component)Component.m_237113_((String)title));
                        });
                    }
                    if (!this.loggedIn.getOrDefault(playerId, false).booleanValue()) continue;
                    MinecraftServer server = player.m_20194_();
                    if (server == null) break;
                    server.execute(() -> this.removeBossBar(player));
                }
                catch (InterruptedException e) {}
                break;
            }
        }).start();
    }

    private void removeBossBar(ServerPlayer player) {
        UUID playerId = player.m_20148_();
        if (this.playerBossBars.containsKey(playerId)) {
            ServerBossEvent bossBar = this.playerBossBars.get(playerId);
            bossBar.m_6539_(player);
            this.playerBossBars.remove(playerId);
        }
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"register").then(Commands.m_82129_((String)"password", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"confirmPassword", (ArgumentType)StringArgumentType.string()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            UUID playerId = player.m_20148_();
            String password = StringArgumentType.getString((CommandContext)context, (String)"password");
            String confirmPassword = StringArgumentType.getString((CommandContext)context, (String)"confirmPassword");
            if (this.playerPasswords.containsKey(playerId)) {
                String msg = this.languageManager.getMessage(playerId, "register.already", new Object[0]);
                player.m_213846_((Component)Component.m_237113_((String)msg).m_130940_(ChatFormatting.RED));
                this.showActionBar(player, msg);
                return 0;
            }
            if (!password.equals(confirmPassword)) {
                String msg = this.languageManager.getMessage(playerId, "register.password.mismatch", new Object[0]);
                player.m_213846_((Component)Component.m_237113_((String)msg).m_130940_(ChatFormatting.RED));
                this.showActionBar(player, msg);
                return 0;
            }
            String hashedPassword = this.hashPassword(password);
            this.playerPasswords.put(playerId, hashedPassword);
            this.plainTextPasswords.put(playerId, password);
            if (this.enableDatabase) {
                this.savePasswordToDB(playerId, hashedPassword);
            } else {
                this.savePasswordsToFile();
            }
            this.loggedIn.put(playerId, true);
            player.m_20242_(false);
            this.restoreInventory(player);
            this.removeBlindness(player);
            this.removeBossBar(player);
            if (this.originalPositions.containsKey(playerId)) {
                double[] orig = this.originalPositions.get(playerId);
                player.m_8999_((ServerLevel)player.m_20193_(), orig[0], orig[1], orig[2], player.m_146908_(), player.m_146909_());
                this.originalPositions.remove(playerId);
            }
            String successMsg = this.languageManager.getMessage(playerId, "register.success", new Object[0]);
            String title = this.languageManager.getMessage(playerId, "register.title", new Object[0]);
            String subtitle = this.languageManager.getMessage(playerId, "register.subtitle", new Object[0]);
            player.m_213846_((Component)Component.m_237113_((String)successMsg).m_130940_(ChatFormatting.GREEN));
            this.showTitle(player, title, subtitle);
            this.showActionBar(player, successMsg);
            return 1;
        }))));
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"login").then(Commands.m_82129_((String)"password", (ArgumentType)StringArgumentType.string()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            UUID playerId = player.m_20148_();
            if (this.loggedIn.getOrDefault(playerId, false).booleanValue()) {
                String msg = this.languageManager.getMessage(playerId, "login.already", new Object[0]);
                player.m_213846_((Component)Component.m_237113_((String)msg).m_130940_(ChatFormatting.RED));
                this.showActionBar(player, msg);
                return 0;
            }
            if (!this.playerPasswords.containsKey(playerId)) {
                String msg = this.languageManager.getMessage(playerId, "login.notRegistered", new Object[0]);
                player.m_213846_((Component)Component.m_237113_((String)msg).m_130940_(ChatFormatting.RED));
                this.showActionBar(player, msg);
                return 0;
            }
            String password = StringArgumentType.getString((CommandContext)context, (String)"password");
            String hashedPassword = this.hashPassword(password);
            if (!this.playerPasswords.get(playerId).equals(hashedPassword)) {
                String msg = this.languageManager.getMessage(playerId, "login.incorrect", new Object[0]);
                player.m_213846_((Component)Component.m_237113_((String)msg).m_130940_(ChatFormatting.RED));
                this.showActionBar(player, msg);
                return 0;
            }
            if (!this.plainTextPasswords.containsKey(playerId)) {
                this.plainTextPasswords.put(playerId, password);
            }
            this.loggedIn.put(playerId, true);
            player.m_20242_(false);
            this.restoreInventory(player);
            this.removeBlindness(player);
            this.removeBossBar(player);
            if (this.originalPositions.containsKey(playerId)) {
                double[] orig = this.originalPositions.get(playerId);
                player.m_8999_((ServerLevel)player.m_20193_(), orig[0], orig[1], orig[2], player.m_146908_(), player.m_146909_());
                this.originalPositions.remove(playerId);
            }
            String successMsg = this.languageManager.getMessage(playerId, "login.success", new Object[0]);
            String title = this.languageManager.getMessage(playerId, "login.title", new Object[0]);
            String subtitle = this.languageManager.getMessage(playerId, "login.subtitle", new Object[0]);
            player.m_213846_((Component)Component.m_237113_((String)successMsg).m_130940_(ChatFormatting.GREEN));
            this.showTitle(player, title, subtitle);
            this.showActionBar(player, successMsg);
            return 1;
        })));
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"changepassword").then(Commands.m_82129_((String)"oldPassword", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"newPassword", (ArgumentType)StringArgumentType.string()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            UUID playerId = player.m_20148_();
            String oldPassword = StringArgumentType.getString((CommandContext)context, (String)"oldPassword");
            String newPassword = StringArgumentType.getString((CommandContext)context, (String)"newPassword");
            if (!this.loggedIn.getOrDefault(playerId, false).booleanValue()) {
                String msg = this.languageManager.getMessage(playerId, "password.mustLogin", new Object[0]);
                player.m_213846_((Component)Component.m_237113_((String)msg).m_130940_(ChatFormatting.RED));
                this.showActionBar(player, msg);
                return 0;
            }
            String hashedOld = this.hashPassword(oldPassword);
            if (!this.playerPasswords.get(playerId).equals(hashedOld)) {
                String msg = this.languageManager.getMessage(playerId, "password.oldIncorrect", new Object[0]);
                player.m_213846_((Component)Component.m_237113_((String)msg).m_130940_(ChatFormatting.RED));
                this.showActionBar(player, msg);
                return 0;
            }
            String hashedNew = this.hashPassword(newPassword);
            this.playerPasswords.put(playerId, hashedNew);
            this.plainTextPasswords.put(playerId, newPassword);
            if (this.enableDatabase) {
                try {
                    try (Connection conn = DriverManager.getConnection(this.jdbcUrl);){
                        String sql = "UPDATE player_passwords SET password = ? WHERE uuid = ?";
                        try (PreparedStatement pstmt = conn.prepareStatement(sql);){
                            pstmt.setString(1, hashedNew);
                            pstmt.setString(2, playerId.toString());
                            pstmt.executeUpdate();
                        }
                    }
                    LOGGER.info("Password updated in database for player: " + String.valueOf(playerId));
                }
                catch (SQLException e) {
                    LOGGER.error("Failed to update password in database for player: " + String.valueOf(playerId), (Throwable)e);
                    player.m_213846_((Component)Component.m_237113_((String)"Failed to update password in database. Please contact an administrator.").m_130940_(ChatFormatting.RED));
                    return 0;
                }
            }
            this.savePasswordsToFile();
            String msg = this.languageManager.getMessage(playerId, "password.changed", new Object[0]);
            player.m_213846_((Component)Component.m_237113_((String)msg).m_130940_(ChatFormatting.GREEN));
            this.showActionBar(player, msg);
            return 1;
        }))));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"loadmin").requires(source -> source.m_6761_(2))).executes(context -> {
            ServerPlayer admin = ((CommandSourceStack)context.getSource()).m_81375_();
            this.openAdminGUI(admin);
            return 1;
        }));
    }

    public void openAdminGUI(ServerPlayer admin) {
        SimpleContainer container = new SimpleContainer(27);
        ItemStack book = new ItemStack((ItemLike)Items.f_42614_);
        CompoundTag bookTag = book.m_41784_();
        bookTag.m_128359_("CustomName", "{\"text\":\"\u00a76\u00a7lInfo\",\"bold\":true}");
        ListTag bookLore = new ListTag();
        bookLore.add((Object)StringTag.m_129297_((String)"{\"text\":\"\u00a77Click to view all players\"}"));
        bookLore.add((Object)StringTag.m_129297_((String)"{\"text\":\"\u00a77and their passwords\"}"));
        CompoundTag bookDisplay = new CompoundTag();
        bookDisplay.m_128365_("Lore", (Tag)bookLore);
        bookTag.m_128365_("display", (Tag)bookDisplay);
        bookTag.m_128359_("GUIAction", "ViewPlayers");
        book.m_41751_(bookTag);
        container.m_6836_(13, book);
        ItemStack barrier = new ItemStack((ItemLike)Items.f_42127_);
        CompoundTag barrierTag = barrier.m_41784_();
        barrierTag.m_128359_("CustomName", "{\"text\":\"\u00a7c\u00a7lDelete Player\",\"bold\":true}");
        ListTag barrierLore = new ListTag();
        barrierLore.add((Object)StringTag.m_129297_((String)"{\"text\":\"\u00a77Click to view players\"}"));
        barrierLore.add((Object)StringTag.m_129297_((String)"{\"text\":\"\u00a77and delete accounts\"}"));
        CompoundTag barrierDisplay = new CompoundTag();
        barrierDisplay.m_128365_("Lore", (Tag)barrierLore);
        barrierTag.m_128365_("display", (Tag)barrierDisplay);
        barrierTag.m_128359_("GUIAction", "DeletePlayers");
        barrier.m_41751_(barrierTag);
        container.m_6836_(11, barrier);
        admin.m_5893_((MenuProvider)new SimpleMenuProvider((id, playerInventory, player) -> new AdminGUIMenu(id, playerInventory, (Container)container, this), (Component)Component.m_237113_((String)"\u00a76\u00a7lAdmin Panel - Login System")));
    }

    public void openPlayersListGUI(ServerPlayer admin) {
        SimpleContainer container = new SimpleContainer(54);
        int slot = 0;
        for (UUID uuid : this.playerPasswords.keySet()) {
            if (slot >= 54) break;
            String playerName = this.getPlayerName(admin.m_20194_(), uuid);
            String password = this.plainTextPasswords.containsKey(uuid) ? this.plainTextPasswords.get(uuid) : this.playerPasswords.get(uuid);
            ItemStack playerHead = new ItemStack((ItemLike)Items.f_42680_);
            CompoundTag headTag = playerHead.m_41784_();
            headTag.m_128359_("CustomName", "{\"text\":\"\u00a7e" + playerName + "\",\"bold\":true}");
            ListTag lore = new ListTag();
            lore.add((Object)StringTag.m_129297_((String)("{\"text\":\"\u00a77UUID: \u00a7f" + uuid.toString() + "\"}")));
            lore.add((Object)StringTag.m_129297_((String)"{\"text\":\"\"}"));
            lore.add((Object)StringTag.m_129297_((String)("{\"text\":\"\u00a76Password: \u00a7a" + password + "\"}")));
            CompoundTag display = new CompoundTag();
            display.m_128365_("Lore", (Tag)lore);
            headTag.m_128365_("display", (Tag)display);
            CompoundTag skullOwner = new CompoundTag();
            skullOwner.m_128359_("Name", playerName);
            skullOwner.m_128359_("Id", uuid.toString());
            headTag.m_128365_("SkullOwner", (Tag)skullOwner);
            headTag.m_128359_("PlayerUUID", uuid.toString());
            playerHead.m_41751_(headTag);
            container.m_6836_(slot, playerHead);
            ++slot;
        }
        admin.m_5893_((MenuProvider)new SimpleMenuProvider((id, playerInventory, player) -> new AdminGUIMenu(id, playerInventory, (Container)container, this), (Component)Component.m_237113_((String)"\u00a76\u00a7lPlayers List - View Only")));
    }

    public void openDeletePlayersGUI(ServerPlayer admin) {
        SimpleContainer container = new SimpleContainer(54);
        int slot = 0;
        for (UUID uuid : this.playerPasswords.keySet()) {
            if (slot >= 54) break;
            String playerName = this.getPlayerName(admin.m_20194_(), uuid);
            String password = this.plainTextPasswords.containsKey(uuid) ? this.plainTextPasswords.get(uuid) : this.playerPasswords.get(uuid);
            ItemStack playerHead = new ItemStack((ItemLike)Items.f_42680_);
            CompoundTag headTag = playerHead.m_41784_();
            headTag.m_128359_("CustomName", "{\"text\":\"\u00a7c" + playerName + "\",\"bold\":true}");
            ListTag lore = new ListTag();
            lore.add((Object)StringTag.m_129297_((String)("{\"text\":\"\u00a77UUID: \u00a7f" + uuid.toString() + "\"}")));
            lore.add((Object)StringTag.m_129297_((String)"{\"text\":\"\"}"));
            lore.add((Object)StringTag.m_129297_((String)("{\"text\":\"\u00a76Password: \u00a7a" + password + "\"}")));
            lore.add((Object)StringTag.m_129297_((String)"{\"text\":\"\"}"));
            lore.add((Object)StringTag.m_129297_((String)"{\"text\":\"\u00a7c\u00a7lClick to DELETE this player\"}"));
            CompoundTag display = new CompoundTag();
            display.m_128365_("Lore", (Tag)lore);
            headTag.m_128365_("display", (Tag)display);
            CompoundTag skullOwner = new CompoundTag();
            skullOwner.m_128359_("Name", playerName);
            skullOwner.m_128359_("Id", uuid.toString());
            headTag.m_128365_("SkullOwner", (Tag)skullOwner);
            headTag.m_128359_("PlayerUUID", uuid.toString());
            headTag.m_128359_("GUIAction", "DeleteThisPlayer");
            playerHead.m_41751_(headTag);
            container.m_6836_(slot, playerHead);
            ++slot;
        }
        admin.m_5893_((MenuProvider)new SimpleMenuProvider((id, playerInventory, player) -> new AdminGUIMenu(id, playerInventory, (Container)container, this), (Component)Component.m_237113_((String)"\u00a7c\u00a7lDelete Players - Click to Remove")));
    }

    public String getPlayerName(MinecraftServer server, UUID uuid) {
        ServerPlayer player = server.m_6846_().m_11259_(uuid);
        if (player != null) {
            return player.m_7755_().getString();
        }
        try {
            GameProfile profile;
            GameProfileCache profileCache = server.m_129927_();
            if (profileCache != null && (profile = (GameProfile)profileCache.m_11002_(uuid).orElse(null)) != null) {
                return profile.getName();
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to get player name for UUID: " + String.valueOf(uuid));
        }
        return uuid.toString().substring(0, 8) + "...";
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer newPlayer = (ServerPlayer)event.getEntity();
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        UUID newPlayerUUID = newPlayer.m_20148_();
        for (ServerPlayer player : server.m_6846_().m_11314_()) {
            if (player == newPlayer || !player.m_20148_().equals(newPlayerUUID)) continue;
            if (!this.alreadyDisconnected.contains(newPlayerUUID)) {
                newPlayer.f_8906_.m_9942_((Component)Component.m_237113_((String)"A player with that name is already online.").m_130940_(ChatFormatting.RED));
                this.alreadyDisconnected.add(newPlayerUUID);
            }
            return;
        }
        this.originalPositions.put(newPlayerUUID, new double[]{newPlayer.m_20185_(), newPlayer.m_20186_(), newPlayer.m_20189_()});
        double waitingX = Double.parseDouble(this.config.getProperty("waitingAreaX", "0"));
        double waitingY = Double.parseDouble(this.config.getProperty("waitingAreaY", "100"));
        double waitingZ = Double.parseDouble(this.config.getProperty("waitingAreaZ", "0"));
        newPlayer.m_8999_((ServerLevel)newPlayer.m_20193_(), waitingX, waitingY, waitingZ, newPlayer.m_146908_(), newPlayer.m_146909_());
        this.loggedIn.put(newPlayerUUID, false);
        String promptMsg = this.languageManager.getMessage(newPlayerUUID, "login.prompt", new Object[0]);
        String promptSubtitle = this.languageManager.getMessage(newPlayerUUID, "login.promptSubtitle", new Object[0]);
        newPlayer.m_213846_((Component)Component.m_237113_((String)promptMsg).m_130940_(ChatFormatting.YELLOW));
        newPlayer.m_213846_((Component)Component.m_237113_((String)promptSubtitle).m_130940_(ChatFormatting.GRAY));
        this.showTitle(newPlayer, promptMsg, promptSubtitle);
        int timeout = Integer.parseInt(this.config.getProperty("loginTimeout", "60"));
        this.createLoginBossBar(newPlayer, timeout);
        if (Boolean.parseBoolean(this.config.getProperty("hideInventory", "true"))) {
            int containerSize = newPlayer.m_150109_().m_6643_();
            ItemStack[] savedItems = new ItemStack[containerSize];
            for (int i = 0; i < containerSize; ++i) {
                savedItems[i] = newPlayer.m_150109_().m_8020_(i).m_41777_();
            }
            this.savedInventories.put(newPlayerUUID, savedItems);
            newPlayer.m_150109_().m_6211_();
        }
        if (Boolean.parseBoolean(this.config.getProperty("applyBlindness", "true"))) {
            int duration = Integer.parseInt(this.config.getProperty("blindnessDuration", "40"));
            newPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19610_, duration, 0, false, false));
        }
        int timeoutMillis = timeout * 1000;
        new Thread(() -> {
            try {
                Thread.sleep(timeoutMillis);
                if (!this.loggedIn.getOrDefault(newPlayerUUID, false).booleanValue()) {
                    server.execute(() -> {
                        if (!this.alreadyDisconnected.contains(newPlayerUUID)) {
                            String kickMsg = this.languageManager.getMessage(newPlayerUUID, "timeout.kick", new Object[0]);
                            newPlayer.f_8906_.m_9942_((Component)Component.m_237113_((String)kickMsg).m_130940_(ChatFormatting.RED));
                            this.alreadyDisconnected.add(newPlayerUUID);
                        }
                    });
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }).start();
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        UUID playerId = event.getEntity().m_20148_();
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            this.removeBossBar(player2);
        }
        if (this.loggedIn.getOrDefault(playerId, false).booleanValue()) {
            this.originalPositions.remove(playerId);
        }
        this.loggedIn.remove(playerId);
        this.alreadyDisconnected.remove(playerId);
        this.savedInventories.remove(playerId);
        this.languageManager.removePlayer(playerId);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        System.out.println("LoginSystem: Server is starting, loading passwords...");
        if (this.enableDatabase) {
            try {
                this.loadPasswordsFromDB();
                System.out.println("LoginSystem: Successfully loaded " + this.playerPasswords.size() + " passwords from database.");
            }
            catch (Exception e) {
                System.err.println("LoginSystem: Failed to load passwords from database!");
                e.printStackTrace();
                throw new RuntimeException("Failed to load passwords from database", e);
            }
        } else {
            this.loadPasswordsFromFile();
            System.out.println("LoginSystem: Successfully loaded " + this.playerPasswords.size() + " passwords from file.");
        }
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        System.out.println("LoginSystem: Server is stopping, saving passwords...");
        if (this.enableDatabase) {
            try {
                System.out.println("LoginSystem: Saving " + this.playerPasswords.size() + " passwords to database...");
                this.saveAllPasswordsToDB();
                System.out.println("LoginSystem: All passwords saved successfully to database!");
            }
            catch (Exception e) {
                System.err.println("LoginSystem: Failed to save to database!");
                e.printStackTrace();
                throw new RuntimeException("Failed to save passwords to database", e);
            }
        } else {
            this.savePasswordsToFile();
            System.out.println("LoginSystem: Saved " + this.playerPasswords.size() + " passwords to file.");
        }
    }

    private void saveAllPasswordsToDB() {
        if (!this.enableDatabase || this.playerPasswords.isEmpty()) {
            LOGGER.debug("Skipping database save - database disabled or no passwords to save");
            return;
        }
        int totalPasswords = this.playerPasswords.size();
        LOGGER.info("Saving {} passwords to database...", (Object)totalPasswords);
        long startTime = System.currentTimeMillis();
        try (Connection conn = DriverManager.getConnection(this.jdbcUrl);){
            conn.setAutoCommit(false);
            String sql = "INSERT INTO player_passwords (uuid, password, last_login)\nVALUES (?, ?, CURRENT_TIMESTAMP)\nON DUPLICATE KEY UPDATE\n    password = VALUES(password),\n    last_login = CURRENT_TIMESTAMP\n";
            try (PreparedStatement pstmt = conn.prepareStatement(sql);){
                int processedCount = 0;
                int batchSize = 100;
                for (Map.Entry<UUID, String> entry : this.playerPasswords.entrySet()) {
                    pstmt.setString(1, entry.getKey().toString());
                    pstmt.setString(2, entry.getValue());
                    pstmt.addBatch();
                    if (++processedCount % batchSize != 0) continue;
                    int[] updateCounts = pstmt.executeBatch();
                    LOGGER.debug("Processed batch of {} updates", (Object)updateCounts.length);
                }
                int[] updateCounts = pstmt.executeBatch();
                LOGGER.debug("Processed final batch of {} updates", (Object)updateCounts.length);
                conn.commit();
                long duration = System.currentTimeMillis() - startTime;
                LOGGER.info("Successfully saved {} passwords to database in {} ms", (Object)totalPasswords, (Object)duration);
            }
            catch (SQLException e) {
                try {
                    conn.rollback();
                }
                catch (SQLException ex) {
                    LOGGER.error("Error during transaction rollback", (Throwable)ex);
                }
                LOGGER.error("Failed to save passwords to database", (Throwable)e);
                throw new RuntimeException("Failed to save passwords to database", e);
            }
        }
        catch (SQLException e) {
            LOGGER.error("Failed to save passwords to database!", (Throwable)e);
            throw new RuntimeException("Failed to save passwords to database", e);
        }
    }

    @SubscribeEvent
    public void onPlayerDropItem(ItemTossEvent event) {
        ServerPlayer player = (ServerPlayer)event.getPlayer();
        UUID playerId = player.m_20148_();
        if (!this.loggedIn.getOrDefault(playerId, false).booleanValue()) {
            event.setCanceled(true);
            ItemStack droppedItem = event.getEntity().m_32055_().m_41777_();
            boolean added = player.m_150109_().m_36054_(droppedItem);
            player.m_150109_().m_6596_();
            if (!added) {
                player.m_213846_((Component)Component.m_237113_((String)"Your inventory is full, so the item couldn't be returned.").m_130940_(ChatFormatting.RED));
            } else {
                String msg = this.languageManager.getMessage(playerId, "restrict.drop", new Object[0]);
                player.m_213846_((Component)Component.m_237113_((String)msg).m_130940_(ChatFormatting.YELLOW));
                this.showActionBar(player, msg);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerHurt(LivingHurtEvent event) {
        ServerPlayer player;
        UUID playerId;
        if (event.getEntity() instanceof ServerPlayer && !this.loggedIn.getOrDefault(playerId = (player = (ServerPlayer)event.getEntity()).m_20148_(), false).booleanValue()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        ServerPlayer player;
        UUID playerId;
        if (event.getPlayer() instanceof ServerPlayer && !this.loggedIn.getOrDefault(playerId = (player = (ServerPlayer)event.getPlayer()).m_20148_(), false).booleanValue()) {
            event.setCanceled(true);
            ((ServerLevel)event.getLevel()).m_7731_(event.getPos(), event.getState(), 3);
            String msg = this.languageManager.getMessage(playerId, "restrict.break", new Object[0]);
            player.m_213846_((Component)Component.m_237113_((String)msg).m_130940_(ChatFormatting.RED));
            this.showActionBar(player, msg);
        }
    }

    @SubscribeEvent
    public void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        ServerPlayer player;
        UUID playerId;
        if (event.getEntity() instanceof ServerPlayer && !this.loggedIn.getOrDefault(playerId = (player = (ServerPlayer)event.getEntity()).m_20148_(), false).booleanValue()) {
            event.setCanceled(true);
            String msg = this.languageManager.getMessage(playerId, "restrict.place", new Object[0]);
            player.m_213846_((Component)Component.m_237113_((String)msg).m_130940_(ChatFormatting.RED));
            this.showActionBar(player, msg);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        ServerPlayer player;
        UUID playerId;
        if (event.getEntity() instanceof ServerPlayer && !this.loggedIn.getOrDefault(playerId = (player = (ServerPlayer)event.getEntity()).m_20148_(), false).booleanValue()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onAttackEntity(AttackEntityEvent event) {
        ServerPlayer player;
        UUID playerId;
        if (event.getEntity() instanceof ServerPlayer && !this.loggedIn.getOrDefault(playerId = (player = (ServerPlayer)event.getEntity()).m_20148_(), false).booleanValue()) {
            event.setCanceled(true);
            String msg = this.languageManager.getMessage(playerId, "restrict.attack", new Object[0]);
            player.m_213846_((Component)Component.m_237113_((String)msg).m_130940_(ChatFormatting.RED));
            this.showActionBar(player, msg);
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        ServerPlayer player;
        UUID playerId;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof ServerPlayer && !this.loggedIn.getOrDefault(playerId = (player = (ServerPlayer)entity).m_20148_(), false).booleanValue()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onItemPickup(EntityItemPickupEvent event) {
        ServerPlayer player;
        UUID playerId;
        if (event.getEntity() instanceof ServerPlayer && !this.loggedIn.getOrDefault(playerId = (player = (ServerPlayer)event.getEntity()).m_20148_(), false).booleanValue()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onChat(ServerChatEvent event) {
        ServerPlayer player = event.getPlayer();
        UUID playerId = player.m_20148_();
        if (!this.loggedIn.getOrDefault(playerId, false).booleanValue()) {
            event.setCanceled(true);
            String msg = this.languageManager.getMessage(playerId, "restrict.chat", new Object[0]);
            player.m_213846_((Component)Component.m_237113_((String)msg).m_130940_(ChatFormatting.RED));
            this.showActionBar(player, msg);
        }
    }

    @SubscribeEvent
    public void onCommand(CommandEvent event) {
        String commandInput;
        ServerPlayer player;
        UUID playerId;
        Entity entity = ((CommandSourceStack)event.getParseResults().getContext().getSource()).m_81373_();
        if (entity instanceof ServerPlayer && !this.loggedIn.getOrDefault(playerId = (player = (ServerPlayer)entity).m_20148_(), false).booleanValue() && !(commandInput = event.getParseResults().getReader().getString().toLowerCase()).startsWith("register") && !commandInput.startsWith("login")) {
            event.setCanceled(true);
            String msg = this.languageManager.getMessage(playerId, "restrict.command", new Object[0]);
            player.m_213846_((Component)Component.m_237113_((String)msg).m_130940_(ChatFormatting.RED));
            this.showActionBar(player, msg);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ServerPlayer player;
        UUID playerId;
        if (!event.player.m_20193_().m_5776_() && event.phase == TickEvent.Phase.END && !this.loggedIn.getOrDefault(playerId = (player = (ServerPlayer)event.player).m_20148_(), false).booleanValue()) {
            double dz;
            double dy;
            double waitingX = Double.parseDouble(this.config.getProperty("waitingAreaX", "0"));
            double waitingY = Double.parseDouble(this.config.getProperty("waitingAreaY", "100"));
            double waitingZ = Double.parseDouble(this.config.getProperty("waitingAreaZ", "0"));
            double dx = player.m_20185_() - waitingX;
            if (dx * dx + (dy = player.m_20186_() - waitingY) * dy + (dz = player.m_20189_() - waitingZ) * dz > 1.0) {
                player.m_8999_((ServerLevel)player.m_20193_(), waitingX, waitingY, waitingZ, player.m_146908_(), player.m_146909_());
                String msg = this.languageManager.getMessage(playerId, "restrict.move", new Object[0]);
                this.showActionBar(player, msg);
            }
            if (Boolean.parseBoolean(this.config.getProperty("applyBlindness", "true")) && !player.m_21023_(MobEffects.f_19610_)) {
                int duration = Integer.parseInt(this.config.getProperty("blindnessDuration", "40"));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, duration, 0, false, false));
            }
        }
    }
}

