/*
 * Decompiled with CFR 0.152.
 */
package com.example.loginsystem;

import com.example.loginsystem.AdminGUIMenu;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1271;
import net.minecraft.class_1277;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_747;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LoginSystem
implements ModInitializer {
    public static final Logger LOGGER = LogManager.getLogger();
    private final HashMap<UUID, String> playerPasswords = new HashMap();
    private final HashMap<UUID, Boolean> loggedIn = new HashMap();
    private final HashMap<UUID, double[]> originalPositions = new HashMap();
    private final HashSet<UUID> alreadyDisconnected = new HashSet();
    private final HashMap<UUID, class_1799[]> savedInventories = new HashMap();
    private final Properties config = new Properties();
    private final File configFile = new File("config/loginsystem.properties");
    private final File passwordFile = new File("config/passwords.txt");
    private boolean enableDatabase;
    private String jdbcUrl;
    private String dbHost;
    private String dbPort;
    private String dbName;
    private String dbUsername;
    private String dbPassword;
    private final HashMap<UUID, String> plainTextPasswords = new HashMap();

    public boolean isEnableDatabase() {
        return this.enableDatabase;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getPasswordForPlayer(UUID uuid) {
        if (this.plainTextPasswords.containsKey(uuid)) {
            return this.plainTextPasswords.get(uuid);
        }
        return this.playerPasswords.get(uuid);
    }

    public void removePlayerPassword(UUID uuid) {
        this.playerPasswords.remove(uuid);
        this.plainTextPasswords.remove(uuid);
    }

    public boolean hasPlayerPassword(UUID uuid) {
        return this.playerPasswords.containsKey(uuid);
    }

    public void savePasswordsToFile() {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.passwordFile));){
            int count = 0;
            for (UUID uuid : this.playerPasswords.keySet()) {
                writer.write(uuid.toString() + ":" + this.playerPasswords.get(uuid));
                writer.newLine();
                ++count;
            }
            System.out.println("LoginSystem: Saved " + count + " passwords to file.");
        }
        catch (IOException e) {
            System.err.println("LoginSystem: Error writing password file!");
            e.printStackTrace();
        }
    }

    public String getPlayerName(MinecraftServer server, UUID uuid) {
        for (class_3222 player : server.method_3760().method_14571()) {
            if (!player.method_5667().equals(uuid)) continue;
            return player.method_5477().getString();
        }
        return uuid.toString();
    }

    public void openAdminGUI(class_3222 admin) {
        class_1277 container = new class_1277(27);
        class_1799 book = new class_1799((class_1935)class_1802.field_8674);
        class_2487 bookTag = book.method_7948();
        bookTag.method_10582("CustomName", "{\"text\":\"\u00a76\u00a7lInfo\",\"bold\":true}");
        class_2499 bookLore = new class_2499();
        bookLore.add((Object)class_2519.method_23256((String)"{\"text\":\"\u00a77Click to view all players\"}"));
        bookLore.add((Object)class_2519.method_23256((String)"{\"text\":\"\u00a77and their passwords\"}"));
        class_2487 bookDisplay = new class_2487();
        bookDisplay.method_10566("Lore", (class_2520)bookLore);
        bookTag.method_10566("display", (class_2520)bookDisplay);
        bookTag.method_10582("GUIAction", "ViewPlayers");
        book.method_7980(bookTag);
        container.method_5447(13, book);
        class_1799 barrier = new class_1799((class_1935)class_1802.field_8077);
        class_2487 barrierTag = barrier.method_7948();
        barrierTag.method_10582("CustomName", "{\"text\":\"\u00a7c\u00a7lDelete Player\",\"bold\":true}");
        class_2499 barrierLore = new class_2499();
        barrierLore.add((Object)class_2519.method_23256((String)"{\"text\":\"\u00a77Click to view players\"}"));
        barrierLore.add((Object)class_2519.method_23256((String)"{\"text\":\"\u00a77and delete accounts\"}"));
        class_2487 barrierDisplay = new class_2487();
        barrierDisplay.method_10566("Lore", (class_2520)barrierLore);
        barrierTag.method_10566("display", (class_2520)barrierDisplay);
        barrierTag.method_10582("GUIAction", "DeletePlayers");
        barrier.method_7980(barrierTag);
        container.method_5447(11, barrier);
        admin.method_17355((class_3908)new class_747((syncId, playerInventory, player) -> new AdminGUIMenu(syncId, playerInventory, (class_1263)container, this), (class_2561)class_2561.method_43470((String)"\u00a76\u00a7lAdmin Panel")));
    }

    public void openPlayersListGUI(class_3222 admin) {
        class_1277 container = new class_1277(54);
        int slot = 0;
        for (UUID uuid : this.playerPasswords.keySet()) {
            if (slot >= 54) break;
            String playerName = this.getPlayerName(admin.method_5682(), uuid);
            String password = this.plainTextPasswords.containsKey(uuid) ? this.plainTextPasswords.get(uuid) : this.playerPasswords.get(uuid);
            class_1799 playerHead = new class_1799((class_1935)class_1802.field_8575);
            class_2487 headTag = playerHead.method_7948();
            headTag.method_10582("CustomName", "{\"text\":\"\u00a7e" + playerName + "\",\"bold\":true}");
            class_2499 lore = new class_2499();
            lore.add((Object)class_2519.method_23256((String)("{\"text\":\"\u00a77UUID: \u00a7f" + uuid.toString() + "\"}")));
            lore.add((Object)class_2519.method_23256((String)"{\"text\":\"\"}"));
            lore.add((Object)class_2519.method_23256((String)("{\"text\":\"\u00a76Password: \u00a7a" + password + "\"}")));
            class_2487 display = new class_2487();
            display.method_10566("Lore", (class_2520)lore);
            headTag.method_10566("display", (class_2520)display);
            class_2487 skullOwner = new class_2487();
            skullOwner.method_10582("Name", playerName);
            skullOwner.method_10582("Id", uuid.toString());
            headTag.method_10566("SkullOwner", (class_2520)skullOwner);
            headTag.method_10582("PlayerUUID", uuid.toString());
            playerHead.method_7980(headTag);
            container.method_5447(slot++, playerHead);
        }
        admin.method_17355((class_3908)new class_747((syncId, playerInventory, player) -> new AdminGUIMenu(syncId, playerInventory, (class_1263)container, this), (class_2561)class_2561.method_43470((String)"\u00a76Players List - View Only")));
    }

    public void openDeletePlayersGUI(class_3222 admin) {
        class_1277 container = new class_1277(54);
        int slot = 0;
        for (UUID uuid : this.playerPasswords.keySet()) {
            if (slot >= 54) break;
            String playerName = this.getPlayerName(admin.method_5682(), uuid);
            String password = this.plainTextPasswords.containsKey(uuid) ? this.plainTextPasswords.get(uuid) : this.playerPasswords.get(uuid);
            class_1799 playerHead = new class_1799((class_1935)class_1802.field_8575);
            class_2487 headTag = playerHead.method_7948();
            headTag.method_10582("CustomName", "{\"text\":\"\u00a7c" + playerName + "\",\"bold\":true}");
            class_2499 lore = new class_2499();
            lore.add((Object)class_2519.method_23256((String)("{\"text\":\"\u00a77UUID: \u00a7f" + uuid.toString() + "\"}")));
            lore.add((Object)class_2519.method_23256((String)"{\"text\":\"\"}"));
            lore.add((Object)class_2519.method_23256((String)("{\"text\":\"\u00a76Password: \u00a7a" + password + "\"}")));
            lore.add((Object)class_2519.method_23256((String)"{\"text\":\"\"}"));
            lore.add((Object)class_2519.method_23256((String)"{\"text\":\"\u00a7c\u00a7lClick to DELETE this player\"}"));
            class_2487 display = new class_2487();
            display.method_10566("Lore", (class_2520)lore);
            headTag.method_10566("display", (class_2520)display);
            class_2487 skullOwner = new class_2487();
            skullOwner.method_10582("Name", playerName);
            skullOwner.method_10582("Id", uuid.toString());
            headTag.method_10566("SkullOwner", (class_2520)skullOwner);
            headTag.method_10582("PlayerUUID", uuid.toString());
            headTag.method_10582("GUIAction", "DeleteThisPlayer");
            playerHead.method_7980(headTag);
            container.method_5447(slot++, playerHead);
        }
        admin.method_17355((class_3908)new class_747((syncId, playerInventory, player) -> new AdminGUIMenu(syncId, playerInventory, (class_1263)container, this), (class_2561)class_2561.method_43470((String)"\u00a7c\u00a7lDelete Players")));
    }

    public void onInitialize() {
        block18: {
            LOGGER.info("Login System Mod is initializing...");
            this.loadConfig();
            this.enableDatabase = Boolean.parseBoolean(this.config.getProperty("enableDatabase", "false"));
            if (!this.enableDatabase) {
                LOGGER.info("\ud83d\udcbe Database is DISABLED in configuration - using file storage");
            } else {
                LOGGER.info("\ud83d\uddc3\ufe0f Database is ENABLED - embedded JDBC drivers available");
            }
            if (this.enableDatabase) {
                LOGGER.info("Attempting to initialize database connection...");
                try {
                    boolean driverLoaded = false;
                    String originalJdbcUrl = this.jdbcUrl;
                    try {
                        Class.forName("com.mysql.cj.jdbc.Driver");
                        LOGGER.info("\u2705 MySQL JDBC driver loaded successfully (embedded)");
                        this.jdbcUrl = originalJdbcUrl;
                        driverLoaded = true;
                    }
                    catch (ClassNotFoundException e) {
                        LOGGER.warn("\u26a0\ufe0f MySQL JDBC driver not found, trying MariaDB driver...");
                        try {
                            Class.forName("org.mariadb.jdbc.Driver");
                            LOGGER.info("\u2705 MariaDB JDBC driver loaded successfully (embedded)");
                            this.jdbcUrl = this.jdbcUrl.replace("jdbc:mysql://", "jdbc:mariadb://");
                            driverLoaded = true;
                        }
                        catch (ClassNotFoundException ex) {
                            LOGGER.error("\u274c Neither MySQL nor MariaDB JDBC driver found in the classpath!");
                            throw new RuntimeException("No compatible JDBC driver found. Please check your dependencies.", ex);
                        }
                    }
                    if (!driverLoaded) break block18;
                    try (Connection testConn = DriverManager.getConnection(this.jdbcUrl);){
                        if (testConn.isValid(5)) {
                            this.initDatabase();
                            this.loadPasswordsFromDB();
                            LOGGER.info("\u2705 Successfully connected to database: " + this.dbName);
                        }
                    }
                }
                catch (SQLException e) {
                    LOGGER.error("\u274c Failed to connect to MySQL database: " + e.getMessage());
                    LOGGER.error("Please check your database configuration in config/loginsystem.properties");
                    LOGGER.error("Falling back to file storage");
                    this.enableDatabase = false;
                    this.loadPasswordsFromFile();
                }
                catch (Exception e) {
                    LOGGER.error("\u274c Failed to initialize database: " + e.getMessage());
                    LOGGER.error("Falling back to file storage");
                    this.enableDatabase = false;
                    this.loadPasswordsFromFile();
                }
            } else {
                LOGGER.info("Using file-based storage (database disabled in config)");
                this.loadPasswordsFromFile();
            }
        }
        this.registerEventHandlers();
        LOGGER.info("Login System Mod initialized successfully!");
    }

    private void registerEventHandlers() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> this.registerCommands((CommandDispatcher<class_2168>)dispatcher));
        ServerLifecycleEvents.SERVER_STARTING.register(this::onServerStarting);
        ServerLifecycleEvents.SERVER_STOPPING.register(this::onServerStopping);
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> this.onPlayerLogin(handler.method_32311()));
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> this.onPlayerLogout(handler.method_32311()));
        ServerTickEvents.END_SERVER_TICK.register(this::onServerTick);
        PlayerBlockBreakEvents.BEFORE.register((world, player, pos, state, blockEntity) -> {
            class_3222 serverPlayer;
            UUID playerId;
            if (player instanceof class_3222 && !this.loggedIn.getOrDefault(playerId = (serverPlayer = (class_3222)player).method_5667(), false).booleanValue()) {
                serverPlayer.method_43496((class_2561)class_2561.method_43470((String)"You must be logged in to break blocks!").method_27692(class_124.field_1061));
                return false;
            }
            return true;
        });
        UseItemCallback.EVENT.register((player, world, hand) -> {
            if (player instanceof class_3222) {
                UUID playerId;
                class_3222 serverPlayer = (class_3222)player;
                if (!world.method_8608() && !this.loggedIn.getOrDefault(playerId = serverPlayer.method_5667(), false).booleanValue()) {
                    return class_1271.method_22431((Object)player.method_5998(hand));
                }
            }
            return class_1271.method_22430((Object)player.method_5998(hand));
        });
        ServerLivingEntityEvents.ALLOW_DAMAGE.register((entity, damageSource, amount) -> {
            class_3222 player;
            UUID playerId;
            return !(entity instanceof class_3222) || this.loggedIn.getOrDefault(playerId = (player = (class_3222)entity).method_5667(), false) != false;
        });
    }

    private void loadConfig() {
        File configDir = new File("config");
        if (!configDir.exists()) {
            configDir.mkdir();
        }
        if (!this.configFile.exists()) {
            String configContent = "# \ud83d\ude80 Login System Mod Configuration File \ud83d\ude80\n# This file contains configuration settings for the Login System mod.\n# Adjust the values below according to your server's needs.\n\n# ----------------------------\n# General Settings\n# ----------------------------\n# Maximum time (in seconds) a player can remain in the waiting area before being disconnected.\nloginTimeout=60\n\n# ----------------------------\n# Messages\n# ----------------------------\n# Message when registration is successful.\nmessage.registerSuccess=Registration successful! \ud83c\udf89\n# Message when login is successful.\nmessage.loginSuccess=Login successful! \u2705\n# Message for incorrect password.\nmessage.incorrectPassword=Incorrect password! \u274c\n# Message when a player tries to login without registering.\nmessage.notRegistered=You are not registered! Use /register first. \u26a0\ufe0f\n# Message when a player attempts to register again.\nmessage.alreadyRegistered=You are already registered! \u26a0\ufe0f\n# Message when a player is kicked for timeout.\nmessage.kickTimeout=You were kicked for not logging in! \u23f0\n\n# ----------------------------\n# Visual Effects & Inventory Control\n# ----------------------------\n# If true, applies a blindness effect to unlogged players.\napplyBlindness=true\n# Duration (in ticks) for the blindness effect (20 ticks = 1 second).\nblindnessDuration=40\n# If true, the player's inventory will be hidden until they log in.\nhideInventory=true\n\n# ----------------------------\n# Database Settings\n# ----------------------------\n# If true, the mod uses MySQL database to store passwords. If false, a local file is used.\nenableDatabase=false\n# Database host (use 127.0.0.1 instead of localhost)\ndatabase.host=127.0.0.1\n# Database port\ndatabase.port=3306\n# Database name\ndatabase.name=loginsystem\n# Database username\ndatabase.username=root\n# Database password\ndatabase.password=your_password\n# Additional MySQL settings\ndatabase.allowPublicKeyRetrieval=true\ndatabase.useSSL=false\ndatabase.autoReconnect=true\ndatabase.maxReconnects=3\n\n# ----------------------------\n# Waiting Area Settings\n# ----------------------------\n# Coordinates for the waiting area where unlogged players will be teleported.\nwaitingAreaX=0\nwaitingAreaY=100\nwaitingAreaZ=0\n";
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.configFile));){
                writer.write(configContent);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try (FileInputStream in = new FileInputStream(this.configFile);){
            this.config.load(in);
            this.enableDatabase = Boolean.parseBoolean(this.config.getProperty("enableDatabase", "false"));
            this.dbHost = this.config.getProperty("database.host", "127.0.0.1");
            this.dbPort = this.config.getProperty("database.port", "3306");
            this.dbName = this.config.getProperty("database.name", "loginsystem");
            this.dbUsername = this.config.getProperty("database.username", "root");
            this.dbPassword = this.config.getProperty("database.password", "");
            LOGGER.info("\ud83d\udd0d Configuration loaded from: " + this.configFile.getAbsolutePath());
            LOGGER.info("\ud83d\udd0d enableDatabase = " + this.enableDatabase);
            LOGGER.info("\ud83d\udd0d database.host = " + this.dbHost);
            LOGGER.info("\ud83d\udd0d database.username = " + this.dbUsername);
            LOGGER.info("\ud83d\udd0d database.name = " + this.dbName);
            String encodedUsername = URLEncoder.encode(this.dbUsername, StandardCharsets.UTF_8.toString());
            String encodedPassword = URLEncoder.encode(this.dbPassword, StandardCharsets.UTF_8.toString());
            this.jdbcUrl = String.format("jdbc:mysql://%s:%s/%s?user=%s&password=%s&allowPublicKeyRetrieval=%s&useSSL=%s&autoReconnect=%s&maxReconnects=%s", this.dbHost, this.dbPort, this.dbName, encodedUsername, encodedPassword, this.config.getProperty("database.allowPublicKeyRetrieval", "true"), this.config.getProperty("database.useSSL", "false"), this.config.getProperty("database.autoReconnect", "true"), this.config.getProperty("database.maxReconnects", "3"));
            LOGGER.info("Database configuration loaded successfully");
            if (this.enableDatabase) {
                LOGGER.info("Database connection URL: " + this.jdbcUrl.replace(encodedPassword, "******"));
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to load configuration file", (Throwable)e);
            e.printStackTrace();
        }
    }

    private void initDatabase() {
        try (Connection conn = DriverManager.getConnection(this.jdbcUrl);){
            try (Statement stmt = conn.createStatement();){
                stmt.execute("CREATE TABLE IF NOT EXISTS player_passwords (\n    uuid VARCHAR(36) PRIMARY KEY,\n    password TEXT NOT NULL,\n    plain_password TEXT,\n    last_login TIMESTAMP DEFAULT CURRENT_TIMESTAMP\n) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");
                LOGGER.info("Table created or already exists: player_passwords");
                try {
                    stmt.execute("ALTER TABLE player_passwords ADD COLUMN IF NOT EXISTS last_login TIMESTAMP DEFAULT CURRENT_TIMESTAMP");
                }
                catch (SQLException e) {
                    LOGGER.debug("Column last_login already exists: " + e.getMessage());
                }
                try {
                    stmt.execute("ALTER TABLE player_passwords ADD COLUMN IF NOT EXISTS plain_password TEXT");
                    LOGGER.info("Added plain_password column for storing original passwords");
                }
                catch (SQLException e) {
                    LOGGER.debug("Column plain_password already exists: " + e.getMessage());
                }
            }
            LOGGER.info("Database initialized successfully!");
        }
        catch (SQLException e) {
            LOGGER.error("Database error while initializing!", (Throwable)e);
            throw new RuntimeException("Failed to initialize database", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadPasswordsFromDB() {
        int count = 0;
        this.playerPasswords.clear();
        this.plainTextPasswords.clear();
        String sql = "SELECT uuid, password, plain_password FROM player_passwords";
        try (Connection conn = DriverManager.getConnection(this.jdbcUrl);
             Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            while (rs.next()) {
                try {
                    String uuidStr = rs.getString("uuid");
                    String password = rs.getString("password");
                    String plainPassword = rs.getString("plain_password");
                    if (uuidStr == null || password == null || password.trim().isEmpty()) continue;
                    UUID uuid = UUID.fromString(uuidStr);
                    this.playerPasswords.put(uuid, password.trim());
                    if (plainPassword != null && !plainPassword.trim().isEmpty()) {
                        this.plainTextPasswords.put(uuid, plainPassword.trim());
                    }
                    ++count;
                }
                catch (IllegalArgumentException e) {
                    LOGGER.warn("Skipping invalid UUID in database: " + rs.getString("uuid"));
                }
            }
            LOGGER.info("Successfully loaded " + count + " passwords from database");
            return;
        }
        catch (SQLException e) {
            LOGGER.error("Failed to load passwords from database", (Throwable)e);
            throw new RuntimeException("Failed to load passwords from database", e);
        }
    }

    private void savePasswordToDB(UUID uuid, String hashedPassword) {
        if (!this.enableDatabase) {
            return;
        }
        if (hashedPassword == null || hashedPassword.trim().isEmpty()) {
            LOGGER.warn("Attempted to save empty password for UUID: " + String.valueOf(uuid));
            return;
        }
        String plainPassword = this.plainTextPasswords.get(uuid);
        String sql = "INSERT INTO player_passwords (uuid, password, plain_password, last_login)\nVALUES (?, ?, ?, CURRENT_TIMESTAMP)\nON DUPLICATE KEY UPDATE\n    password = VALUES(password),\n    plain_password = VALUES(plain_password),\n    last_login = CURRENT_TIMESTAMP\n";
        try (Connection conn = DriverManager.getConnection(this.jdbcUrl);
             PreparedStatement pstmt = conn.prepareStatement(sql);){
            pstmt.setString(1, uuid.toString());
            pstmt.setString(2, hashedPassword.trim());
            pstmt.setString(3, plainPassword);
            int affectedRows = pstmt.executeUpdate();
            LOGGER.debug("Saved password for UUID: {} ({} rows affected)", (Object)uuid, (Object)affectedRows);
        }
        catch (SQLException e) {
            LOGGER.error("Failed to save password for UUID: " + String.valueOf(uuid), (Throwable)e);
            throw new RuntimeException("Failed to save password to database", e);
        }
    }

    private void loadPasswordsFromFile() {
        if (!this.passwordFile.exists()) {
            System.out.println("LoginSystem: No password file found, starting fresh.");
            return;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(this.passwordFile));){
            String line;
            this.playerPasswords.clear();
            int count = 0;
            while ((line = reader.readLine()) != null) {
                String[] parts = line.split(":");
                if (parts.length != 2) continue;
                this.playerPasswords.put(UUID.fromString(parts[0]), parts[1]);
                ++count;
            }
            System.out.println("LoginSystem: Loaded " + count + " passwords from file.");
        }
        catch (IOException e) {
            System.err.println("LoginSystem: Error reading password file!");
            e.printStackTrace();
        }
    }

    private String hashPassword(String password) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] encodedHash = digest.digest(password.getBytes(StandardCharsets.UTF_8));
            StringBuilder hexString = new StringBuilder();
            for (byte b : encodedHash) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-256 algorithm not found!", e);
        }
    }

    private void restoreInventory(class_3222 player) {
        UUID playerId = player.method_5667();
        if (this.savedInventories.containsKey(playerId)) {
            class_1799[] items = this.savedInventories.get(playerId);
            for (int i = 0; i < items.length; ++i) {
                player.method_31548().method_5447(i, items[i]);
            }
            this.savedInventories.remove(playerId);
            player.method_31548().method_5431();
        }
    }

    private void removeBlindness(class_3222 player) {
        player.method_6016(class_1294.field_5919);
    }

    private void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"register").then(class_2170.method_9244((String)"password", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"confirmPassword", (ArgumentType)StringArgumentType.string()).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            UUID playerId = player.method_5667();
            String password = StringArgumentType.getString((CommandContext)context, (String)"password");
            String confirmPassword = StringArgumentType.getString((CommandContext)context, (String)"confirmPassword");
            if (this.playerPasswords.containsKey(playerId)) {
                player.method_43496((class_2561)class_2561.method_43470((String)this.config.getProperty("message.alreadyRegistered")).method_27692(class_124.field_1061));
                return 0;
            }
            if (!password.equals(confirmPassword)) {
                player.method_43496((class_2561)class_2561.method_43470((String)"Passwords do not match!").method_27692(class_124.field_1061));
                return 0;
            }
            String hashedPassword = this.hashPassword(password);
            this.playerPasswords.put(playerId, hashedPassword);
            this.plainTextPasswords.put(playerId, password);
            if (this.enableDatabase) {
                this.savePasswordToDB(playerId, hashedPassword);
            } else {
                this.savePasswordsToFile();
            }
            this.loggedIn.put(playerId, true);
            player.method_5875(false);
            this.restoreInventory(player);
            this.removeBlindness(player);
            if (this.originalPositions.containsKey(playerId)) {
                double[] orig = this.originalPositions.get(playerId);
                player.method_14251(player.method_5671().method_9225(), orig[0], orig[1], orig[2], player.method_36454(), player.method_36455());
                this.originalPositions.remove(playerId);
            }
            player.method_43496((class_2561)class_2561.method_43470((String)this.config.getProperty("message.registerSuccess")).method_27692(class_124.field_1060));
            return 1;
        }))));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"login").then(class_2170.method_9244((String)"password", (ArgumentType)StringArgumentType.string()).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            UUID playerId = player.method_5667();
            if (this.loggedIn.getOrDefault(playerId, false).booleanValue()) {
                player.method_43496((class_2561)class_2561.method_43470((String)"You are already logged in!").method_27692(class_124.field_1061));
                return 0;
            }
            if (!this.playerPasswords.containsKey(playerId)) {
                player.method_43496((class_2561)class_2561.method_43470((String)this.config.getProperty("message.notRegistered")).method_27692(class_124.field_1061));
                return 0;
            }
            String password = StringArgumentType.getString((CommandContext)context, (String)"password");
            String hashedPassword = this.hashPassword(password);
            if (!this.playerPasswords.get(playerId).equals(hashedPassword)) {
                player.method_43496((class_2561)class_2561.method_43470((String)"Incorrect password!").method_27692(class_124.field_1061));
                return 0;
            }
            this.loggedIn.put(playerId, true);
            player.method_5875(false);
            this.restoreInventory(player);
            this.removeBlindness(player);
            if (this.originalPositions.containsKey(playerId)) {
                double[] orig = this.originalPositions.get(playerId);
                player.method_14251(player.method_5671().method_9225(), orig[0], orig[1], orig[2], player.method_36454(), player.method_36455());
                this.originalPositions.remove(playerId);
            }
            player.method_43496((class_2561)class_2561.method_43470((String)this.config.getProperty("message.loginSuccess")).method_27692(class_124.field_1060));
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"changepassword").then(class_2170.method_9244((String)"oldPassword", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"newPassword", (ArgumentType)StringArgumentType.string()).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            UUID playerId = player.method_5667();
            String oldPassword = StringArgumentType.getString((CommandContext)context, (String)"oldPassword");
            String newPassword = StringArgumentType.getString((CommandContext)context, (String)"newPassword");
            if (!this.loggedIn.getOrDefault(playerId, false).booleanValue()) {
                player.method_43496((class_2561)class_2561.method_43470((String)"You must be logged in to change your password.").method_27692(class_124.field_1061));
                return 0;
            }
            String hashedOld = this.hashPassword(oldPassword);
            if (!this.playerPasswords.get(playerId).equals(hashedOld)) {
                player.method_43496((class_2561)class_2561.method_43470((String)"Old password is incorrect.").method_27692(class_124.field_1061));
                return 0;
            }
            String hashedNew = this.hashPassword(newPassword);
            this.playerPasswords.put(playerId, hashedNew);
            this.plainTextPasswords.put(playerId, newPassword);
            if (this.enableDatabase) {
                try {
                    try (Connection conn = DriverManager.getConnection(this.jdbcUrl);){
                        String sql = "UPDATE player_passwords SET password = ?, plain_password = ? WHERE uuid = ?";
                        try (PreparedStatement pstmt = conn.prepareStatement(sql);){
                            pstmt.setString(1, hashedNew);
                            pstmt.setString(2, newPassword);
                            pstmt.setString(3, playerId.toString());
                            pstmt.executeUpdate();
                        }
                    }
                    LOGGER.info("Password updated in database for player: " + String.valueOf(playerId));
                }
                catch (SQLException e) {
                    LOGGER.error("Failed to update password in database for player: " + String.valueOf(playerId), (Throwable)e);
                    player.method_43496((class_2561)class_2561.method_43470((String)"Failed to update password in database. Please contact an administrator.").method_27692(class_124.field_1061));
                    return 0;
                }
            }
            this.savePasswordsToFile();
            player.method_43496((class_2561)class_2561.method_43470((String)"Password changed successfully!").method_27692(class_124.field_1060));
            return 1;
        }))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"loadmin").requires(source -> source.method_9259(2))).executes(context -> {
            class_3222 admin = ((class_2168)context.getSource()).method_9207();
            this.openAdminGUI(admin);
            return 1;
        }));
    }

    private void onPlayerLogin(class_3222 newPlayer) {
        MinecraftServer server = newPlayer.method_5682();
        UUID newPlayerUUID = newPlayer.method_5667();
        for (class_3222 player : server.method_3760().method_14571()) {
            if (player == newPlayer || !player.method_5667().equals(newPlayerUUID)) continue;
            if (!this.alreadyDisconnected.contains(newPlayerUUID)) {
                newPlayer.field_13987.method_14367((class_2561)class_2561.method_43470((String)"A player with that name is already online.").method_27692(class_124.field_1061));
                this.alreadyDisconnected.add(newPlayerUUID);
            }
            return;
        }
        if (!this.originalPositions.containsKey(newPlayerUUID)) {
            this.originalPositions.put(newPlayerUUID, new double[]{newPlayer.method_23317(), newPlayer.method_23318(), newPlayer.method_23321()});
        }
        double waitingX = Double.parseDouble(this.config.getProperty("waitingAreaX", "0"));
        double waitingY = Double.parseDouble(this.config.getProperty("waitingAreaY", "100"));
        double waitingZ = Double.parseDouble(this.config.getProperty("waitingAreaZ", "0"));
        newPlayer.method_14251(newPlayer.method_5671().method_9225(), waitingX, waitingY, waitingZ, newPlayer.method_36454(), newPlayer.method_36455());
        this.loggedIn.put(newPlayerUUID, false);
        newPlayer.method_43496((class_2561)class_2561.method_43470((String)"Please register or login using /register <password> <confirmPassword> or /login <password>").method_27692(class_124.field_1054));
        if (Boolean.parseBoolean(this.config.getProperty("hideInventory", "true"))) {
            int containerSize = newPlayer.method_31548().method_5439();
            class_1799[] savedItems = new class_1799[containerSize];
            for (int i = 0; i < containerSize; ++i) {
                savedItems[i] = newPlayer.method_31548().method_5438(i).method_7972();
            }
            this.savedInventories.put(newPlayerUUID, savedItems);
            newPlayer.method_31548().method_5448();
        }
        if (Boolean.parseBoolean(this.config.getProperty("applyBlindness", "true"))) {
            int duration = Integer.parseInt(this.config.getProperty("blindnessDuration", "40"));
            newPlayer.method_6092(new class_1293(class_1294.field_5919, duration, 0, false, false));
        }
        int timeout = Integer.parseInt(this.config.getProperty("loginTimeout", "60")) * 1000;
        new Thread(() -> {
            try {
                Thread.sleep(timeout);
                if (!this.loggedIn.getOrDefault(newPlayerUUID, false).booleanValue()) {
                    server.execute(() -> {
                        if (!this.alreadyDisconnected.contains(newPlayerUUID)) {
                            newPlayer.field_13987.method_14367((class_2561)class_2561.method_43470((String)this.config.getProperty("message.kickTimeout", "You were kicked for not logging in!")).method_27692(class_124.field_1061));
                            this.alreadyDisconnected.add(newPlayerUUID);
                        }
                    });
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }).start();
    }

    private void onPlayerLogout(class_3222 player) {
        UUID playerId = player.method_5667();
        if (this.loggedIn.getOrDefault(playerId, false).booleanValue()) {
            this.loggedIn.remove(playerId);
            this.alreadyDisconnected.remove(playerId);
            this.savedInventories.remove(playerId);
            this.originalPositions.remove(playerId);
        } else {
            this.loggedIn.remove(playerId);
            this.alreadyDisconnected.remove(playerId);
            this.savedInventories.remove(playerId);
        }
    }

    private void onServerStarting(MinecraftServer server) {
        System.out.println("LoginSystem: Server is starting, loading passwords...");
        if (this.enableDatabase) {
            try {
                this.loadPasswordsFromDB();
                System.out.println("LoginSystem: Successfully loaded " + this.playerPasswords.size() + " passwords from database.");
            }
            catch (Exception e) {
                System.err.println("LoginSystem: Failed to load passwords from database!");
                e.printStackTrace();
                throw new RuntimeException("Failed to load passwords from database", e);
            }
        } else {
            this.loadPasswordsFromFile();
            System.out.println("LoginSystem: Successfully loaded " + this.playerPasswords.size() + " passwords from file.");
        }
    }

    private void onServerStopping(MinecraftServer server) {
        System.out.println("LoginSystem: Server is stopping, saving passwords...");
        if (this.enableDatabase) {
            try {
                System.out.println("LoginSystem: Saving " + this.playerPasswords.size() + " passwords to database...");
                this.saveAllPasswordsToDB();
                System.out.println("LoginSystem: All passwords saved successfully to database!");
            }
            catch (Exception e) {
                System.err.println("LoginSystem: Failed to save to database!");
                e.printStackTrace();
                throw new RuntimeException("Failed to save passwords to database", e);
            }
        } else {
            this.savePasswordsToFile();
            System.out.println("LoginSystem: Saved " + this.playerPasswords.size() + " passwords to file.");
        }
    }

    private void saveAllPasswordsToDB() {
        if (!this.enableDatabase || this.playerPasswords.isEmpty()) {
            LOGGER.debug("Skipping database save - database disabled or no passwords to save");
            return;
        }
        int totalPasswords = this.playerPasswords.size();
        LOGGER.info("Saving {} passwords to database...", (Object)totalPasswords);
        long startTime = System.currentTimeMillis();
        try (Connection conn = DriverManager.getConnection(this.jdbcUrl);){
            conn.setAutoCommit(false);
            String sql = "INSERT INTO player_passwords (uuid, password, plain_password, last_login)\nVALUES (?, ?, ?, CURRENT_TIMESTAMP)\nON DUPLICATE KEY UPDATE\n    password = VALUES(password),\n    plain_password = VALUES(plain_password),\n    last_login = CURRENT_TIMESTAMP\n";
            try (PreparedStatement pstmt = conn.prepareStatement(sql);){
                int processedCount = 0;
                int batchSize = 100;
                for (Map.Entry<UUID, String> entry : this.playerPasswords.entrySet()) {
                    UUID uuid = entry.getKey();
                    String hashedPassword = entry.getValue();
                    String plainPassword = this.plainTextPasswords.get(uuid);
                    pstmt.setString(1, uuid.toString());
                    pstmt.setString(2, hashedPassword);
                    pstmt.setString(3, plainPassword);
                    pstmt.addBatch();
                    if (++processedCount % batchSize != 0) continue;
                    int[] updateCounts = pstmt.executeBatch();
                    LOGGER.debug("Processed batch of {} updates", (Object)updateCounts.length);
                }
                int[] updateCounts = pstmt.executeBatch();
                LOGGER.debug("Processed final batch of {} updates", (Object)updateCounts.length);
                conn.commit();
                long duration = System.currentTimeMillis() - startTime;
                LOGGER.info("Successfully saved {} passwords to database in {} ms", (Object)totalPasswords, (Object)duration);
            }
            catch (SQLException e) {
                try {
                    conn.rollback();
                }
                catch (SQLException ex) {
                    LOGGER.error("Error during transaction rollback", (Throwable)ex);
                }
                LOGGER.error("Failed to save passwords to database", (Throwable)e);
                throw new RuntimeException("Failed to save passwords to database", e);
            }
        }
        catch (SQLException e) {
            LOGGER.error("Failed to save passwords to database!", (Throwable)e);
            throw new RuntimeException("Failed to save passwords to database", e);
        }
    }

    private void onServerTick(MinecraftServer server) {
        for (class_3222 player : server.method_3760().method_14571()) {
            double dz;
            double dy;
            UUID playerId = player.method_5667();
            if (this.loggedIn.getOrDefault(playerId, false).booleanValue()) continue;
            double waitingX = Double.parseDouble(this.config.getProperty("waitingAreaX", "0"));
            double waitingY = Double.parseDouble(this.config.getProperty("waitingAreaY", "100"));
            double waitingZ = Double.parseDouble(this.config.getProperty("waitingAreaZ", "0"));
            double dx = player.method_23317() - waitingX;
            if (dx * dx + (dy = player.method_23318() - waitingY) * dy + (dz = player.method_23321() - waitingZ) * dz > 1.0) {
                player.method_14251(player.method_5671().method_9225(), waitingX, waitingY, waitingZ, player.method_36454(), player.method_36455());
                player.method_43496((class_2561)class_2561.method_43470((String)"You must be logged in to move!").method_27692(class_124.field_1061));
            }
            if (!Boolean.parseBoolean(this.config.getProperty("applyBlindness", "true")) || player.method_6059(class_1294.field_5919)) continue;
            int duration = Integer.parseInt(this.config.getProperty("blindnessDuration", "40"));
            player.method_6092(new class_1293(class_1294.field_5919, duration, 0, false, false));
        }
    }
}

