/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.client;

import org.mariadb.jdbc.client.ColumnDecoder;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.column.BigDecimalColumn;
import org.mariadb.jdbc.client.column.BitColumn;
import org.mariadb.jdbc.client.column.BlobColumn;
import org.mariadb.jdbc.client.column.DateColumn;
import org.mariadb.jdbc.client.column.DoubleColumn;
import org.mariadb.jdbc.client.column.FloatColumn;
import org.mariadb.jdbc.client.column.GeometryColumn;
import org.mariadb.jdbc.client.column.JsonColumn;
import org.mariadb.jdbc.client.column.SignedBigIntColumn;
import org.mariadb.jdbc.client.column.SignedIntColumn;
import org.mariadb.jdbc.client.column.SignedMediumIntColumn;
import org.mariadb.jdbc.client.column.SignedSmallIntColumn;
import org.mariadb.jdbc.client.column.SignedTinyIntColumn;
import org.mariadb.jdbc.client.column.StringColumn;
import org.mariadb.jdbc.client.column.TimeColumn;
import org.mariadb.jdbc.client.column.TimestampColumn;
import org.mariadb.jdbc.client.column.UnsignedBigIntColumn;
import org.mariadb.jdbc.client.column.UnsignedIntColumn;
import org.mariadb.jdbc.client.column.UnsignedMediumIntColumn;
import org.mariadb.jdbc.client.column.UnsignedSmallIntColumn;
import org.mariadb.jdbc.client.column.UnsignedTinyIntColumn;
import org.mariadb.jdbc.client.column.YearColumn;

public enum DataType {
    OLDDECIMAL(0, BigDecimalColumn::new, BigDecimalColumn::new),
    TINYINT(1, SignedTinyIntColumn::new, UnsignedTinyIntColumn::new),
    SMALLINT(2, SignedSmallIntColumn::new, UnsignedSmallIntColumn::new),
    INTEGER(3, SignedIntColumn::new, UnsignedIntColumn::new),
    FLOAT(4, FloatColumn::new, FloatColumn::new),
    DOUBLE(5, DoubleColumn::new, DoubleColumn::new),
    NULL(6, StringColumn::new, StringColumn::new),
    TIMESTAMP(7, TimestampColumn::new, TimestampColumn::new),
    BIGINT(8, SignedBigIntColumn::new, UnsignedBigIntColumn::new),
    MEDIUMINT(9, SignedMediumIntColumn::new, UnsignedMediumIntColumn::new),
    DATE(10, DateColumn::new, DateColumn::new),
    TIME(11, TimeColumn::new, TimeColumn::new),
    DATETIME(12, TimestampColumn::new, TimestampColumn::new),
    YEAR(13, YearColumn::new, YearColumn::new),
    NEWDATE(14, DateColumn::new, DateColumn::new),
    VARCHAR(15, StringColumn::new, StringColumn::new),
    BIT(16, BitColumn::new, BitColumn::new),
    JSON(245, JsonColumn::new, JsonColumn::new),
    DECIMAL(246, BigDecimalColumn::new, BigDecimalColumn::new),
    ENUM(247, StringColumn::new, StringColumn::new),
    SET(248, StringColumn::new, StringColumn::new),
    TINYBLOB(249, BlobColumn::new, BlobColumn::new),
    MEDIUMBLOB(250, BlobColumn::new, BlobColumn::new),
    LONGBLOB(251, BlobColumn::new, BlobColumn::new),
    BLOB(252, BlobColumn::new, BlobColumn::new),
    VARSTRING(253, StringColumn::new, StringColumn::new),
    STRING(254, StringColumn::new, StringColumn::new),
    GEOMETRY(255, GeometryColumn::new, GeometryColumn::new);

    static final DataType[] typeMap;
    private final int mariadbType;
    private final ColumnConstructor columnConstructor;
    private final ColumnConstructor unsignedColumnConstructor;

    private DataType(int mariadbType, ColumnConstructor columnConstructor, ColumnConstructor unsignedColumnConstructor) {
        this.mariadbType = mariadbType;
        this.columnConstructor = columnConstructor;
        this.unsignedColumnConstructor = unsignedColumnConstructor;
    }

    public int get() {
        return this.mariadbType;
    }

    public static DataType of(int typeValue) {
        return typeMap[typeValue];
    }

    public ColumnConstructor getColumnConstructor() {
        return this.columnConstructor;
    }

    public ColumnConstructor getUnsignedColumnConstructor() {
        return this.unsignedColumnConstructor;
    }

    static {
        typeMap = new DataType[256];
        DataType[] dataTypeArray = DataType.values();
        int n = dataTypeArray.length;
        for (int i = 0; i < n; ++i) {
            DataType v;
            DataType.typeMap[v.mariadbType] = v = dataTypeArray[i];
        }
    }

    @FunctionalInterface
    public static interface ColumnConstructor {
        public ColumnDecoder create(ReadableByteBuf var1, int var2, long var3, DataType var5, byte var6, int var7, int[] var8, String var9, String var10);
    }
}

