import os
from PIL import Image

def process_images_in_folder(folder_path):
    for filename in os.listdir(folder_path):
        if filename.lower().endswith(('png', 'jpg', 'jpeg', 'gif')):  # check for image files
            img_path = os.path.join(folder_path, filename)
            try:
                img = Image.open(img_path).convert("RGBA")  # open and convert to RGBA (to handle transparency)
                data = img.getdata()  # get all pixel data

                new_data = []
                for pixel in data:
                    r, g, b, a = pixel
                    if a < 128:  # if the alpha is less than 50%, we remove the pixel (making it fully transparent)
                        new_data.append((r, g, b, 0))
                    else:
                        new_data.append((r, g, b, 255))  # set alpha to 100% (255)

                img.putdata(new_data)
                img.save(img_path)  # save the modified image

                print(f"Processed: {filename}")
            except Exception as e:
                print(f"Failed to process {filename}: {e}")

def main():
    folder = input("Enter the folder path: ")
    if os.path.isdir(folder):
        process_images_in_folder(folder)
        print("Done processing all images!")
    else:
        print("That folder doesn't exist or is invalid!")

if __name__ == "__main__":
    main()
