/*
 * Decompiled with CFR 0.152.
 */
package io.delilaheve.util;

import io.delilaheve.CustomAnvil;
import io.delilaheve.util.ConfigOptions;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import xyz.alexcrea.cuanvil.config.ConfigHolder;
import xyz.alexcrea.cuanvil.enchant.CAEnchantment;
import xyz.alexcrea.cuanvil.group.ConflictType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JF\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\n*\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lio/delilaheve/util/EnchantmentUtil;", "", "<init>", "()V", "enchantmentName", "", "Lxyz/alexcrea/cuanvil/enchant/CAEnchantment;", "getEnchantmentName", "(Lxyz/alexcrea/cuanvil/enchant/CAEnchantment;)Ljava/lang/String;", "combineWith", "", "", "", "other", "item", "Lorg/bukkit/inventory/ItemStack;", "player", "Lorg/bukkit/entity/HumanEntity;", "CustomAnvil"})
@SourceDebugExtension(value={"SMAP\nEnchantmentUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnchantmentUtil.kt\nio/delilaheve/util/EnchantmentUtil\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,118:1\n216#2,2:119\n*S KotlinDebug\n*F\n+ 1 EnchantmentUtil.kt\nio/delilaheve/util/EnchantmentUtil\n*L\n40#1:119,2\n*E\n"})
public final class EnchantmentUtil {
    @NotNull
    public static final EnchantmentUtil INSTANCE = new EnchantmentUtil();

    private EnchantmentUtil() {
    }

    @NotNull
    public final String getEnchantmentName(@NotNull CAEnchantment $this$enchantmentName) {
        Intrinsics.checkNotNullParameter((Object)$this$enchantmentName, (String)"<this>");
        String string = $this$enchantmentName.getKey().getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
        return string;
    }

    @NotNull
    public final Map<CAEnchantment, Integer> combineWith(@NotNull Map<CAEnchantment, Integer> $this$combineWith, @NotNull Map<CAEnchantment, Integer> other, @NotNull ItemStack item, @NotNull HumanEntity player) {
        Map map;
        Intrinsics.checkNotNullParameter($this$combineWith, (String)"<this>");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Map $this$combineWith_u24lambda_u241 = map = (Map)new LinkedHashMap();
        boolean bl = false;
        $this$combineWith_u24lambda_u241.putAll($this$combineWith);
        boolean bypassFuse = player.hasPermission("ca.bypass.fuse");
        boolean bypassLevel = player.hasPermission("ca.bypass.level");
        Integer maxEnchantCount = null;
        Material material = item.getType();
        Intrinsics.checkNotNullExpressionValue((Object)material, (String)"getType(...)");
        maxEnchantCount = ConfigOptions.INSTANCE.getEnchantCountLimit(material);
        if (maxEnchantCount == null || ((Number)maxEnchantCount).intValue() < 0) {
            maxEnchantCount = Integer.MAX_VALUE;
        }
        Map<CAEnchantment, Integer> $this$forEach$iv = other;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<CAEnchantment, Integer>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            int maxBeforeDisabled;
            Map.Entry<CAEnchantment, Integer> element$iv;
            Map.Entry<CAEnchantment, Integer> entry = element$iv = iterator.next();
            boolean bl2 = false;
            CAEnchantment enchantment = entry.getKey();
            int level = ((Number)entry.getValue()).intValue();
            if (!enchantment.isAllowed(player)) continue;
            int maxLevel = bypassLevel ? 255 : ConfigOptions.INSTANCE.enchantLimit(enchantment);
            CustomAnvil.Companion.verboseLog("Max level of " + enchantment.getKey() + " is " + maxLevel + " (bypassLevel is " + bypassLevel + ")");
            int cappedLevel = Math.min(level, maxLevel);
            if (!$this$combineWith_u24lambda_u241.containsKey(enchantment)) {
                if ($this$combineWith_u24lambda_u241.size() >= ((Number)maxEnchantCount).intValue()) continue;
                Integer n = cappedLevel;
                $this$combineWith_u24lambda_u241.put(enchantment, n);
                if (bypassFuse) {
                    CustomAnvil.Companion.verboseLog("Bypassed conflict check for " + enchantment.getKey());
                    continue;
                }
                ConflictType conflictType = ConfigHolder.CONFLICT_HOLDER.getConflictManager().isConflicting($this$combineWith_u24lambda_u241, item, enchantment);
                if (conflictType == ConflictType.NO_CONFLICT) continue;
                CustomAnvil.Companion.verboseLog("Enchantment not yet in result list, but there is conflict (" + enchantment.getKey() + ", conflict: " + conflictType + ")");
                $this$combineWith_u24lambda_u241.remove(enchantment);
                continue;
            }
            Object v = $this$combineWith_u24lambda_u241.get(enchantment);
            Intrinsics.checkNotNull(v);
            int oldLevel = ((Number)v).intValue();
            if (bypassFuse) {
                CustomAnvil.Companion.verboseLog("Bypassed conflict check for " + enchantment.getKey());
            } else {
                ConflictType conflictType = ConfigHolder.CONFLICT_HOLDER.getConflictManager().isConflicting($this$combineWith_u24lambda_u241, item, enchantment);
                if (conflictType != ConflictType.NO_CONFLICT) {
                    CustomAnvil.Companion.verboseLog("Enchantment already in result list, and they are conflicting (" + enchantment.getKey() + ", conflict: " + conflictType + ")");
                    continue;
                }
            }
            if (oldLevel != cappedLevel) {
                $this$combineWith_u24lambda_u241.put(enchantment, Math.max(oldLevel, cappedLevel));
                continue;
            }
            if (!bypassLevel && (maxBeforeDisabled = ConfigOptions.INSTANCE.maxBeforeMergeDisabled(enchantment)) > 0 && oldLevel >= maxBeforeDisabled) {
                CustomAnvil.Companion.verboseLog("Reached max merge before disable for " + enchantment.getKey() + ": " + oldLevel + "/" + maxBeforeDisabled + ")");
                continue;
            }
            int newLevel = oldLevel + 1;
            newLevel = Math.max(Math.min(newLevel, maxLevel), oldLevel);
            Integer n = newLevel;
            $this$combineWith_u24lambda_u241.put(enchantment, n);
        }
        return map;
    }
}

