/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.api;

import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.alexcrea.cuanvil.api.CustomAnvilRecipeApi;
import xyz.alexcrea.cuanvil.recipe.AnvilCustomRecipe;

public class AnvilRecipeBuilder {
    @NotNull
    private String name;
    private boolean exactCount;
    private int levelCostPerCraft;
    private int linearXpCostPerCraft;
    private boolean removeExactLinearXp;
    @Nullable
    private ItemStack leftItem;
    @Nullable
    private ItemStack rightItem;
    @Nullable
    private ItemStack resultItem;

    public AnvilRecipeBuilder(@NotNull String name) {
        this.name = name;
        this.exactCount = true;
        this.levelCostPerCraft = 0;
        this.linearXpCostPerCraft = 0;
        this.removeExactLinearXp = false;
        this.leftItem = null;
        this.rightItem = null;
        this.resultItem = null;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public AnvilRecipeBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public boolean isExactCount() {
        return this.exactCount;
    }

    public AnvilRecipeBuilder setExactCount(boolean exactCount) {
        this.exactCount = exactCount;
        return this;
    }

    @Deprecated(since="1.13.0")
    public int getXpCostPerCraft() {
        return this.getLevelCostPerCraft();
    }

    @Deprecated(since="1.13.0")
    public AnvilRecipeBuilder setXpCostPerCraft(int xpCostPerCraft) {
        return this.setLevelCostPerCraft(xpCostPerCraft);
    }

    public int getLevelCostPerCraft() {
        return this.levelCostPerCraft;
    }

    public AnvilRecipeBuilder setLevelCostPerCraft(int levelCostPerCraft) {
        this.levelCostPerCraft = levelCostPerCraft;
        return this;
    }

    public int getLinearXpCostPerCraft() {
        return this.linearXpCostPerCraft;
    }

    public AnvilRecipeBuilder setLinearXpCostPerCraft(int linearXpCostPerCraft) {
        this.linearXpCostPerCraft = linearXpCostPerCraft;
        return this;
    }

    public boolean isRemoveExactLinearXp() {
        return this.removeExactLinearXp;
    }

    public AnvilRecipeBuilder setRemoveExactLinearXp(boolean removeExactLinearXp) {
        this.removeExactLinearXp = removeExactLinearXp;
        return this;
    }

    @Nullable
    public ItemStack getLeftItem() {
        return this.leftItem;
    }

    public AnvilRecipeBuilder setLeftItem(ItemStack leftItem) {
        this.leftItem = leftItem;
        return this;
    }

    @Nullable
    public ItemStack getRightItem() {
        return this.rightItem;
    }

    public AnvilRecipeBuilder setRightItem(ItemStack rightItem) {
        this.rightItem = rightItem;
        return this;
    }

    @Nullable
    public ItemStack getResultItem() {
        return this.resultItem;
    }

    public AnvilRecipeBuilder setResultItem(ItemStack resultItem) {
        this.resultItem = resultItem;
        return this;
    }

    @Nullable
    public AnvilCustomRecipe build() {
        if (this.leftItem == null || this.resultItem == null) {
            return null;
        }
        return new AnvilCustomRecipe(this.name, this.exactCount, this.levelCostPerCraft, this.linearXpCostPerCraft, this.removeExactLinearXp, this.leftItem, this.rightItem, this.resultItem);
    }

    public boolean registerIfAbsent() {
        return CustomAnvilRecipeApi.addRecipe(this);
    }
}

