/*
 * Decompiled with CFR 0.152.
 */
package xyz.alexcrea.cuanvil.gui.config.global;

import io.delilaheve.CustomAnvil;
import io.delilaheve.util.ConfigOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import kotlin.ranges.IntRange;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.alexcrea.cuanvil.config.ConfigHolder;
import xyz.alexcrea.cuanvil.dependency.packet.PacketManager;
import xyz.alexcrea.cuanvil.gui.ValueUpdatableGui;
import xyz.alexcrea.cuanvil.gui.config.MainConfigGui;
import xyz.alexcrea.cuanvil.gui.config.settings.BoolSettingsGui;
import xyz.alexcrea.cuanvil.gui.config.settings.IntSettingsGui;
import xyz.alexcrea.cuanvil.gui.config.settings.WorkPenaltyTypeSettingGui;
import xyz.alexcrea.cuanvil.gui.util.GuiGlobalActions;
import xyz.alexcrea.cuanvil.gui.util.GuiGlobalItems;
import xyz.alexcrea.inventoryframework.gui.GuiItem;
import xyz.alexcrea.inventoryframework.gui.type.ChestGui;
import xyz.alexcrea.inventoryframework.gui.type.util.Gui;
import xyz.alexcrea.inventoryframework.pane.Pane;
import xyz.alexcrea.inventoryframework.pane.PatternPane;
import xyz.alexcrea.inventoryframework.pane.util.Pattern;

public class BasicConfigGui
extends ChestGui
implements ValueUpdatableGui {
    private static BasicConfigGui INSTANCE = null;
    private final PacketManager packetManager;
    PatternPane pane;
    private BoolSettingsGui.BoolSettingFactory capAnvilCost;
    private GuiItem noCapRepairItem;
    private IntSettingsGui.IntSettingFactory maxAnvilCost;
    private GuiItem noMaxCostItem;
    private BoolSettingsGui.BoolSettingFactory removeAnvilCostLimit;
    private BoolSettingsGui.BoolSettingFactory replaceTooExpensive;
    private IntSettingsGui.IntSettingFactory itemRepairCost;
    private IntSettingsGui.IntSettingFactory unitRepairCost;
    private IntSettingsGui.IntSettingFactory itemRenameCost;
    private IntSettingsGui.IntSettingFactory sacrificeIllegalEnchantCost;
    private BoolSettingsGui.BoolSettingFactory allowColorCode;
    private BoolSettingsGui.BoolSettingFactory allowHexColor;
    private BoolSettingsGui.BoolSettingFactory permissionNeededForColor;
    private GuiItem noPermissionNeededItem;
    private IntSettingsGui.IntSettingFactory useOfColorCost;
    private GuiItem noColorCostItem;

    @Nullable
    public static BasicConfigGui getInstance() {
        return INSTANCE;
    }

    public BasicConfigGui(PacketManager packetManager) {
        super(4, "\u00a78Basic Config", (Plugin)CustomAnvil.instance);
        if (INSTANCE == null) {
            INSTANCE = this;
        }
        this.packetManager = packetManager;
        this.init();
    }

    private void init() {
        Pattern pattern = new Pattern(new String[]{"000000000", "LT0IWS0cp", "CR0U0r0hP", "B00000000"});
        this.pane = new PatternPane(0, 0, 9, 4, pattern);
        this.addPane((Pane)this.pane);
        GuiGlobalItems.addBackItem(this.pane, (Gui)MainConfigGui.getInstance());
        GuiGlobalItems.addBackgroundItem(this.pane);
        this.prepareValues();
        this.updateGuiValues();
    }

    protected void prepareValues() {
        this.capAnvilCost = new BoolSettingsGui.BoolSettingFactory("\u00a78Cap Anvil Cost ?", this, ConfigHolder.DEFAULT_CONFIG, "limit_repair_cost", false, "\u00a77All anvil cost will be capped to \u00a7aMax Anvil Cost\u00a77 if enabled.", "\u00a77In other words:", "\u00a77For any anvil cost greater than \u00a7aMax Anvil Cost\u00a77, Cost will be set to \u00a7aMax Anvil Cost\u00a77.");
        ItemStack item = new ItemStack(Material.BARRIER);
        ItemMeta meta = item.getItemMeta();
        assert (meta != null);
        meta.setDisplayName("\u00a7cCap Anvil Cost ?");
        meta.setLore(Collections.singletonList("\u00a77This config only work if \u00a7cLimit Repair Cost\u00a77 is disabled."));
        item.setItemMeta(meta);
        this.noCapRepairItem = new GuiItem(item, GuiGlobalActions.stayInPlace, (Plugin)CustomAnvil.instance);
        IntRange range = ConfigOptions.MAX_ANVIL_COST_RANGE;
        this.maxAnvilCost = new IntSettingsGui.IntSettingFactory("\u00a78Max Anvil Cost", this, "limit_repair_value", ConfigHolder.DEFAULT_CONFIG, Arrays.asList("\u00a77Max cost the Anvil can get to.", "\u00a77Valid values include \u00a7e0 \u00a77to \u00a7e1000\u00a77.", "\u00a77Cost will be displayed as \u00a7cToo Expensive\u00a77:", "\u00a77- If Cost is above \u00a7e39", "\u00a77- And \u00a7eReplace Too Expensive\u00a77 is disabled"), range.getFirst(), range.getLast(), 39, 1, 5, 10);
        item = new ItemStack(Material.BARRIER);
        meta = item.getItemMeta();
        assert (meta != null);
        meta.setDisplayName("\u00a7cMax Anvil Cost");
        meta.setLore(Collections.singletonList("\u00a77This config only work if \u00a7cLimit Repair Cost\u00a77 is disabled."));
        item.setItemMeta(meta);
        this.noMaxCostItem = new GuiItem(item, GuiGlobalActions.stayInPlace, (Plugin)CustomAnvil.instance);
        this.removeAnvilCostLimit = new BoolSettingsGui.BoolSettingFactory("\u00a78Remove Anvil Cost Limit ?", this, ConfigHolder.DEFAULT_CONFIG, "remove_repair_limit", false, "\u00a77Whether the anvil's cost limit should be removed entirely.", "\u00a77The anvil will still visually display \u00a7cToo Expensive\u00a77 if \u00a7eReplace Too Expensive\u00a77 is disabled.", "\u00a77However, the action will be completable if xp requirement is meet.");
        this.replaceTooExpensive = new BoolSettingsGui.BoolSettingFactory("\u00a78Replace Too Expensive ?", this, ConfigHolder.DEFAULT_CONFIG, "replace_too_expensive", false, this.getReplaceToExpensiveLore());
        range = ConfigOptions.REPAIR_COST_RANGE;
        this.itemRepairCost = new IntSettingsGui.IntSettingFactory("\u00a78Item Repair Cost", this, "item_repair_cost", ConfigHolder.DEFAULT_CONFIG, Arrays.asList("\u00a77XP Level amount added to the anvil when the item", "\u00a77is repaired by another item of the same type."), range.getFirst(), range.getLast(), 2, 1, 5, 10, 50, 100);
        this.unitRepairCost = new IntSettingsGui.IntSettingFactory("\u00a78Unit Repair Cost", this, "unit_repair_cost", ConfigHolder.DEFAULT_CONFIG, Arrays.asList("\u00a77XP Level amount added to the anvil when the item is repaired by an \u00a7eunit\u00a77.", "\u00a77For example: a Diamond on a Diamond Sword.", "\u00a77What's considered unit for what can be edited on the unit repair configuration."), range.getFirst(), range.getLast(), 1, 1, 5, 10, 50, 100);
        range = ConfigOptions.ITEM_RENAME_COST_RANGE;
        this.itemRenameCost = new IntSettingsGui.IntSettingFactory("\u00a78Rename Cost", this, "item_rename_cost", ConfigHolder.DEFAULT_CONFIG, Arrays.asList("\u00a77XP Level amount added to the anvil when the item is renamed."), range.getFirst(), range.getLast(), 1, 1, 5, 10, 50, 100);
        range = ConfigOptions.SACRIFICE_ILLEGAL_COST_RANGE;
        this.sacrificeIllegalEnchantCost = new IntSettingsGui.IntSettingFactory("\u00a78Sacrifice Illegal Enchant Cost", this, "sacrifice_illegal_enchant_cost", ConfigHolder.DEFAULT_CONFIG, Arrays.asList("\u00a77XP Level amount added to the anvil when a sacrifice enchantment", "\u00a77conflict With one of the left item enchantment"), range.getFirst(), range.getLast(), 1, 1, 5, 10, 50, 100);
        this.allowColorCode = new BoolSettingsGui.BoolSettingFactory("\u00a78Allow Use Of Color Code ?", this, ConfigHolder.DEFAULT_CONFIG, "allow_color_code", false, "\u00a77Whether players can use color code.", "\u00a77Color code a formatted like \u00a7a&a\u00a77 and is used in the rename field of the anvil.", "\u00a77Player may need permission to use color code if \u00a7ePlayer need permission to use color\u00a77 is enabled.");
        this.allowHexColor = new BoolSettingsGui.BoolSettingFactory("\u00a78Allow Use Of Hexadecimal Color ?", this, ConfigHolder.DEFAULT_CONFIG, "allow_hexadecimal_color", false, "\u00a77Whether players can use hexadecimal color.", "\u00a77Color code a formatted like \u00a72#012345 \u00a77and is used in the rename field of the anvil.", "\u00a77Player may need permission to use color code if \u00a7ePermission Needed For Color\u00a77 is enabled.");
        this.permissionNeededForColor = new BoolSettingsGui.BoolSettingFactory("\u00a78Need Permission To Use Color ?", this, ConfigHolder.DEFAULT_CONFIG, "permission_needed_for_color", true, "\u00a77Whether players should have permission to be able to use colors.", "\u00a77Give player \u00a7eca.color.code\u00a77 Permission to allow use of color code.", "\u00a77Give player \u00a7eca.color.hex\u00a77  Permission to allow use of hexadecimal color.");
        item = new ItemStack(Material.BARRIER);
        meta = item.getItemMeta();
        assert (meta != null);
        meta.setDisplayName("\u00a7cNeed Permission To Use Color ?");
        meta.setLore(Arrays.asList("\u00a77This config can do something only if one of the following config is enabled:", "\u00a77- \u00a7aAllow Use Of Color Code", "\u00a77- \u00a7aAllow Use Of Hexadecimal Color"));
        item.setItemMeta(meta);
        this.noPermissionNeededItem = new GuiItem(item, GuiGlobalActions.stayInPlace, (Plugin)CustomAnvil.instance);
        range = ConfigOptions.USE_OF_COLOR_COST_RANGE;
        this.useOfColorCost = new IntSettingsGui.IntSettingFactory("\u00a78Cost Of Using Color", this, "use_of_color_cost", ConfigHolder.DEFAULT_CONFIG, Arrays.asList("\u00a77XP level cost when using color code or hexadecimal color using the anvil.", "\u00a77conflict With one of the left item enchantment"), range.getFirst(), range.getLast(), 0, 1, 5, 10, 50, 100);
        item = new ItemStack(Material.BARRIER);
        meta = item.getItemMeta();
        assert (meta != null);
        meta.setDisplayName("\u00a7cCost Of Using Color");
        meta.setLore(Arrays.asList("\u00a77This config can do something only if one of the following config is enabled:", "\u00a77- \u00a7aAllow Use Of Color Code", "\u00a77- \u00a7aAllow Use Of Hexadecimal Color"));
        item.setItemMeta(meta);
        this.noColorCostItem = new GuiItem(item, GuiGlobalActions.stayInPlace, (Plugin)CustomAnvil.instance);
    }

    @NotNull
    private String[] getReplaceToExpensiveLore() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Whenever anvil cost is above \u00a7e39\u00a77 should display the true price and not \u00a7cToo Expensive\u00a77.");
        lore.add("\u00a77However, when bypassing \u00a7cToo Expensive\u00a77, anvil price will be displayed as \u00a7aGreen\u00a77.");
        lore.add("\u00a77Even if cost is displayed as \u00a7aGreen\u00a77:");
        lore.add("\u00a77If the player do not have the required xp level, the action will not be completable.");
        if (!this.packetManager.getCanSetInstantBuild()) {
            lore.add("");
            lore.add("\u00a74/!\\\u00a7cCaution\u00a74/!\\ \u00a7cYou need ProtocoLib installed and working or a newer version of this plugin for this to work.");
            lore.add("\u00a7cCurrently ProtocoLib is not detected.");
        }
        String[] loreAsArray = new String[lore.size()];
        return lore.toArray(loreAsArray);
    }

    @Override
    public void updateGuiValues() {
        GuiItem maxAnvilCostItem;
        GuiItem capAnvilCostItem;
        if (!this.removeAnvilCostLimit.getConfiguredValue()) {
            capAnvilCostItem = this.capAnvilCost.getItem("Cap Anvil Cost");
            maxAnvilCostItem = this.maxAnvilCost.getItem(Material.EXPERIENCE_BOTTLE, "Max Anvil Cost");
        } else {
            capAnvilCostItem = this.noCapRepairItem;
            maxAnvilCostItem = this.noMaxCostItem;
        }
        this.pane.bindItem('L', capAnvilCostItem);
        this.pane.bindItem('C', maxAnvilCostItem);
        GuiItem removeRepairLimitItem = this.removeAnvilCostLimit.getItem("Remove Anvil Cost Limit");
        this.pane.bindItem('R', removeRepairLimitItem);
        GuiItem replaceToExpensiveItem = this.replaceTooExpensive.getItem();
        this.pane.bindItem('T', replaceToExpensiveItem);
        GuiItem itemRepairCostItem = this.itemRepairCost.getItem(Material.ANVIL);
        this.pane.bindItem('I', itemRepairCostItem);
        GuiItem unitRepairCostItem = this.unitRepairCost.getItem(Material.DIAMOND);
        this.pane.bindItem('U', unitRepairCostItem);
        GuiItem itemRenameCostItem = this.itemRenameCost.getItem(Material.NAME_TAG);
        this.pane.bindItem('r', itemRenameCostItem);
        GuiItem illegalCostItem = this.sacrificeIllegalEnchantCost.getItem(Material.ENCHANTED_BOOK);
        this.pane.bindItem('S', illegalCostItem);
        GuiItem workPenaltyType = WorkPenaltyTypeSettingGui.getDisplayItem(this, Material.DAMAGED_ANVIL, "\u00a7aWork Penalty Type");
        this.pane.bindItem('W', workPenaltyType);
        GuiItem allowColorCodeItem = this.allowColorCode.getItem();
        this.pane.bindItem('c', allowColorCodeItem);
        GuiItem allowHexColorItem = this.allowHexColor.getItem();
        this.pane.bindItem('h', allowHexColorItem);
        if (ConfigOptions.INSTANCE.getRenameColorPossible()) {
            GuiItem permissionNeededItem = this.permissionNeededForColor.getItem();
            this.pane.bindItem('p', permissionNeededItem);
            GuiItem useColorCostItem = this.useOfColorCost.getItem(Material.EXPERIENCE_BOTTLE, "Use color");
            this.pane.bindItem('P', useColorCostItem);
        } else {
            this.pane.bindItem('p', this.noPermissionNeededItem);
            this.pane.bindItem('P', this.noColorCostItem);
        }
        this.update();
    }

    @Override
    public Gui getConnectedGui() {
        return this;
    }
}

